// #include README

#include "prologin.hh"
#include "colonisation.hh"
#include "iles.hh"
#include "volcans.hh"
#include "bateaux.hh"
#include "influence.hh"
#include "attaque.hh"
#include "debug.hh"

std::vector<struct PlanColonisation> plans_colonisation;

///
// Fonction appelée au début de la partie
//
void partie_init()
{
	plans_colonisation = make_plans_colonisation();
}

///
// Fonction appelée à chaque tour
//
void jouer_tour()
{
	// ============================ CARAVELLES ========================== //

	// Mise a jour des plans
	maj_plans_colonisation(plans_colonisation);

	// Construction des caravelles pour les plans
	bool caravellesNeeded = false;
	for(auto it = plans_colonisation.begin() ; it != plans_colonisation.end() ; ++it) {
		if(it->idCaravelle == -1) {
			if(construire_caravelle())
				it->idCaravelle = id_dernier_bateau_construit();
			else
				caravellesNeeded = true;
		}
	}

	// Mise a jour des caravelles affectees aux volcans
	if(maj_caravelles_volcans()) {
		if(construire_caravelle())
			affecter_caravelle_volcans(id_dernier_bateau_construit());
		else
			caravellesNeeded = true;
	}

	deplacer_caravelles_volcans();

	// Deplacement des caravelles et colonisation
	for(auto it = plans_colonisation.begin() ; it != plans_colonisation.end() ; ++it) {
		if(it->idCaravelle != -1) {
			position ile = find_next_colonisation(*it);
			position arriv;
			erreur err = debug_err(deplacer_vers(it->idCaravelle, ile, &arriv));
			if(err == OK && ile.x == arriv.x && ile.y == arriv.y)
				debug_err(coloniser(ile));
		}
	}


	// ======================== ATTAQUE / DEFENSE ======================= //

	// Attaque
	attaquer();

	// Determination des influences
	Influences infs = calcule_influences();

	// Determination de la frontiere
	Frontiere frontiere = find_frontiere(infs);

	// Deplacement aleatoire des galions
	patrouiller_galions(frontiere);

	// Creation des galions
	construire_galions(infs, caravellesNeeded);
}

///
// Fonction appelée à la fin de la partie
//
void partie_fin()
{
	// fonction a completer
}

