#include "attaque.hh"

#include "prologin.hh"
#include "debug.hh"

#include <map>
#include <list>
#include <cmath>

struct Cible {
	position pos;
	int galions;
	bool caravelle;
	bool ile;
};

int minAttaquants(const struct Cible& cible) {
	if(cible.ile)
		return cible.galions + 1;
	else
		return cible.galions;
}

/*
 * On cherche les iles et flottes ennemies a attaquer. On preferera en priorite
 * prendre les iles et detruire les caravelles.
 */
void attaquer()
{
	std::multimap<int, struct Cible> cibles;

	// Evaluation des cibles
	position pos;
	for(pos.y = 0 ; pos.y < TAILLE_TERRAIN ; pos.y++) {
		for(pos.x = 0 ; pos.x < TAILLE_TERRAIN ; pos.x++) {
			int val = 0;

			Cible cible;
			cible.pos = pos;
			cible.galions = 0;
			cible.caravelle = false;
			cible.ile = false;

			terrain terr = info_terrain(pos);
			if(terr == TERRAIN_ILE || terr == TERRAIN_VOLCAN) {
				if(info_ile_joueur(pos) == ADV)
					val += 10000;
				cible.ile = true;
			}

			std::vector<bateau> bateaux = liste_bateaux_position(pos);
			for(auto bat = bateaux.begin() ; bat != bateaux.end() ; ++bat) {
				if(bat->joueur != ADV)
					continue;
				if(bat->btype == BATEAU_GALION) {
					val += 1;
					cible.galions++;
				}
				else if(bat->btype == BATEAU_CARAVELLE) {
					val += 1000;
					cible.caravelle = true;
				}
			}

			if(val > 0) {
				cibles.insert(std::pair<int, struct Cible>(val, cible));
			}
		}
	}


	// Tentatives d'attaque
	for(auto paire = cibles.rbegin() ; paire != cibles.rend() ; ++paire) {
		Cible cible = paire->second;
		std::list<int> attaquants;
		int nbAttaquants = 0;

		int minX = std::max(0, cible.pos.x - GALION_DEPLACEMENT),
			minY = std::max(0, cible.pos.y - GALION_DEPLACEMENT),
			maxX = std::min(TAILLE_TERRAIN-1, cible.pos.x + GALION_DEPLACEMENT),
			maxY = std::min(TAILLE_TERRAIN-1, cible.pos.y + GALION_DEPLACEMENT);

		// Recherche des attaquants
		position pos;
		for(pos.y=minY ; pos.y<=maxY ; pos.y++) {
			for(pos.x=minX ; pos.x<=maxX ; pos.x++) {
				if(distance(pos, cible.pos) > GALION_DEPLACEMENT)
					continue;

				std::vector<bateau> bateaux = liste_bateaux_position(pos);
				for(auto bat = bateaux.begin() ; bat != bateaux.end() ; ++bat) {
					if(bat->joueur != MOI || !bat->deplacable)
						continue;
					if(bat->btype == BATEAU_GALION) {
						attaquants.push_back(bat->id);
						nbAttaquants++;
					}
					else if(cible.caravelle == true) {
						attaquants.push_back(bat->id);
					}

					// Si ca se passe en mer, on s'en fiche d'avoir du rab'
					if(nbAttaquants >= minAttaquants(cible) && !cible.ile)
						goto raptor;
				}
			}
		}

		if(nbAttaquants < minAttaquants(cible))
			continue;

raptor:
		// Attaque
		for(auto batId = attaquants.begin() ; batId != attaquants.end() ; ++batId) {
			debug_err(deplacer(*batId, cible.pos));
		}
	}
}
