#include "colonisation.hh"

#include "prologin.hh"
#include "volcans.hh"

#include <random>
#include <algorithm>

class ComparePlanColonisation {
	private:
		position maison;

	public:
		ComparePlanColonisation(position maison) : maison(maison) { }
		bool operator()(const struct PlanColonisation& p1, const struct PlanColonisation& p2) {
			return distance(maison, p1.barycentre) < distance(maison, p2.barycentre);
		}
};

std::vector<position> get_iles_colonisables()
{
	std::vector<position> iles = liste_iles();
	position my_pos, adv_pos;

	// On enleve les iles colonisees
	for(auto it = iles.begin() ; it != iles.end() ; ) {
		int proprio = info_ile_joueur(*it);
		if(proprio != -1) {
			if(proprio == MOI) {
				my_pos.x = it->x;
				my_pos.y = it->y;
			}
			else {
				adv_pos.x = it->x;
				adv_pos.y = it->y;
			}
			it = iles.erase(it);
		}
		else {
			++it;
		}
	}

	// On enleve les iles plus proches de l'ennemi que de nous
	for(auto it = iles.begin() ; it != iles.end() ; ) {
		int disMoi = distance(my_pos, *it),
			disAdv = distance(adv_pos, *it);

		if(disMoi > disAdv)
			it = iles.erase(it);
		else
			++it;
	}

	return iles;
}


/*
 * On repartit les iles a coloniser parmi N caravelles, en utilisant un k-mean
 */
std::vector<struct PlanColonisation> make_plans_colonisation()
{
	std::vector<position> iles = get_iles_colonisables();

	// On determine la zone couverte par les iles
	int minX = TAILLE_TERRAIN,
		maxX = -1,
		minY = TAILLE_TERRAIN,
		maxY = -1;

	for(auto it = iles.begin() ; it != iles.end() ; ++it) {
		if(it->x > maxX) maxX = it->x;
		if(it->x < minX) minX = it->x;
		if(it->y > maxY) maxY = it->y;
		if(it->y < minY) minY = it->y;
	}

	// On initialise le k-mean
	int nbPlans = iles.size() / 4;
	if(nbPlans < 1) nbPlans = 1;

	std::vector<position> barycentres(nbPlans);

	std::random_device rd;
	std::mt19937 gen(rd());
	std::uniform_int_distribution<> disX(minX, maxX), disY(minY, maxY);
	for(int i=0 ; i<nbPlans ; i++) {
		barycentres[i].x = disX(gen);
		barycentres[i].y = disY(gen);
	}

	// On met a jour les barycentres un petit nombre de fois
	std::vector<position> totaux;
	std::vector<int> nbPoints;
	for(int i=0 ; i<50 ; i++) {
		position modele; modele.x = 0; modele.y = 0;
		totaux = std::vector<position>(nbPlans, modele);
		nbPoints = std::vector<int>(nbPlans, 0);

		for(auto ile =  iles.begin() ; ile != iles.end() ; ile++) {
			// On determine le point le plus proche
			int minDis = distance(*ile, barycentres[0]),
				minBar = 0;

			for(int bar=1 ; bar < nbPlans ; bar++) {
				int dis = distance(*ile, barycentres[bar]);
				if(dis < minDis) {
					minDis = dis;
					minBar = bar;
				}
			}

			// On met a jour
			totaux[minBar].x += ile->x;
			totaux[minBar].y += ile->y;
			nbPoints[minBar]++;
		}

		// On applique
		for(int j=0 ; j<nbPlans ; j++) {
			if(nbPoints[j] != 0) {
				barycentres[j].x = totaux[j].x / nbPoints[j];
				barycentres[j].y = totaux[j].y / nbPoints[j];
			}
		}
	}

	// On cree les plans
	std::vector<struct PlanColonisation> plans(nbPlans);
	for(int i=0 ; i<nbPlans ; i++) {
		plans[i].idCaravelle = -1;
		plans[i].barycentre = barycentres[i];
	}

	for(auto ile =  iles.begin() ; ile != iles.end() ; ile++) {
		// On determine le point le plus proche
		int minDis = distance(*ile, barycentres[0]),
			minBar = 0;

		for(int bar=1 ; bar < nbPlans ; bar++) {
			int dis = distance(*ile, barycentres[bar]);
			if(dis < minDis) {
				minDis = dis;
				minBar = bar;
			}
		}

		plans[minBar].iles.push_back(*ile);
	}

	// Enfin on trie les plans selon la distance entre leur barycentre et l'ile
	// initiale
	std::vector<position> maison = mes_iles();
	sort(plans.begin(), plans.end(), ComparePlanColonisation(maison[0]));

	return plans;
}

/*
 * Met a jour les plans de colonisation
 */
void maj_plans_colonisation(std::vector<struct PlanColonisation>& plans)
{
	for(auto plan = plans.begin() ; plan != plans.end() ; ) {
		// On verifie que les iles sont toujours vierges
		for(auto ile = plan->iles.begin() ; ile != plan->iles.end() ; ) {
			if(info_ile_joueur(*ile) != -1)
				ile = plan->iles.erase(ile);
			else
				++ile;
		}

		// On verifie que la caravelle existe toujours
		if(plan->idCaravelle != -1 && !bateau_existe(plan->idCaravelle))
			plan->idCaravelle = -1;

		// On supprime le plan s'il n'y a plus d'ile
		if(plan->iles.empty()) {
			if(plan->idCaravelle != -1)
				affecter_caravelle_volcans(plan->idCaravelle);
			plan = plans.erase(plan);
		}
		else {
			++plan;
		}
	}
}


/*
 * Indique a la caravelle quelle est la prochaine ile a coloniser
 */
position find_next_colonisation(struct PlanColonisation plan) {
	bateau car = info_bateau(plan.idCaravelle);
	int minDis = TAILLE_TERRAIN * 2 + 1;
	position bestIle;

	for(auto it = plan.iles.begin() ; it != plan.iles.end() ; ++it) {
		int dis = distance(car.pos, *it);
		if(dis < minDis) {
			minDis = dis;
			bestIle = *it;
		}
	}

	return bestIle;
}
