#include "volcans.hh"

#include "bateaux.hh"

#include <map>

std::vector<int> caravelles, caravelles_chargees;

void affecter_caravelle_volcans(int id)
{
	caravelles.push_back(id);
}

/*
 * Renvoie true s'il faut refaire des caravelles
 */
bool maj_caravelles_volcans() {
	for(auto it = caravelles.begin() ; it != caravelles.end() ; ) {
		if(!bateau_existe(*it))
			it = caravelles.erase(it);
		else
			++it;
	}
	for(auto it = caravelles_chargees.begin() ; it != caravelles_chargees.end() ; ) {
		if(!bateau_existe(*it))
			it = caravelles_chargees.erase(it);
		else
			++it;
	}

	if(caravelles.size() + caravelles_chargees.size() == 0)
		return true;

	int nbVolcans = 0;

	std::vector<position> iles = mes_iles();
	for(auto it = iles.begin() ; it != iles.end() ; ++it) {
		if(info_terrain(*it) == TERRAIN_VOLCAN && info_ile_joueur(*it) == MOI)
			nbVolcans++;
	}

	return (nbVolcans / 2 > caravelles.size() + caravelles_chargees.size());
}

void charger_caravelles();
void decharger_caravelles();

void deplacer_caravelles_volcans()
{
	charger_caravelles();
	decharger_caravelles();
}

void charger_caravelles() {
	std::multimap<int, position> volcans;

	std::vector<position> iles = mes_iles();
	for(auto it = iles.begin() ; it != iles.end() ; ++it) {
		if(info_terrain(*it) == TERRAIN_VOLCAN)
			volcans.insert(std::pair<int, position>(info_ile_or(*it), *it));
	}

	for(auto vol = volcans.rbegin() ; vol != volcans.rend() ; ++vol) {
		int bestDis = TAILLE_TERRAIN * 2 + 1;
		int bestCar;
		std::vector<int>::iterator bestIter;

		for(auto car = caravelles.begin() ; car != caravelles.end() ; ++car) {
			bateau bat = info_bateau(*car);
			int dis = distance(bat.pos, vol->second);
			if(bat.deplacable && dis < bestDis) {
				bestDis = dis;
				bestCar = *car;
				bestIter = car;
			}
		}

		if(bestDis < TAILLE_TERRAIN * 2 + 1) {
			position arriv;
			erreur err = deplacer_vers(bestCar, vol->second, &arriv);
			if(err == OK && arriv.x == vol->second.x && arriv.y == vol->second.y) {
				err = charger(bestCar, info_ile_or(vol->second));
				if(err == OK) {
					caravelles_chargees.push_back(bestCar);
					caravelles.erase(bestIter);
				}
			}
		}
	}
}

void decharger_caravelles()
{
	std::vector<position> iles = mes_iles();

	for(auto car = caravelles_chargees.begin() ; car != caravelles_chargees.end() ; ) {
		bateau bat = info_bateau(*car);

		int bestDis = TAILLE_TERRAIN * 2 + 1;
		position bestIle;

		for(auto it = iles.begin() ; it != iles.end() ; ++it) {
			if(info_terrain(*it) != TERRAIN_ILE)
				continue;

			int dis = distance(bat.pos, *it);
			if(dis < bestDis) {
				bestDis = dis;
				bestIle = *it;
			}
		}

		if(bestDis < TAILLE_TERRAIN * 2 + 1) {
			position arriv;
			erreur err = deplacer_vers(*car, bestIle, &arriv);
			if(err == OK && arriv.x == bestIle.x && arriv.y == bestIle.y) {
				err = decharger(*car, bat.nb_or);
				if(err == OK) {
					car = caravelles_chargees.erase(car);
					caravelles.push_back(*car);
					continue;
				}
			}
		}

		++car;
	}
}
