#include "influence.hh"

#include "prologin.hh"

#include <cmath>
#include <vector>

Influences::Influences()
	: moi(std::vector< std::vector<double> >(
			TAILLE_TERRAIN, std::vector<double>(TAILLE_TERRAIN, 0)
			))
	, adv(std::vector< std::vector<double> >(
			TAILLE_TERRAIN, std::vector<double>(TAILLE_TERRAIN, 0)
			))
{
}


void propage_influence(position pos, double val, std::vector< std::vector<double> >* inf)
{
	int minX = std::max(0, pos.x - 12),
		minY = std::max(0, pos.y - 12),
		maxX = std::min(TAILLE_TERRAIN-1, pos.x + 12),
		maxY = std::min(TAILLE_TERRAIN-1, pos.y + 12);

	position cur;
	for(cur.y=minY ; cur.y<=maxY ; cur.y++) {
		for(cur.x=minX ; cur.x<=maxX ; cur.x++) {
			int dis = distance(pos, cur);
			if(dis <= GALION_DEPLACEMENT)
				(*inf)[cur.y][cur.x] += val;
			else
				(*inf)[cur.y][cur.x] += val * 0.01;
		}
	}
}


Influences calcule_influences()
{
	Influences inf;

	position pos;
	for(pos.y=0 ; pos.y<TAILLE_TERRAIN ; pos.y++) {
		for(pos.x=0 ; pos.x<TAILLE_TERRAIN ; pos.x++) {
			double val = 0;
			int proprio;

			terrain terr = info_terrain(pos);
			if(terr == TERRAIN_ILE || terr == TERRAIN_VOLCAN) {
				val += 50;
				proprio = info_ile_joueur(pos);
			}

			std::vector<bateau> bats = liste_bateaux_position(pos);
			for(auto bat = bats.begin() ; bat != bats.end() ; ++bat) {
				if(bat->btype == BATEAU_GALION) {
					proprio = bat->joueur;
					val += 1;
				}
			}

			if(val > 0)
				propage_influence(pos, val, (proprio == MOI ? &inf.moi : &inf.adv));
		}
	}

	return inf;
}


Frontiere::Frontiere()
	: cumul(TAILLE_TERRAIN*TAILLE_TERRAIN)
	, total(0)
{ }

position Frontiere::idToPos(int index) const
{
	position pos;
	pos.y = index / TAILLE_TERRAIN;
	pos.x = index % TAILLE_TERRAIN;
	return pos;
}


/*
 * Determine la zone de conflit entre les deux capitaines.
 * Cette zone est celle ou devraient aller les unites pour participer a
 * l'effort de guerre.
 */
Frontiere find_frontiere(const Influences& inf) {
	Frontiere frontiere;

	frontiere.cumul[0] = pow(std::min(inf.moi[0][0], inf.adv[0][0]), 2);

	for(int i = 1 ; i < TAILLE_TERRAIN*TAILLE_TERRAIN ; i++) {
		position p = frontiere.idToPos(i);
		double val = pow(std::min(inf.moi[p.y][p.x], inf.adv[p.y][p.x]), 2);
		frontiere.cumul[i] = frontiere.cumul[i-1] + val;
		frontiere.total += val;
	}

	return frontiere;
}
