#include "iles.hh"

#include "prologin.hh"
#include "influence.hh"
#include "debug.hh"

#include <vector>
#include <algorithm>

position find_ile_construire_caravelle()
{
	std::vector<position> iles = mes_iles();
	for(auto it = iles.begin() ; it != iles.end() ; ++it) {
		if(info_ile_or(*it) >= CARAVELLE_COUT)
			return *it;
	}

	position bad;
	bad.x = -1;
	bad.y = -1;
	return bad;
}


bool construire_caravelle() {
	position ileCaravelle = find_ile_construire_caravelle();

	if(ileCaravelle.x != -1) {
		erreur err = debug_err(construire(BATEAU_CARAVELLE, ileCaravelle));
		return (err == OK);
	}
	else {
		return false;
	}
}


void construire_galions(const Influences& inf, bool saveMoney)
{
	struct IleInf {
		position pos;
		double val;
		IleInf(position p, double v) : pos(p), val(v) {}
		bool operator<(const struct IleInf& o) const {
			return val < o.val;
		}
	};

	std::vector<IleInf> iles;

	for(position pos : mes_iles()) {
		iles.push_back(IleInf(pos, inf.adv[pos.y][pos.x]));
	}

	if(iles.empty()) // On est foutus =(
		return;

	std::sort(iles.begin(), iles.end());

	auto end = iles.rend();
	if(saveMoney)
		end--;

	for(auto it = iles.rbegin() ; it != end ; ++it) {
		erreur res = OK;
		while(res == OK)
			res = construire(BATEAU_GALION, it->pos);
		if(res == LIMITE_ATTEINTE)
			break;
	}
}
