#include "debug.hh"

#include "prologin.hh"

#define DEBUG true

void debug_plans_colonisation(const std::vector<struct PlanColonisation>& plans)
{
#ifdef DEBUG
	for(auto it=plans.begin() ; it != plans.end() ; ++it) {
		printf("%d : === plan colonisation ===\n", MOI);
		for(auto it2 = it->iles.begin() ; it2 != it->iles.end() ; ++it2) {
			printf("%d : ile (%d, %d)\n", MOI, it2->x, it2->y);
		}
	}
#endif
}

erreur debug_err(erreur err)
{
#ifdef DEBUG
	switch(err) {
		case OK: break;
		case OR_INSUFFISANT: printf("%d : OR_INSUFFISANT\n", MOI); break;
		case ILE_INVALIDE: printf("%d : ILE_INVALIDE\n", MOI); break;
		case POSITION_INVALIDE: printf("%d : POSITION_INVALIDE\n", MOI); break;
		case TROP_LOIN: printf("%d : TROP_LOIN\n", MOI); break;
		case ILE_COLONISEE: printf("%d : ILE_COLONISEE\n", MOI); break;
		case ILE_ENNEMIE: printf("%d : ILE_ENNEMIE\n", MOI); break;
		case BATEAU_ENNEMI: printf("%d : BATEAU_ENNEMI\n", MOI); break;
		case ID_INVALIDE: printf("%d : ID_INVALIDE\n", MOI); break;
		case NON_DEPLACABLE: printf("%d : NON_DEPLACABLE\n", MOI); break;
		case AUCUNE_CARAVELLE: printf("%d : AUCUNE_CARAVELLE\n", MOI); break;
		case LIMITE_ATTEINTE: printf("%d : LIMITE_ATTEINTE\n", MOI); break;
	}
#endif
	return err;
}

void debug_matbool(const std::vector< std::vector<bool> >& mat) {
	for(auto y=mat.begin() ; y != mat.end() ; y++) {
		for(auto x=y->begin() ; x != y->end() ; x++) {
			if(*x)
				printf("#");
			else
				printf(".");
		}
		printf("\n");
	}
}
