///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb
//

#include "interface.hh"

// In case of errors...
template<typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
  return in.error_should_not_happens;
}

template<typename Cxx, typename Lang>
Lang cxx2lang(Cxx in)
{
  return in.error_should_not_happens;
}

template<typename Lang, typename Cxx>
std::vector<Cxx> lang2cxx_array(jobject in);

template<typename Cxx, typename Lang>
jarray cxx2lang_array(std::vector<Cxx> in);

// Basic type wrappers
template <>
jboolean cxx2lang<boolean, jboolean>(boolean in)
{
  return (jboolean)in;
}

template <>
boolean lang2cxx<jboolean, boolean>(jboolean in)
{
  return (boolean)in;
}

template <>
jarray cxx2lang_array<boolean, jboolean>(std::vector<boolean> in)
{
  jbooleanArray out = jrt.env->NewBooleanArray((jsize)in.size());
  jrt.env->SetBooleanArrayRegion(out, (jsize)0, (jsize)in.size(), (const jboolean*)in.data());
  return (jarray)out;
}

template <>
std::vector<boolean> lang2cxx_array<jboolean, boolean>(jobject in)
{
  jbooleanArray array = (jbooleanArray)in;
  jsize size = jrt.env->GetArrayLength(array);
  jboolean* datas = jrt.env->GetBooleanArrayElements(array, NULL);
  std::vector<boolean> out(datas, datas + size);
  jrt.env->ReleaseBooleanArrayElements(array, datas, JNI_ABORT);
  return out;
}

template <>
jbyte cxx2lang<byte, jbyte>(byte in)
{
  return (jbyte)in;
}

template <>
byte lang2cxx<jbyte, byte>(jbyte in)
{
  return (byte)in;
}

template <>
jarray cxx2lang_array<byte, jbyte>(std::vector<byte> in)
{
  jbyteArray out = jrt.env->NewByteArray((jsize)in.size());
  jrt.env->SetByteArrayRegion(out, (jsize)0, (jsize)in.size(), (const jbyte*)in.data());
  return (jarray)out;
}

template <>
std::vector<byte> lang2cxx_array<jbyte, byte>(jobject in)
{
  jbyteArray array = (jbyteArray)in;
  jsize size = jrt.env->GetArrayLength(array);
  jbyte* datas = jrt.env->GetByteArrayElements(array, NULL);
  std::vector<byte> out(datas, datas + size);
  jrt.env->ReleaseByteArrayElements(array, datas, JNI_ABORT);
  return out;
}

template <>
jchar cxx2lang<char, jchar>(char in)
{
  return (jchar)in;
}

template <>
char lang2cxx<jchar, char>(jchar in)
{
  return (char)in;
}

template <>
jarray cxx2lang_array<char, jchar>(std::vector<char> in)
{
  jcharArray out = jrt.env->NewCharArray((jsize)in.size());
  jrt.env->SetCharArrayRegion(out, (jsize)0, (jsize)in.size(), (const jchar*)in.data());
  return (jarray)out;
}

template <>
std::vector<char> lang2cxx_array<jchar, char>(jobject in)
{
  jcharArray array = (jcharArray)in;
  jsize size = jrt.env->GetArrayLength(array);
  jchar* datas = jrt.env->GetCharArrayElements(array, NULL);
  std::vector<char> out(datas, datas + size);
  jrt.env->ReleaseCharArrayElements(array, datas, JNI_ABORT);
  return out;
}

template <>
jshort cxx2lang<short, jshort>(short in)
{
  return (jshort)in;
}

template <>
short lang2cxx<jshort, short>(jshort in)
{
  return (short)in;
}

template <>
jarray cxx2lang_array<short, jshort>(std::vector<short> in)
{
  jshortArray out = jrt.env->NewShortArray((jsize)in.size());
  jrt.env->SetShortArrayRegion(out, (jsize)0, (jsize)in.size(), (const jshort*)in.data());
  return (jarray)out;
}

template <>
std::vector<short> lang2cxx_array<jshort, short>(jobject in)
{
  jshortArray array = (jshortArray)in;
  jsize size = jrt.env->GetArrayLength(array);
  jshort* datas = jrt.env->GetShortArrayElements(array, NULL);
  std::vector<short> out(datas, datas + size);
  jrt.env->ReleaseShortArrayElements(array, datas, JNI_ABORT);
  return out;
}

template <>
jint cxx2lang<int, jint>(int in)
{
  return (jint)in;
}

template <>
int lang2cxx<jint, int>(jint in)
{
  return (int)in;
}

template <>
jarray cxx2lang_array<int, jint>(std::vector<int> in)
{
  jintArray out = jrt.env->NewIntArray((jsize)in.size());
  jrt.env->SetIntArrayRegion(out, (jsize)0, (jsize)in.size(), (const jint*)in.data());
  return (jarray)out;
}

template <>
std::vector<int> lang2cxx_array<jint, int>(jobject in)
{
  jintArray array = (jintArray)in;
  jsize size = jrt.env->GetArrayLength(array);
  jint* datas = jrt.env->GetIntArrayElements(array, NULL);
  std::vector<int> out(datas, datas + size);
  jrt.env->ReleaseIntArrayElements(array, datas, JNI_ABORT);
  return out;
}

template <>
jlong cxx2lang<long, jlong>(long in)
{
  return (jlong)in;
}

template <>
long lang2cxx<jlong, long>(jlong in)
{
  return (long)in;
}

template <>
jarray cxx2lang_array<long, jlong>(std::vector<long> in)
{
  jlongArray out = jrt.env->NewLongArray((jsize)in.size());
  jrt.env->SetLongArrayRegion(out, (jsize)0, (jsize)in.size(), (const jlong*)in.data());
  return (jarray)out;
}

template <>
std::vector<long> lang2cxx_array<jlong, long>(jobject in)
{
  jlongArray array = (jlongArray)in;
  jsize size = jrt.env->GetArrayLength(array);
  jlong* datas = jrt.env->GetLongArrayElements(array, NULL);
  std::vector<long> out(datas, datas + size);
  jrt.env->ReleaseLongArrayElements(array, datas, JNI_ABORT);
  return out;
}

template <>
jfloat cxx2lang<float, jfloat>(float in)
{
  return (jfloat)in;
}

template <>
float lang2cxx<jfloat, float>(jfloat in)
{
  return (float)in;
}

template <>
jarray cxx2lang_array<float, jfloat>(std::vector<float> in)
{
  jfloatArray out = jrt.env->NewFloatArray((jsize)in.size());
  jrt.env->SetFloatArrayRegion(out, (jsize)0, (jsize)in.size(), (const jfloat*)in.data());
  return (jarray)out;
}

template <>
std::vector<float> lang2cxx_array<jfloat, float>(jobject in)
{
  jfloatArray array = (jfloatArray)in;
  jsize size = jrt.env->GetArrayLength(array);
  jfloat* datas = jrt.env->GetFloatArrayElements(array, NULL);
  std::vector<float> out(datas, datas + size);
  jrt.env->ReleaseFloatArrayElements(array, datas, JNI_ABORT);
  return out;
}

template <>
jdouble cxx2lang<double, jdouble>(double in)
{
  return (jdouble)in;
}

template <>
double lang2cxx<jdouble, double>(jdouble in)
{
  return (double)in;
}

template <>
jarray cxx2lang_array<double, jdouble>(std::vector<double> in)
{
  jdoubleArray out = jrt.env->NewDoubleArray((jsize)in.size());
  jrt.env->SetDoubleArrayRegion(out, (jsize)0, (jsize)in.size(), (const jdouble*)in.data());
  return (jarray)out;
}

template <>
std::vector<double> lang2cxx_array<jdouble, double>(jobject in)
{
  jdoubleArray array = (jdoubleArray)in;
  jsize size = jrt.env->GetArrayLength(array);
  jdouble* datas = jrt.env->GetDoubleArrayElements(array, NULL);
  std::vector<double> out(datas, datas + size);
  jrt.env->ReleaseDoubleArrayElements(array, datas, JNI_ABORT);
  return out;
}

// String wrappers
template <>
jstring cxx2lang<std::string, jstring>(std::string in)
{
  return jrt.env->NewStringUTF(in.data());
}

template <>
std::string lang2cxx<jstring, std::string>(jstring in)
{
  jboolean is_copy;
  const jchar* datas = jrt.env->GetStringChars(in, &is_copy);
  jsize size = jrt.env->GetStringLength(in);
  std::string out((const char*)datas, (size_t)size);
  if (is_copy)
    jrt.env->ReleaseStringChars(in, datas);
  return out;
}

// Object array wrappers (assume Lang::class exists)
template <typename Cxx, typename Lang>
jarray cxx2lang_array(std::vector<Cxx> in)
{
  jobjectArray out = jrt.env->NewObjectArray((jsize)in.size(), Lang::Class(), NULL);
  for (size_t i = 0; i < in.size(); i++)
    jrt.env->SetObjectArrayElement(out, (jsize)i, cxx2lang<Cxx, jobject>(in[i]));
  return out;
}

template <typename Lang, typename Cxx>
std::vector<Cxx> lang2cxx_array(jobject in)
{
  jobjectArray array = (jobjectArray)in;
  size_t size = (size_t)jrt.env->GetArrayLength(array);
  std::vector<Cxx> out;
  for (size_t i = 0; i < size; i++)
    out.push_back(lang2cxx<jobject, Cxx>(jrt.env->GetObjectArrayElement(array, (jsize)i)));
  return out;
}

///
// Type de bateau
//
template<>
bateau_type lang2cxx<jobject, bateau_type>(jobject in)
{
  jmethodID ordinal = jrt.env->GetMethodID(BateauType::Class(), "ordinal", "()I");
  return bateau_type(lang2cxx<jint, int>(jrt.env->CallIntMethod(in, ordinal)));
}

template<>
jobject cxx2lang<bateau_type, jobject>(bateau_type in)
{
  jmethodID method = jrt.env->GetStaticMethodID(BateauType::Class(), "values", "()[LBateauType;");
  jobjectArray values = (jobjectArray)jrt.env->CallStaticObjectMethod(BateauType::Class(), method);
  return jrt.env->GetObjectArrayElement(values, (jsize)in);
}


///
// Type de terrain
//
template<>
terrain lang2cxx<jobject, terrain>(jobject in)
{
  jmethodID ordinal = jrt.env->GetMethodID(Terrain::Class(), "ordinal", "()I");
  return terrain(lang2cxx<jint, int>(jrt.env->CallIntMethod(in, ordinal)));
}

template<>
jobject cxx2lang<terrain, jobject>(terrain in)
{
  jmethodID method = jrt.env->GetStaticMethodID(Terrain::Class(), "values", "()[LTerrain;");
  jobjectArray values = (jobjectArray)jrt.env->CallStaticObjectMethod(Terrain::Class(), method);
  return jrt.env->GetObjectArrayElement(values, (jsize)in);
}


///
// Erreurs possibles
//
template<>
erreur lang2cxx<jobject, erreur>(jobject in)
{
  jmethodID ordinal = jrt.env->GetMethodID(Erreur::Class(), "ordinal", "()I");
  return erreur(lang2cxx<jint, int>(jrt.env->CallIntMethod(in, ordinal)));
}

template<>
jobject cxx2lang<erreur, jobject>(erreur in)
{
  jmethodID method = jrt.env->GetStaticMethodID(Erreur::Class(), "values", "()[LErreur;");
  jobjectArray values = (jobjectArray)jrt.env->CallStaticObjectMethod(Erreur::Class(), method);
  return jrt.env->GetObjectArrayElement(values, (jsize)in);
}


///
// Représente la position sur la carte
//
template <>
position lang2cxx<jobject, position>(jobject in)
{
  position out;
  out.x = lang2cxx<jint, int>(jrt.env->GetIntField(in, jrt.env->GetFieldID(Position::Class(), "x", "I")));
  out.y = lang2cxx<jint, int>(jrt.env->GetIntField(in, jrt.env->GetFieldID(Position::Class(), "y", "I")));
  return out;
}

template <>
jobject cxx2lang<position, jobject>(position in)
{
  jobject out = jrt.env->NewObject(Position::Class(), jrt.env->GetMethodID(Position::Class(), "<init>", "()V"));
  jrt.env->SetIntField(out, jrt.env->GetFieldID(Position::Class(), "x", "I"), cxx2lang<int, jint>(in.x));
  jrt.env->SetIntField(out, jrt.env->GetFieldID(Position::Class(), "y", "I"), cxx2lang<int, jint>(in.y));
  return out;
}


///
// Représente un bateau
//
template <>
bateau lang2cxx<jobject, bateau>(jobject in)
{
  bateau out;
  out.id = lang2cxx<jint, int>(jrt.env->GetIntField(in, jrt.env->GetFieldID(Bateau::Class(), "id", "I")));
  out.pos = lang2cxx<jobject, position>(jrt.env->GetObjectField(in, jrt.env->GetFieldID(Bateau::Class(), "pos", "LPosition;")));
  out.joueur = lang2cxx<jint, int>(jrt.env->GetIntField(in, jrt.env->GetFieldID(Bateau::Class(), "joueur", "I")));
  out.btype = lang2cxx<jobject, bateau_type>(jrt.env->GetObjectField(in, jrt.env->GetFieldID(Bateau::Class(), "btype", "LBateauType;")));
  out.nb_or = lang2cxx<jint, int>(jrt.env->GetIntField(in, jrt.env->GetFieldID(Bateau::Class(), "nb_or", "I")));
  out.deplacable = lang2cxx<jboolean, boolean>(jrt.env->GetBooleanField(in, jrt.env->GetFieldID(Bateau::Class(), "deplacable", "Z")));
  return out;
}

template <>
jobject cxx2lang<bateau, jobject>(bateau in)
{
  jobject out = jrt.env->NewObject(Bateau::Class(), jrt.env->GetMethodID(Bateau::Class(), "<init>", "()V"));
  jrt.env->SetIntField(out, jrt.env->GetFieldID(Bateau::Class(), "id", "I"), cxx2lang<int, jint>(in.id));
  jrt.env->SetObjectField(out, jrt.env->GetFieldID(Bateau::Class(), "pos", "LPosition;"), cxx2lang<position, jobject>(in.pos));
  jrt.env->SetIntField(out, jrt.env->GetFieldID(Bateau::Class(), "joueur", "I"), cxx2lang<int, jint>(in.joueur));
  jrt.env->SetObjectField(out, jrt.env->GetFieldID(Bateau::Class(), "btype", "LBateauType;"), cxx2lang<bateau_type, jobject>(in.btype));
  jrt.env->SetIntField(out, jrt.env->GetFieldID(Bateau::Class(), "nb_or", "I"), cxx2lang<int, jint>(in.nb_or));
  jrt.env->SetBooleanField(out, jrt.env->GetFieldID(Bateau::Class(), "deplacable", "Z"), cxx2lang<boolean, jboolean>(in.deplacable));
  return out;
}


///
// Retourne la nature du terrain désigné par ``pos``.
//
jobject info_terrain(JNIEnv* _env, jobject _obj, jobject pos)
{
  return cxx2lang<terrain, jobject>(api_info_terrain(lang2cxx<jobject, position>(pos)));
}


///
// Retourne le joueur qui possède l'île à l'emplacement ``pos``. Retourne -1 si l'île est libre ou si la position indiquée n'est pas une île
//
jint info_ile_joueur(JNIEnv* _env, jobject _obj, jobject pos)
{
  return cxx2lang<int, jint>(api_info_ile_joueur(lang2cxx<jobject, position>(pos)));
}


///
// Retourne l'or contenu sur l'île à l'emplacement ``pos``. Retourne -1 si la case spécifiée n'est pas une île.
//
jint info_ile_or(JNIEnv* _env, jobject _obj, jobject pos)
{
  return cxx2lang<int, jint>(api_info_ile_or(lang2cxx<jobject, position>(pos)));
}


///
// Retourne le bateau ayant pour identifiant ``id``
//
jobject info_bateau(JNIEnv* _env, jobject _obj, jint id)
{
  return cxx2lang<bateau, jobject>(api_info_bateau(lang2cxx<jint, int>(id)));
}


///
// Retourne vrai si le bateau ayant pour identifiant ``id`` existe et est encore à flots
//
jboolean bateau_existe(JNIEnv* _env, jobject _obj, jint id)
{
  return cxx2lang<boolean, jboolean>(api_bateau_existe(lang2cxx<jint, int>(id)));
}


///
// Retourne la liste de bateaux à la position ``pos``
//
jarray liste_bateaux_position(JNIEnv* _env, jobject _obj, jobject pos)
{
  return cxx2lang_array<bateau, Bateau>(api_liste_bateaux_position(lang2cxx<jobject, position>(pos)));
}


///
// Retourne la liste des ID des bateaux à la position ``pos``
//
jarray liste_id_bateaux_position(JNIEnv* _env, jobject _obj, jobject pos)
{
  return cxx2lang_array<int, jint>(api_liste_id_bateaux_position(lang2cxx<jobject, position>(pos)));
}


///
// Retourne la liste des positions des îles de la carte
//
jarray liste_iles(JNIEnv* _env, jobject _obj)
{
  return cxx2lang_array<position, Position>(api_liste_iles());
}


///
// Retourne la liste des positions des îles qui vous appartiennent
//
jarray mes_iles(JNIEnv* _env, jobject _obj)
{
  return cxx2lang_array<position, Position>(api_mes_iles());
}


///
// Retourne l'ID du dernier bateau construit. Son comportement n'est pas défini si vous n'avez pas encore créé de bateau à ce tour-ci.
//
jint id_dernier_bateau_construit(JNIEnv* _env, jobject _obj)
{
  return cxx2lang<int, jint>(api_id_dernier_bateau_construit());
}


///
// Retourne la distance entre deux positions
//
jint distance(JNIEnv* _env, jobject _obj, jobject depart, jobject arrivee)
{
  return cxx2lang<int, jint>(api_distance(lang2cxx<jobject, position>(depart), lang2cxx<jobject, position>(arrivee)));
}


///
// Construire un bateau de type ``btype`` sur l'île à la position ``pos``
//
jobject construire(JNIEnv* _env, jobject _obj, jobject btype, jobject pos)
{
  return cxx2lang<erreur, jobject>(api_construire(lang2cxx<jobject, bateau_type>(btype), lang2cxx<jobject, position>(pos)));
}


///
// Déplace le bateau représenté par l'identifiant ``id`` jusqu'à la position `pos`` (si elle est dans la portée du bateau)
//
jobject deplacer(JNIEnv* _env, jobject _obj, jint id, jobject pos)
{
  return cxx2lang<erreur, jobject>(api_deplacer(lang2cxx<jint, int>(id), lang2cxx<jobject, position>(pos)));
}


///
// Colonise l'île à la position ``pos``
//
jobject coloniser(JNIEnv* _env, jobject _obj, jobject pos)
{
  return cxx2lang<erreur, jobject>(api_coloniser(lang2cxx<jobject, position>(pos)));
}


///
// Charge la caravelle identifiée par ``id`` de ``nb_or`` d'or.
//
jobject charger(JNIEnv* _env, jobject _obj, jint id, jint nb_or)
{
  return cxx2lang<erreur, jobject>(api_charger(lang2cxx<jint, int>(id), lang2cxx<jint, int>(nb_or)));
}


///
// Décharge la caravelle identifiée par ``id`` de ``nb_or`` d'or.
//
jobject decharger(JNIEnv* _env, jobject _obj, jint id, jint nb_or)
{
  return cxx2lang<erreur, jobject>(api_decharger(lang2cxx<jint, int>(id), lang2cxx<jint, int>(nb_or)));
}


///
// Transfère ``montant`` or de la caravelle ``id_source`` à la caravelle ``id_dest``
//
jobject transferer(JNIEnv* _env, jobject _obj, jint montant, jint id_source, jint id_dest)
{
  return cxx2lang<erreur, jobject>(api_transferer(lang2cxx<jint, int>(montant), lang2cxx<jint, int>(id_source), lang2cxx<jint, int>(id_dest)));
}


///
// Retourne le numéro de votre joueur
//
jint mon_joueur(JNIEnv* _env, jobject _obj)
{
  return cxx2lang<int, jint>(api_mon_joueur());
}


///
// Retourne le numéro de votre adversaire
//
jint adversaire(JNIEnv* _env, jobject _obj)
{
  return cxx2lang<int, jint>(api_adversaire());
}


///
// Retourne les scores du joueur désigné par l'identifiant ``id``
//
jint score(JNIEnv* _env, jobject _obj, jint id_joueur)
{
  return cxx2lang<int, jint>(api_score(lang2cxx<jint, int>(id_joueur)));
}


///
// Retourne le numéro du tour actuel
//
jint tour_actuel(JNIEnv* _env, jobject _obj)
{
  return cxx2lang<int, jint>(api_tour_actuel());
}


///
// Retourne le nombre de bateaux que possède le joueur désigné par l'identifiant ``id``
//
jint nombre_bateaux(JNIEnv* _env, jobject _obj, jint id_joueur)
{
  return cxx2lang<int, jint>(api_nombre_bateaux(lang2cxx<jint, int>(id_joueur)));
}


///
// Affiche le contenu d'une valeur de type bateau_type
//
void afficher_bateau_type(JNIEnv* _env, jobject _obj, jobject v)
{
  api_afficher_bateau_type(lang2cxx<jobject, bateau_type>(v));
}


///
// Affiche le contenu d'une valeur de type terrain
//
void afficher_terrain(JNIEnv* _env, jobject _obj, jobject v)
{
  api_afficher_terrain(lang2cxx<jobject, terrain>(v));
}


///
// Affiche le contenu d'une valeur de type erreur
//
void afficher_erreur(JNIEnv* _env, jobject _obj, jobject v)
{
  api_afficher_erreur(lang2cxx<jobject, erreur>(v));
}


///
// Affiche le contenu d'une valeur de type position
//
void afficher_position(JNIEnv* _env, jobject _obj, jobject v)
{
  api_afficher_position(lang2cxx<jobject, position>(v));
}


///
// Affiche le contenu d'une valeur de type bateau
//
void afficher_bateau(JNIEnv* _env, jobject _obj, jobject v)
{
  api_afficher_bateau(lang2cxx<jobject, bateau>(v));
}


///
// Fonction appelée au début de la partie
//
extern "C" void partie_init()
{
  bool attached = jrt.function_enter();
  jmethodID method = jrt.env->GetMethodID(Prologin::Class(), "partie_init", "()V");
  jrt.env->CallVoidMethod(jrt.prologin, method);
  if (jrt.env->ExceptionOccurred())
  {
    jrt.env->ExceptionDescribe();
    exit(1);
  }
  jrt.function_exit(attached);
}


///
// Fonction appelée à chaque tour
//
extern "C" void jouer_tour()
{
  bool attached = jrt.function_enter();
  jmethodID method = jrt.env->GetMethodID(Prologin::Class(), "jouer_tour", "()V");
  jrt.env->CallVoidMethod(jrt.prologin, method);
  if (jrt.env->ExceptionOccurred())
  {
    jrt.env->ExceptionDescribe();
    exit(1);
  }
  jrt.function_exit(attached);
}


///
// Fonction appelée à la fin de la partie
//
extern "C" void partie_fin()
{
  bool attached = jrt.function_enter();
  jmethodID method = jrt.env->GetMethodID(Prologin::Class(), "partie_fin", "()V");
  jrt.env->CallVoidMethod(jrt.prologin, method);
  if (jrt.env->ExceptionOccurred())
  {
    jrt.env->ExceptionDescribe();
    exit(1);
  }
  jrt.function_exit(attached);
}


jclass Prologin::Class()
{
  return jrt.env->FindClass("Prologin");
}

jclass BateauType::Class()
{
  return jrt.env->FindClass("BateauType");
}

jclass Terrain::Class()
{
  return jrt.env->FindClass("Terrain");
}

jclass Erreur::Class()
{
  return jrt.env->FindClass("Erreur");
}

jclass Position::Class()
{
  return jrt.env->FindClass("Position");
}

jclass Bateau::Class()
{
  return jrt.env->FindClass("Bateau");
}

static void _register_native_methods(JNIEnv* env)
{
  JNINativeMethod methods[] = {
    {(char*)"info_terrain", (char*)"(LPosition;)LTerrain;", (void*)&info_terrain},
    {(char*)"info_ile_joueur", (char*)"(LPosition;)I", (void*)&info_ile_joueur},
    {(char*)"info_ile_or", (char*)"(LPosition;)I", (void*)&info_ile_or},
    {(char*)"info_bateau", (char*)"(I)LBateau;", (void*)&info_bateau},
    {(char*)"bateau_existe", (char*)"(I)Z", (void*)&bateau_existe},
    {(char*)"liste_bateaux_position", (char*)"(LPosition;)[LBateau;", (void*)&liste_bateaux_position},
    {(char*)"liste_id_bateaux_position", (char*)"(LPosition;)[I", (void*)&liste_id_bateaux_position},
    {(char*)"liste_iles", (char*)"()[LPosition;", (void*)&liste_iles},
    {(char*)"mes_iles", (char*)"()[LPosition;", (void*)&mes_iles},
    {(char*)"id_dernier_bateau_construit", (char*)"()I", (void*)&id_dernier_bateau_construit},
    {(char*)"distance", (char*)"(LPosition;LPosition;)I", (void*)&distance},
    {(char*)"construire", (char*)"(LBateauType;LPosition;)LErreur;", (void*)&construire},
    {(char*)"deplacer", (char*)"(ILPosition;)LErreur;", (void*)&deplacer},
    {(char*)"coloniser", (char*)"(LPosition;)LErreur;", (void*)&coloniser},
    {(char*)"charger", (char*)"(II)LErreur;", (void*)&charger},
    {(char*)"decharger", (char*)"(II)LErreur;", (void*)&decharger},
    {(char*)"transferer", (char*)"(III)LErreur;", (void*)&transferer},
    {(char*)"mon_joueur", (char*)"()I", (void*)&mon_joueur},
    {(char*)"adversaire", (char*)"()I", (void*)&adversaire},
    {(char*)"score", (char*)"(I)I", (void*)&score},
    {(char*)"tour_actuel", (char*)"()I", (void*)&tour_actuel},
    {(char*)"nombre_bateaux", (char*)"(I)I", (void*)&nombre_bateaux},
    {(char*)"afficher_bateau_type", (char*)"(LBateauType;)V", (void*)&afficher_bateau_type},
    {(char*)"afficher_terrain", (char*)"(LTerrain;)V", (void*)&afficher_terrain},
    {(char*)"afficher_erreur", (char*)"(LErreur;)V", (void*)&afficher_erreur},
    {(char*)"afficher_position", (char*)"(LPosition;)V", (void*)&afficher_position},
    {(char*)"afficher_bateau", (char*)"(LBateau;)V", (void*)&afficher_bateau}
  };
  env->RegisterNatives(Prologin::Class(), methods, sizeof(methods)/sizeof(methods[0]));
}

ProloginJavaRunTime jrt;

ProloginJavaRunTime::ProloginJavaRunTime()
{
 std::string classpath = "-Djava.class.path=";
  char* champion_path = getenv("CHAMPION_PATH");
  if (champion_path == NULL)
    champion_path = (char*)"./";
  classpath.append(champion_path);

  JavaVMInitArgs vm_args; /* JDK/JRE 6 VM initialization arguments */
  JavaVMOption options[2];
  options[0].optionString = (char*)classpath.c_str();
  options[1].optionString = (char*)"-ea";
  vm_args.version = JNI_VERSION_1_6;
  vm_args.nOptions = 2;
  vm_args.options = options;
  vm_args.ignoreUnrecognized = false;
  JNI_CreateJavaVM(&jvm, (void**)&env, &vm_args);
  prologin = env->NewObject(Prologin::Class(), env->GetMethodID(Prologin::Class(), "<init>", "()V"));
  _register_native_methods(env);
}

ProloginJavaRunTime::~ProloginJavaRunTime()
{
  jvm->DestroyJavaVM();
}

bool ProloginJavaRunTime::function_enter()
{
  if (jvm->GetEnv((void**)&env, JNI_VERSION_1_6) == JNI_OK)
    return false;
  jvm->AttachCurrentThread((void**)&env, NULL);
  return true;
}

void ProloginJavaRunTime::function_exit(bool attached)
{
  if (attached)
    jvm->DetachCurrentThread();
}

