#include "bateaux.hh"

#include "prologin.hh"

#include <cmath>
#include <map>

erreur deplacer_vers(int id, position dest, position *effect)
{
	bateau bat = info_bateau(id);
	int dis = distance(bat.pos, dest);

	// Terre !
	if(bat.btype == BATEAU_CARAVELLE && dis <= CARAVELLE_DEPLACEMENT
			|| bat.btype == BATEAU_GALION && dis <= GALION_DEPLACEMENT) {
		if(effect != NULL) {
			effect->x = dest.x;
			effect->y = dest.y;
		}
		return deplacer(id, dest);
	}

	int depl = (bat.btype == BATEAU_CARAVELLE ? CARAVELLE_DEPLACEMENT : GALION_DEPLACEMENT);

	position *nextPos;
	if(effect == NULL)
		nextPos = new position;
	else
		nextPos = effect;
	nextPos->x = bat.pos.x;
	nextPos->y = bat.pos.y;

	int deltaX = dest.x - bat.pos.x;
	if(abs(deltaX) >= depl) {
		int mulX = (deltaX < 0 ? -1 : 1);
		nextPos->x = bat.pos.x + mulX*depl;
	}
	else {
		nextPos->x = bat.pos.x + deltaX;
		depl -= abs(deltaX);
		int deltaY = dest.y - bat.pos.y;
		int mulY = (deltaY < 0 ? -1 : 1);
		nextPos->y = bat.pos.y + mulY*depl;
	}

	return deplacer(id, *nextPos);
}


position generer_pos_frontiere(const Frontiere& front)
{
	double n = (double)rand() * front.total / (double)RAND_MAX;
	int inf = 0, sup = TAILLE_TERRAIN * TAILLE_TERRAIN - 1;
	int pivot;
	while(inf < sup) {
		pivot = (inf + sup) / 2;
		if(n > front.cumul[pivot])
			inf = pivot + 1;
		else
			sup = pivot;
	}

	return front.idToPos(sup);
}


std::map<int, position> dests;
void patrouiller_galions(const Frontiere& front)
{
	position pos;
	for(pos.y=0 ; pos.y<TAILLE_TERRAIN ; pos.y++) {
		for(pos.x=0 ; pos.x<TAILLE_TERRAIN ; pos.x++) {
			std::vector<bateau> bateaux = liste_bateaux_position(pos);
			for(auto it = bateaux.begin() ; it != bateaux.end() ; ++it) {
				if(it->joueur != MOI)
					continue;

				auto pair = dests.find(it->id);
				if(pair != dests.end()) {
					position dest = pair->second;
					if(pos.x != dest.x || pos.y != dest.y)
						deplacer_vers(it->id, dest);
					else if(tour_actuel() % 5 == 0)
						dests.erase(pair);

					continue;
				}

				position pos = generer_pos_frontiere(front);
				dests.insert(std::pair<int, position>(it->id, pos));
				deplacer_vers(it->id, pos);
			}
		}
	}
}
