unit prolo_interface;
interface
uses CTypes;

(*
  This file has been generated, if you wish to
  modify it in a permanent way, please refer
  to the script file : gen/generator_pascal.rb
*)


type array_of_cint = array of cint;
type array_of_boolean = array of boolean;
const
(*
  Taille du terrain
*)
	TAILLE_TERRAIN            =  30;
(*
  Nombre de tours par partie
*)
	FIN_PARTIE                =  150;
(*
  Nombre de points d'action par tour
*)
	MAX_PA                    =  3;
(*
  Taille des traînées de moto
*)
	INTENSITE_TRAINEE         =  120;
(*
  Longueur maximale de l'allongement
*)
	MAX_ALLONGEMENT           =  5;
(*
  Nombre de points d'action à rajouter avec bonus
*)
	AJOUT_PA                  =  5;
(*
  Énumération représentant une erreur renvoyée par une des fonctions d'action
*)
type erreur =
  (
    ok { <- aucune erreur n'est survenue },
    id_invalide { <- identifiant invalide },
    position_invalide { <- la position spécifiée est invalide },
    plus_de_pa { <- vous n'avez pas assez de points d'action },
    bonus_invalide { <- vous n'avez pas ce bonus },
    pas_a_toi { <- l'unité n'est pas a vous },
    intensite_invalide { <- cette intensité est invalide }
  );

type array_of_erreur = array of erreur;


(*
  Énumération représentant les différents types de case
*)
type type_case =
  (
    vide { <- rien n'est présent sur la case },
    obstacle { <- cette case est inaccessible },
    point_croisement { <- point de croisement de traînées },
    unite { <- unité d'énergie }
  );

type array_of_type_case = array of type_case;


(*
  Énumération représentant les différents types de bonii
*)
type type_bonus =
  (
    pas_bonus { <- ceci n'est pas un bonus :-) },
    bonus_croisement { <- bonus permettant de croiser deux traînées de moto sur une case },
    plus_long { <- bonus permettant d'agrandir une traînée de moto },
    plus_pa { <- bonus permettant d'avoir plus de points d'action },
    bonus_regeneration { <- bonus permettant de regenerer une unité d'énergie }
  );

type array_of_type_bonus = array of type_bonus;


(*
  Représente une position sur le terrain du jeu
*)
type position =
  record
    x : cint; (*  <- coordonnée en X *)
    y : cint; (*  <- coordonnée en Y *)
  end;

type array_of_position = array of position;


(*
  Caracteristiques d'une unité d'énergie
*)
type unite_energie =
  record
    id : cint; (*  <- identifiant de l'unité d'énergie *)
    pos : position; (*  <- position de l'unité d'énergie *)
    valeur : cint; (*  <- coefficient représentant les points d'énergie que l'unité va vous apporter *)
    valeur_max : cint; (*  <- coefficient représentant la capacité de l'unité lorsqu'elle est chargée au maximum *)
  end;

type array_of_unite_energie = array of unite_energie;


(*
  Représente une traînée de moto sur le terrain
*)
type trainee_moto =
  record
    id : cint; (*  <- identifiant de la traînee *)
    emplacement : array of position; (*  <- position de chaque composant de la traînée de moto *)
    team : cint; (*  <- identifiant de l'équipe qui possède cette traînée de moto *)
    intensite : cint; (*  <- taille maximale de la traînée *)
  end;

type array_of_trainee_moto = array of trainee_moto;


(*
  Retourne le numéro de votre équipe
*)
function mon_equipe() : cint; cdecl; external;

(*
  Retourne les scores de chaque équipe
*)
function scores() : array_of_cint; cdecl; external;

(*
  Retourne le nombre d'équipes sur le terrain
*)
function nombre_equipes() : cint; cdecl; external;

(*
  Retourne le numéro du tour actuel
*)
function tour_actuel() : cint; cdecl; external;

(*
  Retourne la liste des unités d'énergie
*)
function unites_energie() : array_of_unite_energie; cdecl; external;

(*
  Retourne la liste des traînées de moto
*)
function trainees_moto() : array_of_trainee_moto; cdecl; external;

(*
  Retourne le type d'une case
*)
function regarder_type_case(pos : position) : type_case; cdecl; external;

(*
  Retourne le type de bonus d'une case
*)
function regarder_type_bonus(pos : position) : type_bonus; cdecl; external;

(*
  Retourne la liste des bonus d'une équipe
*)
function regarder_bonus(equipe : cint) : array_of_type_bonus; cdecl; external;

(*
  Retourne la liste des id des traînées présentes sur une case
*)
function regarder_trainee_case(pos : position) : array_of_cint; cdecl; external;

(*
  Retourne si une case peut être traversée par une traînée de plus
*)
function case_traversable(pos : position) : boolean; cdecl; external;

(*
  Renvoie les points que vous allez gagner a la fin du tour
*)
function gain_tour_suivant() : cint; cdecl; external;

(*
  Renvoie le chemin le plus court entre deux points (fonction lente)
*)
function chemin(p1 : position; p2 : position) : array_of_position; cdecl; external;

(*
  Déplace une moto
*)
function deplacer(id : cint; de : position; vers : position) : erreur; cdecl; external;

(*
  Coupe une traînée de moto en deux nouvelles traînées. « p1 » et « p2 » doivent être deux positions adjacentes occupées par une même traînée de moto.
*)
function couper_trainee_moto(id : cint; p1 : position; p2 : position; intensite_p1 : cint) : erreur; cdecl; external;

(*
  Annule l'action précédente. Renvoie true si une action a été annulée, false sinon.
*)
function annuler() : boolean; cdecl; external;

(*
  Enroule la traînée de moto en un point
*)
function enrouler(id : cint; p : position) : erreur; cdecl; external;

(*
  Régénère une unité d'énergie à son maximal
*)
function regenerer_unite_energie(id : cint) : erreur; cdecl; external;

(*
  Allonge le tour en rajoutant des points d'action
*)
function allonger_pa() : erreur; cdecl; external;

(*
  Allonge une traînée de moto. L'allongement se fera aux prochains déplacements. La longueur du prolongement doit être comprise entre 0 et MAX_ALLONGEMENT (inclus).
*)
function etendre_trainee_moto(id : cint; longueur : cint) : erreur; cdecl; external;

(*
  Pose un point de croisement sur une case du terrain. La case doit ne pas déjà être un point de croisement.
*)
function poser_point_croisement(point : position) : erreur; cdecl; external;

(*
  Fusionne deux traînées de moto. Les deux doivent appartenir à la même équipe, mais doivent être deux traînées distinctes. « pos1 » et « pos2 » doivent être adjacentes et occupées respectivement par « id1 » et « id2 ».
*)
function fusionner(id1 : cint; pos1 : position; id2 : cint; pos2 : position) : erreur; cdecl; external;

(*
  Affiche le contenu d'une valeur de type erreur
*)
procedure afficher_erreur(v : erreur); cdecl; external;

(*
  Affiche le contenu d'une valeur de type type_case
*)
procedure afficher_type_case(v : type_case); cdecl; external;

(*
  Affiche le contenu d'une valeur de type type_bonus
*)
procedure afficher_type_bonus(v : type_bonus); cdecl; external;

(*
  Affiche le contenu d'une valeur de type position
*)
procedure afficher_position(v : position); cdecl; external;

(*
  Affiche le contenu d'une valeur de type unite_energie
*)
procedure afficher_unite_energie(v : unite_energie); cdecl; external;

(*
  Affiche le contenu d'une valeur de type trainee_moto
*)
procedure afficher_trainee_moto(v : trainee_moto); cdecl; external;

implementation

begin
end.
