///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb
//

// we want to use the CNI
#include <gcj/cni.h>
#include <gcj/array.h>
#include <java/lang/Throwable.h>
#include <java/lang/System.h>
#include <java/io/PrintStream.h>
#include <stdio.h>

#include "interface.hh"


template<typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
  return in.error;
}

template<>
int lang2cxx<jint, int>(jint in)
{
  return in;
}

template<>
std::string lang2cxx<java::lang::String*, std::string>(java::lang::String *in)
{
  size_t len = in->length();
  jchar *c = _Jv_GetStringChars(in);
  std::string s((char *)c, len);
  for (int i = 0; i < len; i++){
    s[i] = c[i];
  }
  return s;
}
template<>
bool lang2cxx<jboolean, bool>(jboolean in)
{
  return in;
}

template<typename Lang, typename Cxx>
Lang cxx2lang(Cxx in)
{
  return in.err;
}

template<>
jint cxx2lang<jint, int>(int in)
{
  return in;
}
template<>
jboolean cxx2lang<jboolean, bool>(bool in)
{
  return in;
}


template<>
java::lang::String* cxx2lang<java::lang::String*, std::string>(std::string in)
{
  jstring s = _Jv_NewStringLatin1(in.c_str(), in.length());
  return s;
}

template<class Lang, class Cxx>
std::vector<Cxx> lang2cxx_array(JArray<Lang*>* in)
{
  std::vector<Cxx> vect;
  vect.resize(lang2cxx<jint, int>(in->length));
  Lang** T = elements(in);

  for (int i = 0; i < vect.size(); i++)
    vect[i] = lang2cxx<Lang*, Cxx>(T[i]);

  return vect;
}


template<class Lang, class Cxx>
std::vector<Cxx> lang2cxx_array_native(JArray<Lang>* in)
{
  std::vector<Cxx> vect;
  vect.resize(lang2cxx<Lang, Cxx>(in->length));
  Lang* T = elements(in);
  for (int i = 0; i < vect.size(); i++)
    vect[i] = lang2cxx<Lang, Cxx>(T[i]);
  return vect;
}


template<class Lang, class Cxx>
JArray<Lang*>* cxx2lang_array(const std::vector<Cxx>& in)
{
  JArray<Lang*>* out = ( JArray<Lang* > * ) JvNewObjectArray(in.size(), &Lang::class$ , NULL);
  Lang** T = elements(out);

  for (int i = 0; i < in.size(); i++)
    T[i] = cxx2lang<Lang*, Cxx>(in[i]);

  return out;
}

template<class Lang, class Cxx>
JArray<Lang>* cxx2lang_array_native(const std::vector<Cxx>& in)
{
  JArray<Lang>* out = ( JArray<jint > * ) JvNewIntArray(in.size()); // TODO faire moins de merde
  Lang* T = elements(out);
  for (int i = 0; i < in.size(); i++)
    T[i] = in[i];
  return out;
}
///
// Énumération représentant une erreur renvoyée par une des fonctions d'action
//
template<>
erreur lang2cxx<Erreur*, erreur >(Erreur* in)
{
  return erreur(lang2cxx<jint, int>( in->ordinal() ));
}
template<>
Erreur* cxx2lang<Erreur*, erreur >(erreur in)
{
  return *(&Erreur::Ok + (int)in);
}

///
// Énumération représentant les différents types de case
//
template<>
type_case lang2cxx<Type_case*, type_case >(Type_case* in)
{
  return type_case(lang2cxx<jint, int>( in->ordinal() ));
}
template<>
Type_case* cxx2lang<Type_case*, type_case >(type_case in)
{
  return *(&Type_case::Vide + (int)in);
}

///
// Énumération représentant les différents types de bonii
//
template<>
type_bonus lang2cxx<Type_bonus*, type_bonus >(Type_bonus* in)
{
  return type_bonus(lang2cxx<jint, int>( in->ordinal() ));
}
template<>
Type_bonus* cxx2lang<Type_bonus*, type_bonus >(type_bonus in)
{
  return *(&Type_bonus::Pas_bonus + (int)in);
}

///
// Représente une position sur le terrain du jeu
//
template <>
position lang2cxx<Position* , position >(Position* in){
  position out;
  out.x = lang2cxx<jint, int >(in->x);
  out.y = lang2cxx<jint, int >(in->y);
  return out;
}
template <>
Position* cxx2lang<Position*, position>(position in){
  Position* klass = new Position();
  klass->x = cxx2lang<jint, int >(in.x);
  klass->y = cxx2lang<jint, int >(in.y);
  return klass;
}

///
// Caracteristiques d'une unité d'énergie
//
template <>
unite_energie lang2cxx<Unite_energie* , unite_energie >(Unite_energie* in){
  unite_energie out;
  out.id = lang2cxx<jint, int >(in->id);
  out.pos = lang2cxx<Position*, position >(in->pos);
  out.valeur = lang2cxx<jint, int >(in->valeur);
  out.valeur_max = lang2cxx<jint, int >(in->valeur_max);
  return out;
}
template <>
Unite_energie* cxx2lang<Unite_energie*, unite_energie>(unite_energie in){
  Unite_energie* klass = new Unite_energie();
  klass->id = cxx2lang<jint, int >(in.id);
  klass->pos = cxx2lang<Position*, position >(in.pos);
  klass->valeur = cxx2lang<jint, int >(in.valeur);
  klass->valeur_max = cxx2lang<jint, int >(in.valeur_max);
  return klass;
}

///
// Représente une traînée de moto sur le terrain
//
template <>
trainee_moto lang2cxx<Trainee_moto* , trainee_moto >(Trainee_moto* in){
  trainee_moto out;
  out.id = lang2cxx<jint, int >(in->id);
  out.emplacement = lang2cxx_array<  Position, position >(in->emplacement);
  out.team = lang2cxx<jint, int >(in->team);
  out.intensite = lang2cxx<jint, int >(in->intensite);
  return out;
}
template <>
Trainee_moto* cxx2lang<Trainee_moto*, trainee_moto>(trainee_moto in){
  Trainee_moto* klass = new Trainee_moto();
  klass->id = cxx2lang<jint, int >(in.id);
  klass->emplacement = cxx2lang_array< Position, position >(in.emplacement);
  klass->team = cxx2lang<jint, int >(in.team);
  klass->intensite = cxx2lang<jint, int >(in.intensite);
  return klass;
}

jint Interface::mon_equipe()
{
	return cxx2lang<jint, int >(api_mon_equipe());
}
JArray< jint >* Interface::scores()
{
	return cxx2lang_array_native< jint, int >(api_scores());
}
jint Interface::nombre_equipes()
{
	return cxx2lang<jint, int >(api_nombre_equipes());
}
jint Interface::tour_actuel()
{
	return cxx2lang<jint, int >(api_tour_actuel());
}
JArray< Unite_energie* >* Interface::unites_energie()
{
	return cxx2lang_array< Unite_energie, unite_energie >(api_unites_energie());
}
JArray< Trainee_moto* >* Interface::trainees_moto()
{
	return cxx2lang_array< Trainee_moto, trainee_moto >(api_trainees_moto());
}
Type_case* Interface::regarder_type_case(Position* pos)
{
	return cxx2lang<Type_case*, type_case >(api_regarder_type_case(lang2cxx<Position*, position >(pos)));
}
Type_bonus* Interface::regarder_type_bonus(Position* pos)
{
	return cxx2lang<Type_bonus*, type_bonus >(api_regarder_type_bonus(lang2cxx<Position*, position >(pos)));
}
JArray< Type_bonus* >* Interface::regarder_bonus(jint equipe)
{
	return cxx2lang_array< Type_bonus, type_bonus >(api_regarder_bonus(lang2cxx<jint, int >(equipe)));
}
JArray< jint >* Interface::regarder_trainee_case(Position* pos)
{
	return cxx2lang_array_native< jint, int >(api_regarder_trainee_case(lang2cxx<Position*, position >(pos)));
}
jboolean Interface::case_traversable(Position* pos)
{
	return cxx2lang<jboolean, bool >(api_case_traversable(lang2cxx<Position*, position >(pos)));
}
jint Interface::gain_tour_suivant()
{
	return cxx2lang<jint, int >(api_gain_tour_suivant());
}
JArray< Position* >* Interface::chemin(Position* p1, Position* p2)
{
	return cxx2lang_array< Position, position >(api_chemin(lang2cxx<Position*, position >(p1), lang2cxx<Position*, position >(p2)));
}
Erreur* Interface::deplacer(jint id, Position* de, Position* vers)
{
	return cxx2lang<Erreur*, erreur >(api_deplacer(lang2cxx<jint, int >(id), lang2cxx<Position*, position >(de), lang2cxx<Position*, position >(vers)));
}
Erreur* Interface::couper_trainee_moto(jint id, Position* p1, Position* p2, jint intensite_p1)
{
	return cxx2lang<Erreur*, erreur >(api_couper_trainee_moto(lang2cxx<jint, int >(id), lang2cxx<Position*, position >(p1), lang2cxx<Position*, position >(p2), lang2cxx<jint, int >(intensite_p1)));
}
jboolean Interface::annuler()
{
	return cxx2lang<jboolean, bool >(api_annuler());
}
Erreur* Interface::enrouler(jint id, Position* p)
{
	return cxx2lang<Erreur*, erreur >(api_enrouler(lang2cxx<jint, int >(id), lang2cxx<Position*, position >(p)));
}
Erreur* Interface::regenerer_unite_energie(jint id)
{
	return cxx2lang<Erreur*, erreur >(api_regenerer_unite_energie(lang2cxx<jint, int >(id)));
}
Erreur* Interface::allonger_pa()
{
	return cxx2lang<Erreur*, erreur >(api_allonger_pa());
}
Erreur* Interface::etendre_trainee_moto(jint id, jint longueur)
{
	return cxx2lang<Erreur*, erreur >(api_etendre_trainee_moto(lang2cxx<jint, int >(id), lang2cxx<jint, int >(longueur)));
}
Erreur* Interface::poser_point_croisement(Position* point)
{
	return cxx2lang<Erreur*, erreur >(api_poser_point_croisement(lang2cxx<Position*, position >(point)));
}
Erreur* Interface::fusionner(jint id1, Position* pos1, jint id2, Position* pos2)
{
	return cxx2lang<Erreur*, erreur >(api_fusionner(lang2cxx<jint, int >(id1), lang2cxx<Position*, position >(pos1), lang2cxx<jint, int >(id2), lang2cxx<Position*, position >(pos2)));
}
void Interface::afficher_erreur(Erreur* v)
{
	api_afficher_erreur(lang2cxx<Erreur*, erreur >(v));
}
void Interface::afficher_type_case(Type_case* v)
{
	api_afficher_type_case(lang2cxx<Type_case*, type_case >(v));
}
void Interface::afficher_type_bonus(Type_bonus* v)
{
	api_afficher_type_bonus(lang2cxx<Type_bonus*, type_bonus >(v));
}
void Interface::afficher_position(Position* v)
{
	api_afficher_position(lang2cxx<Position*, position >(v));
}
void Interface::afficher_unite_energie(Unite_energie* v)
{
	api_afficher_unite_energie(lang2cxx<Unite_energie*, unite_energie >(v));
}
void Interface::afficher_trainee_moto(Trainee_moto* v)
{
	api_afficher_trainee_moto(lang2cxx<Trainee_moto*, trainee_moto >(v));
}
extern void GC_disable();

struct ProloginJavaVm
{
  ProloginJavaVm()
  {
    using namespace java::lang;
    try
    {
      // create the virtual machine
      JvCreateJavaVM(NULL);
      JvAttachCurrentThread(NULL, NULL);
      // FIXME: grrrr
      // GC_disable();
      JvInitClass(&::Erreur::class$);
      JvInitClass(&::Type_case::class$);
      JvInitClass(&::Type_bonus::class$);
      c = new Prologin();
    }
    catch (Throwable *t)
    {
      System::err->println(JvNewStringLatin1("Unhandled Java exception:"));
      t->printStackTrace();
    }
  }

  ~ProloginJavaVm()
  {
    // destroy the virual machine
    JvDetachCurrentThread();
  }

  Prologin* c;

};

struct ProloginJavaVm javaVm;
///
// Fonction appellée au début de la partie
//
extern "C" void init_game()
{
  try {
    javaVm.c->init_game();
  } catch (java::lang::Throwable *t) {
    fprintf(stderr, "Unhandled Java exception:\n");
    t->printStackTrace();
  }
}

///
// Fonction appellée pour la phase de jeu
//
extern "C" void jouer()
{
  try {
    javaVm.c->jouer();
  } catch (java::lang::Throwable *t) {
    fprintf(stderr, "Unhandled Java exception:\n");
    t->printStackTrace();
  }
}

///
// Fonction appellée à la fin de la partie
//
extern "C" void end_game()
{
  try {
    javaVm.c->end_game();
  } catch (java::lang::Throwable *t) {
    fprintf(stderr, "Unhandled Java exception:\n");
    t->printStackTrace();
  }
}

