#include "link.hh"

#include <stdlib.h>
#include <vector>
using namespace std;

#include "prologin.hh"
#include "debug.hh"

Link::Link() { }


void Link::init() {
    hasBestGoal = false;
    goal = bestGoal();
    if(goal.ok)
        hasBestGoal = true;
}

bool Link::move() {
    if(!hasBestGoal)
        return false;
    erreur err = deplacer(goal.moto.id, goal.bout, goal.chemin.front());
    if(err == OK) {
        goal.bout = goal.chemin.front();
        goal.chemin.erase(goal.chemin.begin());

        if(abs(goal.bout.x - goal.unit.pos.x) <= 1 && abs(goal.bout.y - goal.unit.pos.y) <= 1) {
            msg("Unite atteinte");
            for(vector<unite_energie>::iterator unit = units.begin() ; unit != units.end() ; unit++) {
                if(unit->id == goal.unit.id) {
                    units.erase(unit);
                    break;
                }
            }
            init();
        }

        return true;
    }
    return false;

}


/**
 * Retourne l'unite la plus proche de nos segments et puis merde. Ne me parlez
 * pas de fonction compliquee avec des cubes permettant de calculer un score
 * pour chaque couple a partir des distances et des points, CAR C'EST MOINS
 * EFFICACE QUE CE SYSTEME TOUT CON. Teste et approuve.
 */
LinkGoal Link::bestGoal() {
    vector<trainee_moto> motos = trainees_moto();
    LinkGoal min;
    int minLen = INFINITY;

    // Pour chaque trainee alliee
    for(vector<trainee_moto>::iterator moto = motos.begin() ; moto != motos.end() ; moto++) {
        if(moto->team == MY_TEAM) {
            if(moto->emplacement.size() == moto->intensite)
                continue;
            // Pour chaque extremite
            position e1 = moto->emplacement.front();
            position e2 = moto->emplacement.back();

            // On cherche la distance la plus courte a une unite
            for(vector<unite_energie>::iterator unit = units.begin() ; unit != units.end() ; unit++) {
                position destPos = unit->pos;
                for(int dir=0 ; dir<8 ; dir++) {
                    position newDestPos = destPos;
                    newDestPos.x += deps8[dir][0];
                    newDestPos.y += deps8[dir][1];
                    if(regarder_type_case(newDestPos) == OBSTACLE)
                        continue;

                    vector<position> tmp = chemin(e1, newDestPos);
                    int tmpLen = tmp.size();
                    if(tmpLen != 0 && tmpLen < minLen) {
                        min.unit = *unit;
                        min.moto = *moto;
                        min.bout = e1;
                        min.chemin = tmp;
                        minLen = tmpLen;
                    }

                    tmp = chemin(e2, newDestPos);
                    tmpLen = tmp.size();
                    if(tmpLen != 0 && tmpLen < minLen) {
                        min.unit = *unit;
                        min.moto = *moto;
                        min.bout = e2;
                        min.chemin = tmp;
                        minLen = tmpLen;
                    }
                }
            }
        }
    }

    if(minLen == INFINITY)
        min.ok = false;
    return min;
}


Link::~Link() {
}
