#include "link.hh"

#include <math.h>
#include <vector>
#include <list>
using namespace std;

#include "prologin.hh"
#include "debug.hh"

Link::Link() { }


void Link::init() {
    if(hasBestGoal) {
        switch(goal.phase) {
            case LinkGoal::ENROULER:
            case LinkGoal::COUPER1:
            case LinkGoal::COUPER2:
                return;
                break; // break tres utile
            case LinkGoal::RELIER:
                bool valid = makeLinkWay();
                if(valid)
                    return;
                break;
        }
    }

    hasBestGoal = false;
    goal = bestGoal();
    if(goal.trainee != -22) {
        hasBestGoal = true;
        msg("Couple choisi : %p -> %p (score de %d : pts=%i dis=%i link=%i)", goal.u1.pos, goal.u2.pos, goal.score, goal.points, goal.dis, goal.linkDis);
    }
}

bool Link::move() {
    if(!hasBestGoal)
        return false;

    erreur err;
    LinkGoal nextGoal;
    list<unite_energie> reseau;
    switch(goal.phase) {
        case LinkGoal::REJOINDRE:
        case LinkGoal::RELIER:
            err = deplacer(goal.trainee, goal.bout, goal.chemin.front());
            if(err == OK) {
                msg("Deplacement");
                goal.bout = goal.chemin.front();
                goal.chemin.erase(goal.chemin.begin());
                if(goal.chemin.size() == 0) {
                    goal.phase = (goal.phase == LinkGoal::REJOINDRE ? LinkGoal::ENROULER : LinkGoal::COUPER1);
                }
                return true;
            }
            break;
        case LinkGoal::ENROULER:
            err = enrouler(goal.trainee, goal.bout);
            if(err == OK) {
                msg("Enroulage");
                goal.phase = LinkGoal::RELIER;
                if(!makeLinkWay()) {
                    hasBestGoal = false;
                    init();
                }
                return true;
            }
            break;
        case LinkGoal::COUPER1:
            nextGoal = bestGoal();
            if(nextGoal.trainee == -22)
                return false;
            lockedTrainees.push_back(goal.bout);

            // Suppression des unites dans les listes de celibataires/*{{{*/
            for(std::vector<unite_energie>::iterator src = srcUnits.begin() ; src != srcUnits.end() ; src++) {
                if(src->id == goal.u1.id || src->id == goal.u2.id) {
                    srcUnits.erase(src);
                    break;
                }
            }
            for(std::vector<unite_energie>::iterator con = conUnits.begin() ; con != conUnits.end() ; con++) {
                if(con->id == goal.u1.id || con->id == goal.u2.id) {
                    conUnits.erase(con);
                    break;
                }
            }/*}}}*/
            reseau.push_back(goal.u1);
            reseau.push_back(goal.u2);
            reseaux.push_back(reseau);

            if(nextGoal.trainee != goal.trainee) {
                msg("Objectif accompli");
                hasBestGoal = false;
                init();
            }
            else {
                err = deplacer(goal.trainee, nextGoal.bout, nextGoal.chemin.front());
                if(err == OK) {
                    goal.bout = nextGoal.chemin.front();
                    msg("Se prepare a couper : extremite en %p", goal.bout);
                    goal.phase = LinkGoal::COUPER2;
                    return true;
                }
                else
                    msg("deplacer(%i, %p, %p) = %e", goal.trainee, nextGoal.bout, nextGoal.chemin.front(), err);
            }
            break;
        case LinkGoal::COUPER2:
            position bonBout;
            vector<trainee_moto> listTrainees = trainees_moto();
            for(vector<trainee_moto>::iterator iTr = listTrainees.begin() ; iTr != listTrainees.end() ; iTr++) {
                if(iTr->id == goal.trainee) {
                    if(iTr->emplacement.front() == goal.bout)
                        bonBout = iTr->emplacement[1];
                    else
                        bonBout = iTr->emplacement[iTr->emplacement.size()-2];
                    break;
                }
            }
            err = couper_trainee_moto(goal.trainee, bonBout, goal.bout, 0);
            if(err == OK) {
                msg("Objectif accompli : coupure");
                hasBestGoal = false;
                init();
                return true;
            }
            else
                msg("coupe(%i, %p, %p, 0) = %e", goal.trainee, bonBout, goal.bout, err);
            break;
    }
    return false;

}


LinkGoal Link::bestGoal() {
    vector<trainee_moto> motos = trainees_moto(), myMotos, advMotos;
    int nbAdv = 0;

    // On recupere les trainees alliees (non locked) et adverses/*{{{*/
    for(vector<trainee_moto>::iterator it = motos.begin() ; it != motos.end() ; it++) {
        if(it->team == MY_TEAM) {
            int locked = false;
            for(vector<position>::iterator lock = lockedTrainees.begin() ; lock != lockedTrainees.end() ; lock++) {
                vector<int> trainees = regarder_trainee_case(*lock);
                for(vector<int>::iterator tr = trainees.begin() ; tr != trainees.end() ; tr++) {
                    if(*tr == it->id) {
                        locked = true;
                        break;
                    }
                }
                if(locked)
                    break;
            }
            if(locked)
                continue;
            myMotos.push_back(*it);
        }
        else {
            advMotos.push_back(*it);
            nbAdv++;
        }
    }/*}}}*/

    LinkGoal ret;
    double bestScore = 0;
    bool hasBest = false;
    bool plusProche = false;
    // Pour chaque couple source-consommateur...
    for(vector<unite_energie>::iterator src = srcUnits.begin() ; src != srcUnits.end() ; src++) {
        for(vector<unite_energie>::iterator con = conUnits.begin() ; con != conUnits.end() ; con++) {
            if(disUnits[src->id][con->id] == INFINITY) // Impossible de rejoindre les deux unites
                continue;
            LinkGoal thatGoal;

            int points = ptsUnits[src->id][con->id];
            if(points == 0)
                continue;

            int minDis = INFINITY;
            // On calcule la distance minimale a parcourir/*{{{*/
            // (meilleure trainee, extremite, et ordre des unites d'energie)
            for(vector<trainee_moto>::iterator moto = myMotos.begin() ; moto != myMotos.end() ; moto++) {
                position e1 = moto->emplacement.front();
                position e2 = moto->emplacement.back();
                position depSrc = cheminsUnits[src->id][con->id].front(),
                         depCon = cheminsUnits[src->id][con->id].back();

                // Extremite 1 a source
                vector<position> way = chemin(e1, depSrc);
                int dis = way.size();
                if(dis != 0 && dis < minDis) {
                    thatGoal.chemin = way;
                    thatGoal.u1 = *src;
                    thatGoal.u2 = *con;
                    thatGoal.bout = e1;
                    thatGoal.trainee = moto->id;
                    minDis = dis;
                }

                // Extremite 2 a source
                way = chemin(e2, depSrc);
                dis = way.size();
                if(dis != 0 && dis < minDis) {
                    thatGoal.chemin = way;
                    thatGoal.u1 = *src;
                    thatGoal.u2 = *con;
                    thatGoal.bout = e2;
                    thatGoal.trainee = moto->id;
                    minDis = dis;
                }

                // Extremite 1 a conso
                way = chemin(e1, depCon);
                dis = way.size();
                if(dis != 0 && dis < minDis) {
                    thatGoal.chemin = way;
                    thatGoal.u1 = *con;
                    thatGoal.u2 = *src;
                    thatGoal.bout = e1;
                    thatGoal.trainee = moto->id;
                    minDis = dis;
                }

                // Extremite 2 a conso
                way = chemin(e2, depCon);
                dis = way.size();
                if(dis != 0 && dis < minDis) {
                    thatGoal.chemin = way;
                    thatGoal.u1 = *con;
                    thatGoal.u2 = *src;
                    thatGoal.bout = e2;
                    thatGoal.trainee = moto->id;
                    minDis = dis;
                }
            }/*}}}*/

            int advDis = INFINITY;
            // On calcule la meilleure distance pour l'adversaire/*{{{*/
            // (meilleure trainee, extremite, et ordre des unites d'energie)
            for(vector<trainee_moto>::iterator moto = advMotos.begin() ; moto != advMotos.end() ; moto++) {
                position e1 = moto->emplacement.front();
                position e2 = moto->emplacement.back();
                position depSrc = cheminsUnits[src->id][con->id].front(),
                         depCon = cheminsUnits[src->id][con->id].back();

                // Extremite 1 a source
                int dis = chemin(e1, depSrc).size();
                if(dis != 0 && dis < advDis) {
                    advDis = dis;
                }

                // Extremite 2 a source
                dis = chemin(e2, depSrc).size();
                if(dis != 0 && dis < advDis) {
                    advDis = dis;
                }
                // Extremite 1 a conso
                dis = chemin(e1, depCon).size();
                if(dis != 0 && dis < advDis) {
                    advDis = dis;
                }
                // Extremite 2 a conso
                dis = chemin(e2, depCon).size();
                if(dis != 0 && dis < advDis) {
                    advDis = dis;
                }
            }/*}}}*/

            // Un objectif ou l'adversaire est plus proche que nous ne peut
            // etre le meilleur que s'ils sont tous dans ce cas
            if(plusProche && advDis<minDis)
                continue;

            // Formule de calcul du score : le nombre de points donne un score
            // dans ]0;500] (souvent plus proche de la borne superieure). La
            // distance donne un bonus interessant jusqu'a 20 mais devient un
            // malus a partir de 40. La distance entre les unites a un effet
            // similaire mais moindre : il est interessant en-dessous de 15 et
            // devient un malus au-dessus de 30-35.
            double score = ((double)points/(double)maxPtsUnits)*500.0
                + pow(-(double)minDis/3.0 +10.0, 3)
                + pow(-(double)(disUnits[src->id][con->id])/3.0 +8.0, 3);
            thatGoal.score = score;
            thatGoal.points = points;
            thatGoal.dis = minDis;
            thatGoal.linkDis = disUnits[src->id][con->id];

            // Si l'adversaire a une bonne chance d'arriver avant nous, il y a
            // un malus. Celui-ci est moins important si l'adversaire doit
            // gerer un grand nombre de tranchees.
            if(advDis<minDis) {
                //TODO
            }

            if(!hasBest || score > bestScore) {
                bestScore = score;
                ret = thatGoal;
                hasBest = true;
                plusProche = (advDis<minDis);
            }
        }
    }

    if(!hasBest)
        ret.trainee = -22;
    return ret;
}

bool Link::makeLinkWay() {
    vector<position> linkWay = chemin(goal.bout, cheminsUnits[goal.u1.id][goal.u2.id].back());
    if(linkWay.size() == 0) {
        msg("Liaison rompue !");
        return false;
    }
    goal.chemin = linkWay;
    return true;
}


Link::~Link() {
}
