#include "prologin.hh"

#include <vector>
using namespace std;

#include "link.hh"
#include "debug.hh"

int MY_TEAM, ADV_TEAM;
std::vector<unite_energie> units, srcUnits, conUnits;
std::vector< std::vector<int> > disUnits;
std::vector< std::vector< std::vector<position> > > cheminsUnits;

std::vector< std::vector<int> > ptsUnits;
int maxPtsUnits = 0;

int deps4[][2] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
int deps8[][2] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}, {1, 1}, {1, -1}, {-1, 1}, {-1, -1}};


Link* linker;
void init_game() {
    MY_TEAM = mon_equipe();
    ADV_TEAM = (MY_TEAM==1 ? 0 : 1);

    units = unites_energie();
    for(vector<unite_energie>::iterator it = units.begin() ; it != units.end() ; it++) {
        if(it->valeur_max > 0)
            srcUnits.push_back(*it);
        else
            conUnits.push_back(*it);
    }

    int nbUnits = units.size();
    disUnits.resize(nbUnits);
    for(std::vector< vector<int> >::iterator it=disUnits.begin() ; it!=disUnits.end() ; it++)
        it->resize(nbUnits);

    ptsUnits.resize(nbUnits);
    for(std::vector< vector<int> >::iterator it=ptsUnits.begin() ; it!=ptsUnits.end() ; it++)
        it->resize(nbUnits);

    cheminsUnits.resize(nbUnits);
    for(std::vector< vector< vector<position> > >::iterator it=cheminsUnits.begin() ; it!=cheminsUnits.end() ; it++)
        it->resize(nbUnits);

    linker = new Link();
}


void jouer() {
    linker->init();
    int pa = MAX_PA;

    vector<type_bonus> bonus = regarder_bonus(MY_TEAM);
    for(vector<type_bonus>::iterator it = bonus.begin() ; it != bonus.end() ; it++) {
        if(*it == PLUS_PA) {
            erreur err = allonger_pa();
            if(err == OK) {
                pa += AJOUT_PA;
                msg("Utilisation d'un bonus PA");
            }
            break;
        }
    }

    for(int tour=1 ; tour <= pa ; tour++) {
        linker->move();
    }
}


void end_game() {
    delete linker;
}

