// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cs.rb

using System.Runtime.CompilerServices;

namespace Prologin {
// Énumération représentant une erreur renvoyée par une des fonctions d'action
	public enum Erreur {
		OK, // <- aucune erreur n'est survenue
		ID_INVALIDE, // <- identifiant invalide
		POSITION_INVALIDE, // <- la position spécifiée est invalide
		PLUS_DE_PA, // <- vous n'avez pas assez de points d'action
		BONUS_INVALIDE, // <- vous n'avez pas ce bonus
		PAS_A_TOI, // <- l'unité n'est pas a vous
		INTENSITE_INVALIDE, // <- cette intensité est invalide
	}

// Énumération représentant les différents types de case
	public enum TypeCase {
		VIDE, // <- rien n'est présent sur la case
		OBSTACLE, // <- cette case est inaccessible
		POINT_CROISEMENT, // <- point de croisement de traînées
		UNITE, // <- unité d'énergie
	}

// Énumération représentant les différents types de bonii
	public enum TypeBonus {
		PAS_BONUS, // <- ceci n'est pas un bonus :-)
		BONUS_CROISEMENT, // <- bonus permettant de croiser deux traînées de moto sur une case
		PLUS_LONG, // <- bonus permettant d'agrandir une traînée de moto
		PLUS_PA, // <- bonus permettant d'avoir plus de points d'action
		BONUS_REGENERATION, // <- bonus permettant de regenerer une unité d'énergie
	}

// Représente une position sur le terrain du jeu
	class Position {
		public Position() {
		}
		public int X; // <- coordonnée en X
		public int Y; // <- coordonnée en Y
	}

// Caracteristiques d'une unité d'énergie
	class UniteEnergie {
		public UniteEnergie() {
			Pos = new Position();
		}
		public int Id; // <- identifiant de l'unité d'énergie
		public Position Pos; // <- position de l'unité d'énergie
		public int Valeur; // <- coefficient représentant les points d'énergie que l'unité va vous apporter
		public int ValeurMax; // <- coefficient représentant la capacité de l'unité lorsqu'elle est chargée au maximum
	}

// Représente une traînée de moto sur le terrain
	class TraineeMoto {
		public TraineeMoto() {
			Emplacement = new Position[0];
		}
		public int Id; // <- identifiant de la traînee
		public Position[] Emplacement; // <- position de chaque composant de la traînée de moto
		public int Team; // <- identifiant de l'équipe qui possède cette traînée de moto
		public int Intensite; // <- taille maximale de la traînée
	}

	class Api {
// Taille du terrain
		public const int TAILLE_TERRAIN = 30;

// Nombre de tours par partie
		public const int FIN_PARTIE = 150;

// Nombre de points d'action par tour
		public const int MAX_PA = 3;

// Taille des traînées de moto
		public const int INTENSITE_TRAINEE = 120;

// Longueur maximale de l'allongement
		public const int MAX_ALLONGEMENT = 5;

// Nombre de points d'action à rajouter avec bonus
		public const int AJOUT_PA = 5;

// Retourne le numéro de votre équipe
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int MonEquipe();

// Retourne les scores de chaque équipe
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int[] Scores();

// Retourne le nombre d'équipes sur le terrain
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int NombreEquipes();

// Retourne le numéro du tour actuel
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int TourActuel();

// Retourne la liste des unités d'énergie
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern UniteEnergie[] UnitesEnergie();

// Retourne la liste des traînées de moto
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern TraineeMoto[] TraineesMoto();

// Retourne le type d'une case
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern TypeCase RegarderTypeCase(Position pos);

// Retourne le type de bonus d'une case
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern TypeBonus RegarderTypeBonus(Position pos);

// Retourne la liste des bonus d'une équipe
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern TypeBonus[] RegarderBonus(int equipe);

// Retourne la liste des id des traînées présentes sur une case
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int[] RegarderTraineeCase(Position pos);

// Retourne si une case peut être traversée par une traînée de plus
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool CaseTraversable(Position pos);

// Renvoie les points que vous allez gagner a la fin du tour
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern int GainTourSuivant();

// Renvoie le chemin le plus court entre deux points (fonction lente)
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Position[] Chemin(Position p1, Position p2);

// Déplace une moto
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Deplacer(int id, Position de, Position vers);

// Coupe une traînée de moto en deux nouvelles traînées. « p1 » et « p2 » doivent être deux positions adjacentes occupées par une même traînée de moto.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur CouperTraineeMoto(int id, Position p1, Position p2, int intensite_p1);

// Annule l'action précédente. Renvoie true si une action a été annulée, false sinon.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern bool Annuler();

// Enroule la traînée de moto en un point
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Enrouler(int id, Position p);

// Régénère une unité d'énergie à son maximal
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur RegenererUniteEnergie(int id);

// Allonge le tour en rajoutant des points d'action
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur AllongerPa();

// Allonge une traînée de moto. L'allongement se fera aux prochains déplacements. La longueur du prolongement doit être comprise entre 0 et MAX_ALLONGEMENT (inclus).
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur EtendreTraineeMoto(int id, int longueur);

// Pose un point de croisement sur une case du terrain. La case doit ne pas déjà être un point de croisement.
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur PoserPointCroisement(Position point);

// Fusionne deux traînées de moto. Les deux doivent appartenir à la même équipe, mais doivent être deux traînées distinctes. « pos1 » et « pos2 » doivent être adjacentes et occupées respectivement par « id1 » et « id2 ».
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern Erreur Fusionner(int id1, Position pos1, int id2, Position pos2);

// Affiche le contenu d'une valeur de type erreur
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherErreur(Erreur v);

// Affiche le contenu d'une valeur de type type_case
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherTypeCase(TypeCase v);

// Affiche le contenu d'une valeur de type type_bonus
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherTypeBonus(TypeBonus v);

// Affiche le contenu d'une valeur de type position
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherPosition(Position v);

// Affiche le contenu d'une valeur de type unite_energie
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherUniteEnergie(UniteEnergie v);

// Affiche le contenu d'une valeur de type trainee_moto
		[MethodImplAttribute(MethodImplOptions.InternalCall)]
		public static extern void AfficherTraineeMoto(TraineeMoto v);

	}
}
