#include "debug.hh"

#include <string>
#include <iostream>
#include <stdarg.h>
using namespace std;

#include "prologin.hh"

#define VERBOSE true

void msg(string str, ...) {
    if(!VERBOSE)
        return;

    va_list va;
    va_start(va, str);

    cerr << "[\033[1;95mPik " << mon_equipe() << "\033[0m] ";

    int len = str.size();
    for(int i=0 ; i<len ; i++) {
        if(str[i] == '%' && i != len-1) {
            bool bad = false;
            switch(str[i+1]) {
                case 'p':
                    position tmpp;
                    tmpp = va_arg(va, position);
                    cerr << "(" << tmpp.x << ";" << tmpp.y << ")";
                    break;
                case 'i':
                    int tmpi;
                    tmpi = va_arg(va, int);
                    cerr << tmpi;
                    break;
                case 'd':
                    double tmpd;
                    tmpd = va_arg(va, double);
                    cerr << tmpd;
                    break;
                default:
                    cerr << '%';
                    bad = true;
                    break;
            }
            if(!bad)
                i++;
        }
        else
            cerr << str[i];
    }

    cerr << endl;

    va_end(va);
}
