///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_c.rb
//

#include "interface.hh"
#include <cstdlib>

template<typename Lang, typename Cxx>
Cxx lang2cxx(Lang in)
{
  return in.error;
}

template<>
std_string lang2cxx<charp, std_string>(charp in)
{
  return in;
}

template<>
int lang2cxx<int, int>(int in)
{
  return in;
}

template<>
bool lang2cxx<int, bool>(int in)
{
  return in;
}

template<typename Lang, typename Cxx>
void lang2cxx_array(Lang* tab, size_t len, std::vector<Cxx>& vect)
{
  vect.reserve(len);
  for (size_t i = 0; i < len; ++i)
    vect.push_back( lang2cxx<Lang, Cxx>(tab[i]) );
}

template<typename Lang, typename Cxx>
Lang cxx2lang(Cxx in)
{
  return in.error;
}

template<>
charp cxx2lang<charp, std_string>(std_string in)
{
  size_t l = in.length();
  char * out = (char *) malloc(l + 1);
  for (int i = 0; i < l; i++) out[i] = in[i];
  out[l] = 0;
  return out;
}

template<>
int cxx2lang<int, bool>(bool in)
{
  return in;
}

template<>
int cxx2lang<int, int>(int in)
{
  return in;
}

template<typename Lang, typename Cxx>
void cxx2lang_array(Lang** tab, size_t* len, const std::vector<Cxx>& vect)
{
  *len = vect.size();
  *tab = (Lang *)malloc((*len) * sizeof(Lang));
  for (int i = 0; i < *len; ++i)
    (*tab)[i] = cxx2lang<Lang, Cxx>(vect[i]);
}
///
// Énumération représentant une erreur renvoyée par une des fonctions d'action
//
template<>
erreur lang2cxx<erreur, erreur>(erreur in) {
 return in;
}
template<>
erreur cxx2lang<erreur, erreur>(erreur in) {
 return in;
}

///
// Énumération représentant les différents types de case
//
template<>
type_case lang2cxx<type_case, type_case>(type_case in) {
 return in;
}
template<>
type_case cxx2lang<type_case, type_case>(type_case in) {
 return in;
}

///
// Énumération représentant les différents types de bonii
//
template<>
type_bonus lang2cxx<type_bonus, type_bonus>(type_bonus in) {
 return in;
}
template<>
type_bonus cxx2lang<type_bonus, type_bonus>(type_bonus in) {
 return in;
}

///
// Représente une position sur le terrain du jeu
//
template<>
__internal__cxx__position lang2cxx<position, __internal__cxx__position>(position in) {
__internal__cxx__position out;
out.x = lang2cxx<int, int>(in.x);
out.y = lang2cxx<int, int>(in.y);
 return out;
}
template<>
position cxx2lang<position, __internal__cxx__position>(__internal__cxx__position in) {
position out;
out.x = cxx2lang<int, int>(in.x);
out.y = cxx2lang<int, int>(in.y);
 return out;
}

///
// Caracteristiques d'une unité d'énergie
//
template<>
__internal__cxx__unite_energie lang2cxx<unite_energie, __internal__cxx__unite_energie>(unite_energie in) {
__internal__cxx__unite_energie out;
out.id = lang2cxx<int, int>(in.id);
out.pos = lang2cxx<position, __internal__cxx__position>(in.pos);
out.valeur = lang2cxx<int, int>(in.valeur);
out.valeur_max = lang2cxx<int, int>(in.valeur_max);
 return out;
}
template<>
unite_energie cxx2lang<unite_energie, __internal__cxx__unite_energie>(__internal__cxx__unite_energie in) {
unite_energie out;
out.id = cxx2lang<int, int>(in.id);
out.pos = cxx2lang<position, __internal__cxx__position>(in.pos);
out.valeur = cxx2lang<int, int>(in.valeur);
out.valeur_max = cxx2lang<int, int>(in.valeur_max);
 return out;
}

///
// Représente une traînée de moto sur le terrain
//
template<>
__internal__cxx__trainee_moto lang2cxx<trainee_moto, __internal__cxx__trainee_moto>(trainee_moto in) {
__internal__cxx__trainee_moto out;
out.id = lang2cxx<int, int>(in.id);
lang2cxx_array<position, __internal__cxx__position>(in.emplacement_arr, in.emplacement_len, out.emplacement);
out.team = lang2cxx<int, int>(in.team);
out.intensite = lang2cxx<int, int>(in.intensite);
 return out;
}
template<>
trainee_moto cxx2lang<trainee_moto, __internal__cxx__trainee_moto>(__internal__cxx__trainee_moto in) {
trainee_moto out;
out.id = cxx2lang<int, int>(in.id);
cxx2lang_array<position, __internal__cxx__position>(&out.emplacement_arr, &out.emplacement_len, in.emplacement);
out.team = cxx2lang<int, int>(in.team);
out.intensite = cxx2lang<int, int>(in.intensite);
 return out;
}

extern "C" {
///
// Retourne le numéro de votre équipe
//
int mon_equipe(void)
{
  int _retval;
  _retval = api_mon_equipe();
  return cxx2lang<int, int>(_retval);
}

///
// Retourne les scores de chaque équipe
//
void scores(int** ret_arr, size_t* ret_len)
{
  std::vector<int> _retval;
  _retval = api_scores();
  cxx2lang_array<int, int>(ret_arr, ret_len, _retval);
}

///
// Retourne le nombre d'équipes sur le terrain
//
int nombre_equipes(void)
{
  int _retval;
  _retval = api_nombre_equipes();
  return cxx2lang<int, int>(_retval);
}

///
// Retourne le numéro du tour actuel
//
int tour_actuel(void)
{
  int _retval;
  _retval = api_tour_actuel();
  return cxx2lang<int, int>(_retval);
}

///
// Retourne la liste des unités d'énergie
//
void unites_energie(unite_energie** ret_arr, size_t* ret_len)
{
  std::vector<__internal__cxx__unite_energie> _retval;
  _retval = api_unites_energie();
  cxx2lang_array<unite_energie, __internal__cxx__unite_energie>(ret_arr, ret_len, _retval);
}

///
// Retourne la liste des traînées de moto
//
void trainees_moto(trainee_moto** ret_arr, size_t* ret_len)
{
  std::vector<__internal__cxx__trainee_moto> _retval;
  _retval = api_trainees_moto();
  cxx2lang_array<trainee_moto, __internal__cxx__trainee_moto>(ret_arr, ret_len, _retval);
}

///
// Retourne le type d'une case
//
type_case regarder_type_case(position pos)
{
  type_case _retval;
  __internal__cxx__position param_pos = lang2cxx<position, __internal__cxx__position>(pos);
  _retval = api_regarder_type_case(param_pos);
  return cxx2lang<type_case, type_case>(_retval);
}

///
// Retourne le type de bonus d'une case
//
type_bonus regarder_type_bonus(position pos)
{
  type_bonus _retval;
  __internal__cxx__position param_pos = lang2cxx<position, __internal__cxx__position>(pos);
  _retval = api_regarder_type_bonus(param_pos);
  return cxx2lang<type_bonus, type_bonus>(_retval);
}

///
// Retourne la liste des bonus d'une équipe
//
void regarder_bonus(int equipe, type_bonus** ret_arr, size_t* ret_len)
{
  std::vector<type_bonus> _retval;
  int param_equipe = lang2cxx<int, int>(equipe);
  _retval = api_regarder_bonus(param_equipe);
  cxx2lang_array<type_bonus, type_bonus>(ret_arr, ret_len, _retval);
}

///
// Retourne la liste des id des traînées présentes sur une case
//
void regarder_trainee_case(position pos, int** ret_arr, size_t* ret_len)
{
  std::vector<int> _retval;
  __internal__cxx__position param_pos = lang2cxx<position, __internal__cxx__position>(pos);
  _retval = api_regarder_trainee_case(param_pos);
  cxx2lang_array<int, int>(ret_arr, ret_len, _retval);
}

///
// Retourne si une case peut être traversée par une traînée de plus
//
int case_traversable(position pos)
{
  bool _retval;
  __internal__cxx__position param_pos = lang2cxx<position, __internal__cxx__position>(pos);
  _retval = api_case_traversable(param_pos);
  return cxx2lang<int, bool>(_retval);
}

///
// Renvoie les points que vous allez gagner a la fin du tour
//
int gain_tour_suivant(void)
{
  int _retval;
  _retval = api_gain_tour_suivant();
  return cxx2lang<int, int>(_retval);
}

///
// Renvoie le chemin le plus court entre deux points (fonction lente)
//
void chemin(position p1, position p2, position** ret_arr, size_t* ret_len)
{
  std::vector<__internal__cxx__position> _retval;
  __internal__cxx__position param_p1 = lang2cxx<position, __internal__cxx__position>(p1);
  __internal__cxx__position param_p2 = lang2cxx<position, __internal__cxx__position>(p2);
  _retval = api_chemin(param_p1, param_p2);
  cxx2lang_array<position, __internal__cxx__position>(ret_arr, ret_len, _retval);
}

///
// Déplace une moto
//
erreur deplacer(int id, position de, position vers)
{
  erreur _retval;
  int param_id = lang2cxx<int, int>(id);
  __internal__cxx__position param_de = lang2cxx<position, __internal__cxx__position>(de);
  __internal__cxx__position param_vers = lang2cxx<position, __internal__cxx__position>(vers);
  _retval = api_deplacer(param_id, param_de, param_vers);
  return cxx2lang<erreur, erreur>(_retval);
}

///
// Coupe une traînée de moto en deux nouvelles traînées. « p1 » et « p2 » doivent être deux positions adjacentes occupées par une même traînée de moto.
//
erreur couper_trainee_moto(int id, position p1, position p2, int intensite_p1)
{
  erreur _retval;
  int param_id = lang2cxx<int, int>(id);
  __internal__cxx__position param_p1 = lang2cxx<position, __internal__cxx__position>(p1);
  __internal__cxx__position param_p2 = lang2cxx<position, __internal__cxx__position>(p2);
  int param_intensite_p1 = lang2cxx<int, int>(intensite_p1);
  _retval = api_couper_trainee_moto(param_id, param_p1, param_p2, param_intensite_p1);
  return cxx2lang<erreur, erreur>(_retval);
}

///
// Annule l'action précédente. Renvoie true si une action a été annulée, false sinon.
//
int annuler(void)
{
  bool _retval;
  _retval = api_annuler();
  return cxx2lang<int, bool>(_retval);
}

///
// Enroule la traînée de moto en un point
//
erreur enrouler(int id, position p)
{
  erreur _retval;
  int param_id = lang2cxx<int, int>(id);
  __internal__cxx__position param_p = lang2cxx<position, __internal__cxx__position>(p);
  _retval = api_enrouler(param_id, param_p);
  return cxx2lang<erreur, erreur>(_retval);
}

///
// Régénère une unité d'énergie à son maximal
//
erreur regenerer_unite_energie(int id)
{
  erreur _retval;
  int param_id = lang2cxx<int, int>(id);
  _retval = api_regenerer_unite_energie(param_id);
  return cxx2lang<erreur, erreur>(_retval);
}

///
// Allonge le tour en rajoutant des points d'action
//
erreur allonger_pa(void)
{
  erreur _retval;
  _retval = api_allonger_pa();
  return cxx2lang<erreur, erreur>(_retval);
}

///
// Allonge une traînée de moto. L'allongement se fera aux prochains déplacements. La longueur du prolongement doit être comprise entre 0 et MAX_ALLONGEMENT (inclus).
//
erreur etendre_trainee_moto(int id, int longueur)
{
  erreur _retval;
  int param_id = lang2cxx<int, int>(id);
  int param_longueur = lang2cxx<int, int>(longueur);
  _retval = api_etendre_trainee_moto(param_id, param_longueur);
  return cxx2lang<erreur, erreur>(_retval);
}

///
// Pose un point de croisement sur une case du terrain. La case doit ne pas déjà être un point de croisement.
//
erreur poser_point_croisement(position point)
{
  erreur _retval;
  __internal__cxx__position param_point = lang2cxx<position, __internal__cxx__position>(point);
  _retval = api_poser_point_croisement(param_point);
  return cxx2lang<erreur, erreur>(_retval);
}

///
// Fusionne deux traînées de moto. Les deux doivent appartenir à la même équipe, mais doivent être deux traînées distinctes. « pos1 » et « pos2 » doivent être adjacentes et occupées respectivement par « id1 » et « id2 ».
//
erreur fusionner(int id1, position pos1, int id2, position pos2)
{
  erreur _retval;
  int param_id1 = lang2cxx<int, int>(id1);
  __internal__cxx__position param_pos1 = lang2cxx<position, __internal__cxx__position>(pos1);
  int param_id2 = lang2cxx<int, int>(id2);
  __internal__cxx__position param_pos2 = lang2cxx<position, __internal__cxx__position>(pos2);
  _retval = api_fusionner(param_id1, param_pos1, param_id2, param_pos2);
  return cxx2lang<erreur, erreur>(_retval);
}

///
// Affiche le contenu d'une valeur de type erreur
//
void afficher_erreur(erreur v)
{
  erreur param_v = lang2cxx<erreur, erreur>(v);
api_afficher_erreur(param_v);
}

///
// Affiche le contenu d'une valeur de type type_case
//
void afficher_type_case(type_case v)
{
  type_case param_v = lang2cxx<type_case, type_case>(v);
api_afficher_type_case(param_v);
}

///
// Affiche le contenu d'une valeur de type type_bonus
//
void afficher_type_bonus(type_bonus v)
{
  type_bonus param_v = lang2cxx<type_bonus, type_bonus>(v);
api_afficher_type_bonus(param_v);
}

///
// Affiche le contenu d'une valeur de type position
//
void afficher_position(position v)
{
  __internal__cxx__position param_v = lang2cxx<position, __internal__cxx__position>(v);
api_afficher_position(param_v);
}

///
// Affiche le contenu d'une valeur de type unite_energie
//
void afficher_unite_energie(unite_energie v)
{
  __internal__cxx__unite_energie param_v = lang2cxx<unite_energie, __internal__cxx__unite_energie>(v);
api_afficher_unite_energie(param_v);
}

///
// Affiche le contenu d'une valeur de type trainee_moto
//
void afficher_trainee_moto(trainee_moto v)
{
  __internal__cxx__trainee_moto param_v = lang2cxx<trainee_moto, __internal__cxx__trainee_moto>(v);
api_afficher_trainee_moto(param_v);
}

}
