#include "prologin.hh"

#include <vector>
using namespace std;

#include "link.hh"
#include "debug.hh"

int MY_TEAM, ADV_TEAM;
std::vector<unite_energie> units, srcUnits, conUnits;
std::vector< std::vector<int> > disUnits;
std::vector< std::vector< std::vector<position> > > cheminsUnits;

std::vector< std::list<unite_energie> > reseaux;

std::vector< std::vector<int> > ptsUnits;
int maxPtsUnits = 0;

std::vector<position> lockedTrainees;

int deps4[][2] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
int deps8[][2] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}, {1, 1}, {1, -1}, {-1, 1}, {-1, -1}};


Link* linker;
void init_game() {
    MY_TEAM = mon_equipe();
    ADV_TEAM = (MY_TEAM==1 ? 0 : 1);

    units = unites_energie();
    for(vector<unite_energie>::iterator it = units.begin() ; it != units.end() ; it++) {
        if(it->valeur_max > 0)
            srcUnits.push_back(*it);
        else
            conUnits.push_back(*it);
    }

    int nbUnits = units.size();
    disUnits.resize(nbUnits);
    for(std::vector< vector<int> >::iterator it=disUnits.begin() ; it!=disUnits.end() ; it++)
        it->resize(nbUnits);

    ptsUnits.resize(nbUnits);
    for(std::vector< vector<int> >::iterator it=ptsUnits.begin() ; it!=ptsUnits.end() ; it++)
        it->resize(nbUnits);

    cheminsUnits.resize(nbUnits);
    for(std::vector< vector< vector<position> > >::iterator it=cheminsUnits.begin() ; it!=cheminsUnits.end() ; it++)
        it->resize(nbUnits);

    linker = new Link();
}

void calcPoints() {
    maxPtsUnits = 0;
    for(vector<unite_energie>::iterator src = srcUnits.begin() ; src != srcUnits.end() ; src++) {
        for(vector<unite_energie>::iterator con = conUnits.begin() ; con != conUnits.end() ; con++) {
            ptsUnits[src->id][con->id] = min(src->valeur, -con->valeur);
            ptsUnits[con->id][src->id] = min(src->valeur, -con->valeur);
            if(ptsUnits[src->id][con->id] > maxPtsUnits)
                maxPtsUnits = ptsUnits[src->id][con->id];
        }
    }
}


void jouer() {
    calcDisUnits();
    calcPoints();

    int pa = 3;

    linker->init();
    for(int i=1 ; i<=3 ; i++) {
        if(linker->move())
            pa--;
    }
}

void calcDisUnits() {
    for(vector<unite_energie>::iterator src = srcUnits.begin() ; src != srcUnits.end() ; src++) {
        position srcPos = src->pos;
        for(vector<unite_energie>::iterator con = conUnits.begin() ; con != conUnits.end() ; con++) {
            position conPos = con->pos;

            vector<position> min;
            int minLen = INFINITY;
            for(int dir1=0 ; dir1<8 ; dir1++) {
                position newSrcPos = srcPos;
                newSrcPos.x += deps8[dir1][0];
                newSrcPos.y += deps8[dir1][1];
                if(regarder_type_case(newSrcPos) == OBSTACLE)
                    continue;
                for(int dir2=0 ; dir2<8 ; dir2++) {
                    position newConPos = conPos;
                    newConPos.x += deps8[dir2][0];
                    newConPos.y += deps8[dir2][1];
                    if(regarder_type_case(newConPos) == OBSTACLE)
                        continue;

                    vector<position> tmp = chemin(newSrcPos, newConPos);
                    tmp.insert(tmp.begin(), newSrcPos);
                    int tmpLen = tmp.size();
                    if(tmpLen > 1 && tmpLen < minLen) {
                        min = tmp;
                        minLen = tmpLen;
                    }
                }
            }

            cheminsUnits[src->id][con->id] = min;
            vector<position> reversedMin(min.rbegin(), min.rend());
            cheminsUnits[con->id][src->id] = reversedMin;

            disUnits[src->id][con->id] = minLen;
            disUnits[con->id][src->id] = minLen;
        }
    }
}


void end_game() {
    delete linker;
}

bool operator==(position p1, position p2) {
    return (p1.x == p2.x && p1.y == p2.y);
}
