#include "debug.hh"

#include <string>
#include <iostream>
#include <stdarg.h>
using namespace std;

#include "prologin.hh"

#define VERBOSE true

void msg(string str, ...) {
    if(!VERBOSE)
        return;

    va_list va;
    va_start(va, str);

    cerr << "[\033[1;95mPik " << mon_equipe() << "\033[0m] ";

    int len = str.size();
    for(int i=0 ; i<len ; i++) {
        if(str[i] == '%' && i != len-1) {
            bool bad = false;
            switch(str[i+1]) {
                case 'p':
                    position tmpp;
                    tmpp = va_arg(va, position);
                    cerr << "(" << tmpp.x << ";" << tmpp.y << ")";
                    break;
                case 'e':
                    int tmpe;
                    tmpe = va_arg(va, int);
                    switch(tmpe) {
                        case OK: cerr << "\033[32mOK\033[0m"; break;
                        case ID_INVALIDE: cerr << "\033[41mID_INVALIDE\033[0m"; break;
                        case POSITION_INVALIDE: cerr << "\033[41mPOSITION_INVALIDE\033[0m"; break;
                        case PLUS_DE_PA: cerr << "\033[41mPLUS_DE_PA\033[0m"; break;
                        case BONUS_INVALIDE: cerr << "\033[41mBONUS_INVALIDE\033[0m"; break;
                        case PAS_A_TOI: cerr << "\033[41mPAS_A_TOI\033[0m"; break;
                        case INTENSITE_INVALIDE: cerr << "\033[41mID_INVALIDE\033[0m"; break;
                    }
                    break;
                case 'i':
                    int tmpi;
                    tmpi = va_arg(va, int);
                    cerr << tmpi;
                    break;
                case 'd':
                    double tmpd;
                    tmpd = va_arg(va, double);
                    cerr << tmpd;
                    break;
                default:
                    cerr << '%';
                    bad = true;
                    break;
            }
            if(!bad)
                i++;
        }
        else
            cerr << str[i];
    }

    cerr << endl;

    va_end(va);
}
