#ifndef _LINK_HH
#define _LINK_HH

#include <vector>

#include "prologin.hh"

struct LinkGoal {
    unite_energie u1, u2;
    position bout;
    std::vector<position> chemin;
    int trainee;
    enum Phase { REJOINDRE, ENROULER, RELIER, COUPER1, COUPER2 } phase;

    // Debug
    double score;
    int points, dis, linkDis;

    LinkGoal() : trainee(-22), phase(REJOINDRE) {}
};

class Link {
    public:
        Link();
        virtual ~Link();

        /**
         * Definis l'objectif du tour
         */
        void init();

        /**
         * Avance la trainee vers son objectif (1PA)
         * @return true si un deplacement a ete effectue
         */
        bool move();

    protected:
        LinkGoal goal;

        /**
         * Retourne le "meilleur" objectif pour Link (non, ce n'est pas Zelda)
         * Il est defini par une formule prenant en compte la distance, la distance de
         * l'adversaire, le nombre de trainees adverses, et evidemment le nombre de
         * points qu'il permet d'obtenir.
         */
        LinkGoal bestGoal();
        bool hasBestGoal;

        bool makeLinkWay();
};

#endif
