#include <vector>

#include "analyse.hh"
#include "prologin.hh"
#include "debug.hh"

using namespace std;

vector< vector<bool> > carte;
unite perr_all;
unite perr_adv;

vector< vector<portee_singe> > all_zone_singes;
vector< vector<portee_singe> > enn_zone_singes;

vector< vector<portee_singe> > all_zone;
vector< vector<portee_singe> > enn_zone;


void mkCarteAndInfos() {
    taille_terrain lim = taille_terrain_actuelle();
    carte.clear();
    carte.resize(TAILLE_DEPART);
    for(int i=0 ; i<=lim.max_coord ; i++) {
	carte[i].clear();
	carte[i].resize(TAILLE_DEPART);
	for(int j=0 ; j<=lim.max_coord ; j++)
	    carte[i][j] = false;
    }

    vector<unite> toons = unites();

    for(vector<unite>::iterator it = toons.begin() ; it != toons.end() ; ++it) {
	carte[(*it).pos.x][(*it).pos.y] = true;
	if((*it).ennemi && ((*it).vrai_type_unite == PERROQUET))
	    perr_adv = (*it);
	else if(!(*it).ennemi && ((*it).vrai_type_unite == PERROQUET))
	    perr_all = (*it);
    }


}

void analyse_def_singes() {
    taille_terrain lim = taille_terrain_actuelle();

    all_zone_singes.clear();
    all_zone_singes.resize(TAILLE_DEPART);
    enn_zone_singes.clear();
    enn_zone_singes.resize(TAILLE_DEPART);

    for(int i=0 ; i<=lim.max_coord ; i++) {
	all_zone_singes[i].clear();
	all_zone_singes[i].resize(TAILLE_DEPART);
	enn_zone_singes[i].clear();
	enn_zone_singes[i].resize(TAILLE_DEPART);
	for(int j=0 ; j<=lim.max_coord ; j++) {
	    all_zone_singes[i][j] = NO;
	    enn_zone_singes[i][j] = NO;
	}
    }

    vector<unite> ptoons = unites();


    for(vector<unite>::iterator it = ptoons.begin() ; it != ptoons.end() ; ++it) {
	if((*it).type_unite_actuel != SINGE || (*it).ko >= 0)
	    continue;

	vector< vector<portee_singe> >* zone = ((*it).ennemi ? &enn_zone_singes : &all_zone_singes);

	// Distance 4 par x
	for(int i=(*it).pos.x-4 ; i<=(*it).pos.x+4 ; i+=8) {
	    if(i < lim.min_coord || i > lim.max_coord)
		continue;
	    for(int j=(*it).pos.y-4 ; j<=(*it).pos.y+4 ; j++) {
		if(j < lim.min_coord || j > lim.max_coord)
		    continue;
		if((*zone)[i][j] == NO)
		    (*zone)[i][j] = AVANCE;
	    }
	}

	// Distance 4 par y
	for(int j=(*it).pos.y-4 ; j<=(*it).pos.y+4 ; j+=8) {
	    if(j < lim.min_coord || j > lim.max_coord)
		continue;
	    for(int i=(*it).pos.x-4 ; i<=(*it).pos.x+4 ; i++) {
		if(i < lim.min_coord || i > lim.max_coord)
		    continue;
		if((*zone)[i][j] == NO)
		    (*zone)[i][j] = AVANCE;
	    }
	}

	// Distance 3
	for(int i=(*it).pos.x-3 ; i<=(*it).pos.x+3 ; i++) {
	    if(i < lim.min_coord || i > lim.max_coord)
		continue;
	    for(int j=(*it).pos.y-3 ; j<=(*it).pos.y+3 ; j++) {
		if(j < lim.min_coord || j > lim.max_coord)
		    continue;
		(*zone)[i][j] = DIRECT;
	    }
	}
    }
}

void analyse_zones() {
    all_zone = all_zone_singes;
    enn_zone = enn_zone_singes;

    vector<unite> ptoons = unites();
    taille_terrain lim = taille_terrain_actuelle();

    for(vector<unite>::iterator it = ptoons.begin() ; it != ptoons.end() ; ++it) {
	if((*it).type_unite_actuel == SINGE)
	    continue;

	vector< vector<portee_singe> >* zone = ((*it).ennemi ? &enn_zone : &all_zone);

	int portee = caracteristiques((*it).type_unite_actuel).portee + caracteristiques((*it).type_unite_actuel).pa_init -1;

	for(int i=(*it).pos.x-portee ; i<=(*it).pos.x+portee ; i++) {
	    if(i < lim.min_coord || i > lim.max_coord)
		continue;
	    for(int j=(*it).pos.y-portee ; j<=(*it).pos.y+portee ; j++) {
		if(j < lim.min_coord || j > lim.max_coord)
		    continue;
		(*zone)[i][j] = DIRECT;
	    }
	}
    }

    cout << enn_zone;
}

void analyse() {
    mkCarteAndInfos();
    analyse_def_singes();
    analyse_zones();
}
