///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_cxx.rb
//

#include "prologin.hh"

#include <iostream>
#include <list>

#include "global.hh"
#include "debug.hh"
#include "analyse.hh"

#include "module.hh"
#include "chavicieux.hh"
#include "parksinges.hh"
#include "singeguard.hh"

using namespace std;

extern list<Module*> mods;

extern unite perr_all;

bool premierTour;


///
// Fonction appelle au dbut de la partie.
//
void init_game() {
    premierTour = true;
}

// Dtermine la meilleure unit  laquelle enlever le ko en fonction de son type
short prefKo(type_unite type) {
    switch(type) {
	case SINGE:
	    return 10;
	case KANGOUROU:
	    return 5;
	case CHAT:
	    return 0;
	case PERROQUET:
	    return -22;
    }
    return -42;
}

///
// Fonction appelle pour la phase de retrait de KO.
//
position retirer_ko() {
    vector<unite> ptoons = unites();
    unite ko2;
    ko2.ennemi = false;
    vector<unite> ko1;

    for(vector<unite>::iterator it = ptoons.begin() ; it != ptoons.end() ; ++it) {
	if(!(*it).ennemi)
	    continue;

	switch((*it).ko) {
	    // Si il y a un ennemi  3 kos, on le prend
	    case 3:
		cout << "retire ko de : " << (*it) << endl;
		return (*it).pos;
		break;
		// Si il y a un ennemi  2 kos, on le rserve au cas o il n'y en aurait pas  3
	    case 2:
		if(ko2.ennemi == false)
		    ko2 = (*it);
		break;
		// On rcupre tous les 1 kos, pour choisir le bon s'il n'y a ni 2 ni 3
	    case 1:
		ko1.push_back((*it));
		break;
	}
    }

    if(ko2.ennemi == true) {
	cout << "retire ko de : " << ko2 << endl;
	return ko2.pos;
    }

    type_unite actu = PERROQUET;
    vector<unite> ko1_best;

    for(vector<unite>::iterator it = ko1.begin() ; it != ko1.end() ; ++it) {
	if((*it).vrai_type_unite == actu)
	    ko1_best.push_back(*it);
	else if(prefKo((*it).vrai_type_unite) > prefKo(actu)) {
	    ko1_best.clear();
	    ko1_best.push_back(*it);
	    actu = (*it).vrai_type_unite;
	}
    }

    //TODO: systme de prfrences par unit en fonction de sa position sur le plateau
    cout << "Retire ko de : " << ko1_best[0] << endl;
    return ko1_best[0].pos;
}


///
// Fonction appele pour la phase de jeu.
//
void jouer()
{
    if(premierTour) {
	premierTour = false;
	position arrivee = pos_renfort(false);
	arrivee.x--;
	deplacer(pos_renfort(false), arrivee);
	renfort(CHAT);
	mods.push_front(new Singeguard());
	mods.push_back(new Chavicieux(pos_renfort(false)));
	mods.push_back(new Parksinges());
	return;
    }

    analyse();

    taille_terrain lim = taille_terrain_actuelle();
    if(perr_all.pos.y == lim.min_coord) {
	position newPos = perr_all.pos; newPos.x--; newPos.y++;
	erreur err = deplacer(perr_all.pos, newPos);
	if(err != OK) {
	    newPos.x++;
	    deplacer(perr_all.pos, newPos);
	}
    }
    else if(perr_all.pos.y == lim.max_coord) {
	position newPos = perr_all.pos; newPos.x--; newPos.y--;
	erreur err = deplacer(perr_all.pos, newPos);
	if(err != OK) {
	    newPos.x++;
	    deplacer(perr_all.pos, newPos);
	}
    }
    
    dbg_mods(mods);

    for(list<Module*>::iterator it = mods.begin() ; it != mods.end() ; it++) {
	if((*it)->win())
	    (*it)->run();
    }
    for(list<Module*>::iterator it = mods.begin() ; it != mods.end() ; it++) {
	dbg_lancement_module(*it);
	(*it)->run();
    }

}

///
// Fonction appelle  la fin de la partie.
//
void end_game()
{
    // fonction a completer
}

