#include "singeguard.hh"
#include "prologin.hh"
#include "analyse.hh"
#include "global.hh"
#include "debug.hh"

#include <cmath>
#include <cstdlib>
#include <vector>

using namespace std;

extern vector< vector<bool> > carte;
//extern unite perr_adv;

extern vector< vector<portee_singe> > all_zone_singes;
//extern vector< vector<portee_singe> > enn_zone_singes;

Singeguard::Singeguard() { }

string Singeguard::nom() {
    return "Singeguard";
}

void Singeguard::run() {
    vector<unite> toons = unites();
    vector<unite> singes;
    vector<unite> intrus;
    int nbSinges = 0, nbIntrus = 0;

    cout << all_zone_singes;

    for(vector<unite>::iterator it = toons.begin() ; it != toons.end() ; ++it) {
	if((*it).ennemi && all_zone_singes[(*it).pos.x][(*it).pos.y] != NO && (*it).ko < 0) {
	    intrus.push_back(*it);
	    nbIntrus++;
	}
	if(!(*it).ennemi && (*it).type_unite_actuel == SINGE && (*it).ko < 0) {
	    singes.push_back(*it);
	    nbSinges++;
	}
    }

    cout << "Il y a " << nbIntrus << " intrus et " << nbSinges << " singe(s) gardien(s)." << endl;

    if(nbIntrus == 0)
	return;

    // On dtermine quels singes peuvent liminer quels intrus
    vector< vector<bool> > matMiam(nbSinges, vector<bool>(nbIntrus, false));
    for(int i=0 ; i<nbSinges ; i++)
	for(int j=0 ; j<nbIntrus ; j++)
	    matMiam[i][j] = (dis(singes[i].pos, intrus[j].pos));

    vector<int> morts(nbIntrus, -1);
    miam jaifaim = bestCombin(nbSinges, nbIntrus, intrus, singes, matMiam, 0, morts);

    for(int i=0 ; i<nbIntrus ; i++) {
	if(jaifaim.victimes[i] < 0)
	    continue;
	cout << intrus[i] << " est banan par " << singes[jaifaim.victimes[i]] << endl;
	banane(singes[jaifaim.victimes[i]], intrus[i]);
    }
}

void Singeguard::banane(unite att, unite vic) {
    if(dis(att.pos, vic.pos) > 4) {
	cout << "Units trop loignes !!!" << endl;
	return;
    }
    if(dis(att.pos, vic.pos) == 4) {
	cout << "Avance :";
	position newPos = att.pos;

	if(abs(att.pos.x - vic.pos.x) == 4) {
	    if(att.pos.x < vic.pos.x) {
		cout << " x+1";
		newPos.x++;
	    }
	    else {
		cout << " x-1";
		newPos.x--;
	    }
	}
	if(abs(att.pos.y - vic.pos.y) == 4) {
	    if(att.pos.y < vic.pos.y) {
		cout << " y+1";
		newPos.y++;
	    }
	    else {
		cout << " y-1";
		newPos.y--;
	    }
	}
	cout << endl;

	erreur err = deplacer(att.pos, newPos);
	if(err != OK)
	    afficher_erreur(err);
	err = attaquer(newPos, vic.pos);
	if(err != OK)
	    afficher_erreur(err);
    }
    else {
	erreur err = attaquer(att.pos, vic.pos);
	if(err != OK)
	    afficher_erreur(err);
    }
}

miam Singeguard::bestCombin(int& nbSinges, int& nbIntrus, vector<unite> intrus, vector<unite> singes, const vector< vector<bool> >& mat, int id, vector<int> morts) {
    int cpt = 0;
    for(int i=0 ; i<nbIntrus ; i++)
	if(morts[i] >= 0)
	    cpt++;
    if(cpt == 3 || id >= nbSinges) {
	miam rep;
	rep.nbMorts = cpt;
	rep.victimes = morts;
	rep.deps = 0;
	for(int i=0 ; i<nbIntrus ; i++) {
	    if(morts[i] < 0)
		continue;
	    if(dis(intrus[i].pos, singes[morts[i]].pos) == 4)
		rep.deps++;
	}
	return rep;
    }

    miam best; best.nbMorts = -1;
    miam tmp;
    //TODO: privilgier ceux qui requirent le moins de dps
    for(int i=0 ; i<nbIntrus ; i++) {
	if(morts[i] >= 0 || !mat[id][i])
	    continue;

	vector<int> newMorts = morts;

	newMorts[i] = id;

	tmp = bestCombin(nbSinges, nbIntrus, intrus, singes, mat, id+1, newMorts);
	if(tmp.nbMorts > best.nbMorts || (tmp.nbMorts == best.nbMorts && tmp.deps < best.deps))
	    best = tmp;
    }

    tmp = bestCombin(nbSinges, nbIntrus, intrus, singes, mat, id+1, morts);
    if(tmp.nbMorts == 3)
	return tmp;
    else if(tmp.nbMorts > best.nbMorts)
	best = tmp;

    return best;
}

bool Singeguard::win() {
    return false;
}
