#include "parksinges.hh"
#include "prologin.hh"
#include "analyse.hh"
#include "global.hh"
#include "debug.hh"

#include <iostream>

using namespace std;

extern vector< vector<bool> > carte;
//extern unite perr_adv;

extern vector< vector<portee_singe> > all_zone_singes;
//extern vector< vector<portee_singe> > enn_zone_singes;

Parksinges::Parksinges() : nbSinges(0) { }

string Parksinges::nom() {
    return "Parksinges";
}

void Parksinges::run() {
    int liBarriere;
    if(pos_renfort(false).y <= 10)
	liBarriere = pos_renfort(false).y + 2;
    else
	liBarriere = pos_renfort(false).y - 2;

    vector<unite> toons = unites();
    
    bool placeSinge = false, empTemp = false, blockedTemp = false;
    bool emp1 = false, emp2 = false, emp3 = false, emp4 = false;
    for(vector<unite>::iterator it = toons.begin() ; it != toons.end() ; ++it) {
	if((*it).pos == pos_renfort(false) && !(*it).ennemi) {
	    placeSinge = true;
	}
	else if((*it).pos.x == (pos_renfort(false).x)-1 && (*it).pos.y == liBarriere)
	    emp1 = true;
	else if((*it).pos.x == (pos_renfort(false).x) && (*it).pos.y == liBarriere)
	    emp2 = true;
	else if((*it).pos.x == (pos_renfort(false).x)+2 && (*it).pos.y == liBarriere)
	    emp3 = true;
	else if((*it).pos.x == (pos_renfort(false).x)-3 && (*it).pos.y == liBarriere)
	    emp4 = true;
	else if((*it).pos.x == (pos_renfort(false).x)-2 && (*it).pos.y == liBarriere) {
	    empTemp = true;
	    if((*it).ennemi)
		blockedTemp = true;
	}
    }

    if(placeSinge) {
	cout << "Acheminement du singe dans la barrire";
	position poste;
	poste.y = liBarriere;
	if(!emp1) {
	    cout << " en position 1";
	    poste.x = (pos_renfort(false).x)-1;
	}
	else if(!emp2) {
	    cout << " en position 2";
	    poste.x = (pos_renfort(false).x);
	}
	else if(!emp3) {
	    cout << " en position 3";
	    poste.x = (pos_renfort(false).x)+2;
	}
	else if(!empTemp) {
	    cout << " en position temporaire";
	    poste.x = (pos_renfort(false).x)-2;
	}

	cout << " " << poste << "." << endl;
	erreur err = deplacer(pos_renfort(false), poste);
	if(err != OK)
	    afficher_erreur(err);
    }
    else if(empTemp && !blockedTemp) {
	cout << "Acheminement du singe en position 4";

	position deb; deb.y = liBarriere; deb.x = pos_renfort(false).x-2;
	position poste; poste.y = liBarriere; poste.x = pos_renfort(false).x-3;

	erreur err = deplacer(deb, poste);
	if(err != OK)
	    afficher_erreur(err);
    }
    
    if(nbSinges < 4) {
	cout << "Invocation d'un nouveau singe" << endl;
	erreur err = renfort(SINGE);
	if(err == OK)
	    nbSinges++;
	else
	    afficher_erreur(err);
    }
    else {
	vector<unite> toons = unites();
	for(vector<unite>::iterator it = toons.begin() ; it != toons.end() ; ++it) {
	    if((*it).type_unite_actuel == SINGE && (*it).ko == 0 && !(*it).ennemi) {
		relever((*it).pos);
	    }
	}
    }
}

bool Parksinges::win() {
    return false;
}

