#include "debug.hh"
#include "prologin.hh"
#include "analyse.hh"

#include <iostream>
#include <vector>

using namespace std;

void dbg_lancement_module(Module* mod) {
    cout << "Lancement du module " << mod->nom() << endl;
}

void dbg_mkCarte(vector< vector<bool> > map) {
    if(DBG_CARTE)
	cout << map;
}

void dbg_mods(list<Module*> mods) {
    if(!DBG_MODS)
	return;

    cout << "Nombre de modules chargs : " << mods.size() << endl;

    for(list<Module*>::iterator it = mods.begin() ; it != mods.end() ; it++)
	cout << "- " << (*it)->nom() << endl;
}

ostream& operator<<(ostream& out, const vector< vector<portee_singe> > zone) {
    taille_terrain lim = taille_terrain_actuelle();
    for(int i=lim.min_coord ; i<=lim.max_coord ; i++) {
	for(int j=lim.min_coord ; j<=lim.max_coord ; j++)
	    switch(zone[j][i]) {
		case NO:
		    out << ". ";
		    break;
		case AVANCE:
		    out << "a ";
		    break;
		case DIRECT:
		    out << "O ";
		    break;
	    }
	out << endl;
    }

    return out;
}

ostream& operator<<(ostream& out, const unite& toon) {
    switch(toon.vrai_type_unite) {
	case PERROQUET:
	    out << "perroquet";
	    break;
	case SINGE:
	    out << "singe";
	    break;
	case CHAT:
	    out << "chat";
	    break;
	case KANGOUROU:
	    out << "kangourou";
	    break;
    }

    if(toon.ennemi)
	out << " ennemi ";
    else
	out << " alli ";

    out << "[" << toon.pos.x << "," << toon.pos.y << "]";

    return out;
}


ostream& operator<<(ostream& out, const vector< vector<bool> >& map) {
    taille_terrain lim = taille_terrain_actuelle();
    for(int i=lim.min_coord ; i<=lim.max_coord ; i++) {
	for(int j=lim.min_coord ; j<=lim.max_coord ; j++)
	    out << (map[j][i] ? "O " : ". ");
	out << endl;
    }

    return out;
}

ostream& operator<<(ostream& out, const position pos) {
    out << "(" << pos.x << "," << pos.y << ")";
    return out;
}
