#include <cstdlib>
#include <time.h>
#include <cmath>
#include <iostream>
#include <string>

#include "chavicieux.hh"
#include "prologin.hh"
#include "analyse.hh"
#include "global.hh"

using namespace std;

extern vector< vector<bool> > carte;
extern unite perr_adv;

//extern vector< vector<portee_singe> > all_zone_singes;
extern vector< vector<portee_singe> > enn_zone;

Chavicieux::Chavicieux(position apos, short sens) : pos(apos) {

    if(sens == 1 || sens == -1)
	sensX = sens;
    else {
	srand(time(NULL));
	int tirage = rand()%2;
	if(tirage == 0)
	    sensX = 1;
	else
	    sensX = -1;
    }

    if(pos_renfort(false).y < 10)
	sensY = 1;
    else
	sensY = -1;

    cout << "Cration d'un Chavicieux (sensX : " << sensX << " ; sensY : " << sensY << " ; " << pos.x << "," << pos.y << ")." << endl;
}

string Chavicieux::nom() {
    return "Chavicieux";
}

void Chavicieux::run() {
    if(win()) { // On a peut-tre gagn...
	int adjacentes[8][2] = {{-1,-1}, {-1,0}, {-1,1}, {0,-1}, {0,1}, {1,-1}, {1,0}, {1,1}};
	cout << "Tests...";
	for(int u=0 ; u<8 ; u++) {
	    position killpos = perr_adv.pos;
	    killpos.x += adjacentes[u][0];
	    killpos.y += adjacentes[u][1];

	    cout << " " << killpos.x << "," << killpos.y;
	    if(!carte[killpos.x][killpos.y] && dis(killpos, pos) <= 4) {
		cout << " OK !" << endl;
		
		erreur err = deplacer(pos, killpos);
		if(err != OK)
		    afficher_erreur(err);

		err = attaquer(killpos,perr_adv.pos);
		if(err != OK)
		    afficher_erreur(err);
		if(err == UNITE_KO)
		    relever(pos);
		return;
	    }
	}
	cout << endl;
    }

    position newPos = pos;
    int maxDep = caracteristiques(CHAT).pa_init;
    taille_terrain lim = taille_terrain_actuelle();

    // Calcul du dcalage horizontal
    int i, j;
    for(i=pos.x ; i<=lim.max_coord && i>=lim.min_coord ; i+=sensX) {
	for(j=pos.y ; j<=lim.max_coord && j>=lim.min_coord ; j+=sensY) {
	    if(enn_zone[i][j] != NO)
		break;
	}
	j -= sensY;
	if(j==lim.max_coord || j==lim.min_coord)
	    break;
    }
    int disCol = abs(i-pos.x), col = i;
    cout << "Couloir : " << col << endl;
    cout << "Distance au couloir : " << disCol << endl;

    // Calcul de la distance au perroquet
    int disPerr = abs(perr_adv.pos.y-pos.y);
    cout << "Distance au perroquet : " << disPerr << endl;

    int disParcourue = 0;
    if(disCol >= maxDep) {
	newPos.x = pos.x + (sensX*maxDep);
	disParcourue = maxDep;
    }
    else {
	newPos.x = col;
	newPos.y = pos.y + (sensY*min(maxDep-disCol, disPerr));
	disParcourue = dis(pos, newPos);
    }

    // On est  hauteur du perroquet, on voit si on peut s'en approcher sans crainte
    if(maxDep - disParcourue > 0) {
	position newNewPos = newPos;
	newNewPos.x -= sensX;
	while(enn_zone[newNewPos.x][newPos.y] == NO && dis(pos, newPos) <= maxDep) {
	    newPos.x -= sensX;
	    newNewPos.x -= sensX;
	}
    }

    if(dis(pos, newPos) == 0)
	return;

    erreur err = deplacer(pos, newPos);
    if(err == OK)
	pos = newPos;
    else if(err == UNITE_KO)
	err = relever(pos);
    if(err != OK)
	afficher_erreur(err);
}

bool Chavicieux::win() {
    int disPerr = dis(perr_adv.pos, pos);
    if(disPerr <= 5) {
	cout << "CHAVICIEUX WIN !" << endl;
	return true;
    }
    return false;
}
