///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_lua.rb
//

#ifndef INTERFACE_HH_
# define INTERFACE_HH_

extern "C" {
# include <lua.h>
# include <lualib.h>
# include <lauxlib.h>
}

class LuaInterface
{
public:
  LuaInterface();
  ~LuaInterface();
  
  void callLuaFunction(const char* name);
  
private:
  lua_State* l_;
};

///
// Renvoy par cout_achat_maison lorsque vous ne pouvez plus construire de maison pour le tour en cours.
//
# define INFINI                    30000

///
// Les coordonnes (x,y) avec lesquelles vous avez appel une fonction sont hors des bornes du terrain.
//
# define HORS_TERRAIN              -12

///
// Il n'y a pas de maison  la case indique.
//
# define PAS_DE_MAISON             -2

///
// Il n'y a pas de monument  la case indique.
//
# define PAS_DE_MONUMENT           -3

///
// Vous voulez dpenser plus d'argent que vous n'en n'avez.
//
# define FINANCES_DEPASSEES        -4

///
// Un blocage intervient lorsqu'aucune route n'est accessible depuis l'extrieur du jeu. Ce code d'erreur indique que le jeu serait bloqu si vous construisiez une maison ou un monument en (x,y) (ou si vous faisiez une rservation).
//
# define BLOCAGE                   -5

///
// Le numro de joueur donn est incorrect.
//
# define JOUEUR_INCORRECT          -7

///
// La case indique n'est pas adjacente  une route (pour la 4-connexit si vous voulez construire une route, et pour la 8-connexit si vous voulez construire un btiment).
//
# define NON_CONNEXE               -8

///
// La case indique est dj occupe.
//
# define CASE_OCCUPEE              -9

///
// Ce n'est pas votre tour, ou l'action demande est interdite.
//
# define ACTION_INTERDITE          -10

///
// La distance demande est strictement suprieure  MAX_DISTANCE.
//
# define TROP_LOIN                 50

///
// L'action s'est droule avec succs.
//
# define SUCCES                    0

///
// La case (ou le btiment) est possde par la mairie.
//
# define MAIRIE                    3

///
// Case de terrain vide.
//
# define VIDE                      0

///
// Case de terrain qui contient une maison.
//
# define MAISON                    1

///
// Case de terrain rserve.
//
# define RESERVATION               2

///
// Case de terrain qui contient un monument.
//
# define MONUMENT                  3

///
// Case de terrain qui contient une route.
//
# define ROUTE                     4

///
// Nombre de monuments qui seront mis aux enchres au cours de la partie.
//
# define MAX_MONUMENTS             14

///
// La taille de la carte, en hauteur et en largeur.
//
# define TAILLE_CARTE              100

///
// Distance maximale qui peut tre calcule.
//
# define MAX_DISTANCE              12

///
// La somme d'argent possde par les champions au dbut du jeu.
//
# define ARGENT_INITIAL            10


extern "C" {

///
// Renvoie le type de la case, VIDE, MAISON, ROUTE, MONUMENT ou RESERVATION.
//
extern int type_case(int x, int y);

///
// Renvoie la valeur de la case, c'est--dire la somme des prestiges des monuments qui ont cette case dans leur porte. Cette valeur peut tre ngative.
//
extern int valeur_case(int x, int y);

///
// Renvoie l'entit possdant la case, 0, 1 ou 2 si la case est une maison, et MAIRIE sinon.
//
extern int appartenance(int x, int y);

///
// Renvoie le numro d'un monument sur une case donne, ou PAS_DE_MONUMENT.
//
extern int type_monument(int x, int y);

///
// Renvoie la porte d'un monument.
//
extern int portee_monument(int num_monument);

///
// Renvoie le prestige d'un monument
//
extern int prestige_monument(int num_monument);

///
// Renvoie le numro du tour
//
extern int numero_tour();

///
// Numro du joueur qui commence lors de la phase 1. Si cette fonction est appele pendant une phase 2 ou 3, renvoie le numro du joueur qui commencera lors de la phase 1 du tour suivant.
//
extern int commence();

///
// Donne le montant de la dernire enchre effectue par un joueur. Renvoie 0 au premier tour.
//
extern int montant_encheres(int num_joueur);

///
// Donne le numro du joueur ayant gagn la dernire enchre. Renvoie 0 au premier tour.
//
extern int vainqueur_encheres();

///
// Donne le score d'un joueur.
//
extern int score(int num_joueur);

///
// Donne l'argent possd par un joueur
//
extern int finances(int num_joueur);

///
// Donne le numro du monument le plus rcemment mis aux enchres. Renvoie PAS_DE_MONUMENT lors de la phase 1 du premier tour.
//
extern int monument_en_cours();

///
// Renvoie la distance minimale pour aller de (x1,y1)  (x2,y2) (sachant qu'un dplacement en bas,  gauche, en haut ou  droite cote pour 1, et que les dplacements en diagonal ne sont pas autoriss). Lors du calcul de cette distance, seules les cases vides, les cases contenant une route, et les cases tant rserve par votre champion sont considres comme franchissables. Si le rsultat est suprieur strictement  MAX_DISTANCE, la fonction renvoie TROP_LOIN. Cette fonction ne fait aucun calcul, elle renvoie immdiatement.
//
extern int distance(int x1, int y1, int x2, int y2);

///
// Indique si vous pouvez construire une route en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE ou NON_CONNEXE.
//
extern int route_possible(int x, int y);

///
// Indique si vous pouvez construire une maison ou un monument en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE, BLOCAGE ou NON_CONNEXE.
//
extern int construction_possible(int x, int y);

///
// Renvoie le cot d'achat d'une maison (ou INFINI si vous ne pouvez plus en construire pour ce tour), en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
//
extern int cout_achat_maison();

///
// Renvoie le cot d'achat d'une route, en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
//
extern int cout_achat_route();

///
// Indique si votre champion doit jouer ou non. Si cette fonction renvoie false, votre champion ne pourra effectuer aucune action. Vous devriez toujours commencer vos fonctions jouer, enchere et placement par \texttt{if (mon_tour() == false) return;}.
//
extern bool mon_tour();

///
// Construit si possible une route en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE ou CASE_OCCUPEE.
//
extern int construire_route(int x, int y);

///
// Construit si possible une maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
//
extern int construire_maison(int x, int y);

///
// Rserve la case (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
//
extern int reserver_case(int x, int y);

///
// Dtruit la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES ou PAS_DE_MAISON.
//
extern int detruire_maison(int x, int y);

///
// Vend la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE ou PAS_DE_MAISON.
//
extern int vendre_maison(int x, int y);

///
// Place une enchre. Renvoie ACTION_INTERDITE ou FINANCES_DEPASSEES si impossible.
//
extern int encherir(int montant);

///
// Construit un monument en (x,y). Si impossible, renvoie ACTION_INTERDITE, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
//
extern int construire_monument(int x, int y);

///
// Fonction appelee au debut de la partie
//
void init_game();

///
// Fonction appelee a la fin de la partie
//
void end_game();

///
// Fonction appelee a chaque phase de jeu
//
void jouer();

///
// Fonction appelee a chaque phase d'enchere
//
void enchere();

///
// Fonction appelee a chaque phase de placement de monument
//
void placement();

}

#endif // !INTERFACE_HH_
