class Piksou extends Interface {
    private static final int NB_DEP = 4;
    private static final int[][] DEP = {{1, 0}, {0, 1}, {-1, 0}, {0, -1}};

    private static final int[][] ZONES = {
            {1, -1},
            {1, 0},
            {1, 1},
            {2, -1},
            {2, 0},
            {2, 1},
    };
    private static final boolean[] Z_INV = {true, true, false, false};
    private static final int[] Z_MUL = {1, -1, 1, -1};

    public boolean active;
    public int conf;
    public Case dep, pont, bat;
    public Case[] maisons;


    public Piksou() {
        this.active = false;
        this.conf = -1;
        this.dep = new Case(-1, -1, -1);
        this.pont = new Case(-1, -1, -1);
        this.bat = new Case(-1, -1, -1);
        this.maisons = new Case[4];
        this.fin = 0;
    }


    private int fin;
    public void ok() {
        this.fin++;
        if(this.fin == 2) {
            for(int a=0 ; a<4 ; a++) {
                vendre_maison(this.maisons[a].x, this.maisons[a].y);
                System.out.println("Operation Piksou - maison vendue : ("+this.maisons[a].x+", "+this.maisons[a].y+")");
            }

            this.active = false;
            this.conf = -1;
            this.dep = new Case(-1, -1, -1);
            this.pont = new Case(-1, -1, -1);
            this.bat = new Case(-1, -1, -1);
            this.maisons = new Case[4];
            this.fin = 0;
        }
    }


    public void vend() {
        for(int a=0 ; a<4 ; a++) {
            if(type_case(this.maisons[a].x, this.maisons[a].y) == MAISON)
                vendre_maison(this.maisons[a].x, this.maisons[a].y);
        }
    }


    public boolean zoneur() {
        System.out.println("Module Piksou - Zoneur");
        
        ArrayList<Case> routes = new ArrayList<Case>();
        boolean[][] visit = new boolean[TAILLE_CARTE][TAILLE_CARTE];
        for(int a=0 ; a<TAILLE_CARTE ; a++)
            for(int b=0 ; b<TAILLE_CARTE ; b++)
                visit[a][b] = false;
        checkRoutes(TAILLE_CARTE/2, TAILLE_CARTE/2, routes, visit);

        boolean brk = false, find = false;
        int size = routes.size();
        for(int r=0 ; r<size ; r++) {
            int dX = routes.get(r).x;
            int dY = routes.get(r).y;
            for(int z=0 ; z<4 ; z++) {
                brk = false;
                for(int a=0 ; a<6 ; a++) {
                    int x;
                    int y;
                    if(Z_INV[z]) {      // En colonnes
                        x = dX+ZONES[a][0]*Z_MUL[z];
                        y = dY+ZONES[a][1];
                    }
                    else {              // En lignes
                        x = dX+ZONES[a][1];
                        y = dY+ZONES[a][0]*Z_MUL[z];
                    }
                    int type = type_case(x, y);
                    // La case rend la config' mauvaise : on passe a z suivant
                    if(!(type == VIDE || (type == ROUTE && a==1)) || valeur_case(x, y) > 1) {
                        brk = true;
                        break;
                    }
                }
                // Aucune case n'a break : la config' est bonne
                if(!brk) {
                    find = true;
                    conf = z;
                    dep = routes.get(r);
                    if(Z_INV[z]) {      // En colonnes
                        pont = new Case(dX+ZONES[1][0]*Z_MUL[z], dY+ZONES[1][1], -1);
                        bat = new Case(dX+ZONES[4][0]*Z_MUL[z], dY+ZONES[4][1], -1);

                        maisons[0] = new Case(dX+ZONES[0][0]*Z_MUL[z], dY+ZONES[0][1], -1);
                        maisons[1] = new Case(dX+ZONES[2][0]*Z_MUL[z], dY+ZONES[2][1], -1);
                        maisons[2] = new Case(dX+ZONES[3][0]*Z_MUL[z], dY+ZONES[3][1], -1);
                        maisons[3] = new Case(dX+ZONES[5][0]*Z_MUL[z], dY+ZONES[5][1], -1);
                    }
                    else {              // En lignes
                        pont = new Case(dX+ZONES[1][1], dY+ZONES[1][0]*Z_MUL[z], -1);
                        bat = new Case(dX+ZONES[4][1], dY+ZONES[4][0]*Z_MUL[z], -1);

                        maisons[0] = new Case(dX+ZONES[0][1], dY+ZONES[0][0]*Z_MUL[z], -1);
                        maisons[1] = new Case(dX+ZONES[2][1], dY+ZONES[2][0]*Z_MUL[z], -1);
                        maisons[2] = new Case(dX+ZONES[3][1], dY+ZONES[3][0]*Z_MUL[z], -1);
                        maisons[3] = new Case(dX+ZONES[5][1], dY+ZONES[5][0]*Z_MUL[z], -1);
                    }
                    break;
                }
            }
            if(find)
                break;
        }

        if(!find) {
            System.out.println("Pas de configuration Piksienne");
            return false;
        }

        System.out.println("CONFIG TROUVEE - Passage en mode Piksou");
        this.active = true;
        return true;
    }

    private void checkRoutes(int x, int y, ArrayList<Case> routes, boolean[][] visit) {
        if(x < 0 || x > TAILLE_CARTE-1 || y < 0 || y > TAILLE_CARTE-1)
            return;
        if(visit[x][y])
            return;
        visit[x][y] = true;
        int type = type_case(x, y);
        if(type != ROUTE)
            return;

        routes.add(new Case(x, y, -1));

        for(int a=0 ; a<NB_DEP ; a++) {
            int newX = x+DEP[a][0];
            int newY = y+DEP[a][1];
            checkRoutes(newX, newY, routes, visit);
        }
    }
}
