unit prolo_interface;

interface

{
  This file has been generated, if you wish to
  modify it in a permanent way, please refer
  to the script file : gen/generator_pascal.rb
}

const
{
  Renvoy par cout_achat_maison lorsque vous ne pouvez plus construire de maison pour le tour en cours.
}
	INFINI                    =  30000;
{
  Les coordonnes (x,y) avec lesquelles vous avez appel une fonction sont hors des bornes du terrain.
}
	HORS_TERRAIN              =  -12;
{
  Il n'y a pas de maison  la case indique.
}
	PAS_DE_MAISON             =  -2;
{
  Il n'y a pas de monument  la case indique.
}
	PAS_DE_MONUMENT           =  -3;
{
  Vous voulez dpenser plus d'argent que vous n'en n'avez.
}
	FINANCES_DEPASSEES        =  -4;
{
  Un blocage intervient lorsqu'aucune route n'est accessible depuis l'extrieur du jeu. Ce code d'erreur indique que le jeu serait bloqu si vous construisiez une maison ou un monument en (x,y) (ou si vous faisiez une rservation).
}
	BLOCAGE                   =  -5;
{
  Le numro de joueur donn est incorrect.
}
	JOUEUR_INCORRECT          =  -7;
{
  La case indique n'est pas adjacente  une route (pour la 4-connexit si vous voulez construire une route, et pour la 8-connexit si vous voulez construire un btiment).
}
	NON_CONNEXE               =  -8;
{
  La case indique est dj occupe.
}
	CASE_OCCUPEE              =  -9;
{
  Ce n'est pas votre tour, ou l'action demande est interdite.
}
	ACTION_INTERDITE          =  -10;
{
  La distance demande est strictement suprieure  MAX_DISTANCE.
}
	TROP_LOIN                 =  50;
{
  L'action s'est droule avec succs.
}
	SUCCES                    =  0;
{
  La case (ou le btiment) est possde par la mairie.
}
	MAIRIE                    =  3;
{
  Case de terrain vide.
}
	VIDE                      =  0;
{
  Case de terrain qui contient une maison.
}
	MAISON                    =  1;
{
  Case de terrain rserve.
}
	RESERVATION               =  2;
{
  Case de terrain qui contient un monument.
}
	MONUMENT                  =  3;
{
  Case de terrain qui contient une route.
}
	ROUTE                     =  4;
{
  Nombre de monuments qui seront mis aux enchres au cours de la partie.
}
	MAX_MONUMENTS             =  14;
{
  La taille de la carte, en hauteur et en largeur.
}
	TAILLE_CARTE              =  100;
{
  Distance maximale qui peut tre calcule.
}
	MAX_DISTANCE              =  12;
{
  La somme d'argent possde par les champions au dbut du jeu.
}
	ARGENT_INITIAL            =  10;
{
  Renvoie le type de la case, VIDE, MAISON, ROUTE, MONUMENT ou RESERVATION.
}
function type_case(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Renvoie la valeur de la case, c'est--dire la somme des prestiges des monuments qui ont cette case dans leur porte. Cette valeur peut tre ngative.
}
function valeur_case(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Renvoie l'entit possdant la case, 0, 1 ou 2 si la case est une maison, et MAIRIE sinon.
}
function appartenance(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Renvoie le numro d'un monument sur une case donne, ou PAS_DE_MONUMENT.
}
function type_monument(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Renvoie la porte d'un monument.
}
function portee_monument(num_monument : LongInt) : LongInt; cdecl; external;

{
  Renvoie le prestige d'un monument
}
function prestige_monument(num_monument : LongInt) : LongInt; cdecl; external;

{
  Renvoie le numro du tour
}
function numero_tour() : LongInt; cdecl; external;

{
  Numro du joueur qui commence lors de la phase 1. Si cette fonction est appele pendant une phase 2 ou 3, renvoie le numro du joueur qui commencera lors de la phase 1 du tour suivant.
}
function commence() : LongInt; cdecl; external;

{
  Donne le montant de la dernire enchre effectue par un joueur. Renvoie 0 au premier tour.
}
function montant_encheres(num_joueur : LongInt) : LongInt; cdecl; external;

{
  Donne le numro du joueur ayant gagn la dernire enchre. Renvoie 0 au premier tour.
}
function vainqueur_encheres() : LongInt; cdecl; external;

{
  Donne le score d'un joueur.
}
function score(num_joueur : LongInt) : LongInt; cdecl; external;

{
  Donne l'argent possd par un joueur
}
function finances(num_joueur : LongInt) : LongInt; cdecl; external;

{
  Donne le numro du monument le plus rcemment mis aux enchres. Renvoie PAS_DE_MONUMENT lors de la phase 1 du premier tour.
}
function monument_en_cours() : LongInt; cdecl; external;

{
  Renvoie la distance minimale pour aller de (x1,y1)  (x2,y2) (sachant qu'un dplacement en bas,  gauche, en haut ou  droite cote pour 1, et que les dplacements en diagonal ne sont pas autoriss). Lors du calcul de cette distance, seules les cases vides, les cases contenant une route, et les cases tant rserve par votre champion sont considres comme franchissables. Si le rsultat est suprieur strictement  MAX_DISTANCE, la fonction renvoie TROP_LOIN. Cette fonction ne fait aucun calcul, elle renvoie immdiatement.
}
function distance(x1 : LongInt; y1 : LongInt; x2 : LongInt; y2 : LongInt) : LongInt; cdecl; external;

{
  Indique si vous pouvez construire une route en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE ou NON_CONNEXE.
}
function route_possible(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Indique si vous pouvez construire une maison ou un monument en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE, BLOCAGE ou NON_CONNEXE.
}
function construction_possible(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Renvoie le cot d'achat d'une maison (ou INFINI si vous ne pouvez plus en construire pour ce tour), en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
}
function cout_achat_maison() : LongInt; cdecl; external;

{
  Renvoie le cot d'achat d'une route, en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
}
function cout_achat_route() : LongInt; cdecl; external;

{
  Indique si votre champion doit jouer ou non. Si cette fonction renvoie false, votre champion ne pourra effectuer aucune action. Vous devriez toujours commencer vos fonctions jouer, enchere et placement par \texttt{if (mon_tour() == false) return;}.
}
function mon_tour() : LongBool; cdecl; external;

{
  Construit si possible une route en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE ou CASE_OCCUPEE.
}
function construire_route(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Construit si possible une maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
}
function construire_maison(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Rserve la case (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
}
function reserver_case(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Dtruit la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES ou PAS_DE_MAISON.
}
function detruire_maison(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Vend la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE ou PAS_DE_MAISON.
}
function vendre_maison(x : LongInt; y : LongInt) : LongInt; cdecl; external;

{
  Place une enchre. Renvoie ACTION_INTERDITE ou FINANCES_DEPASSEES si impossible.
}
function encherir(montant : LongInt) : LongInt; cdecl; external;

{
  Construit un monument en (x,y). Si impossible, renvoie ACTION_INTERDITE, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
}
function construire_monument(x : LongInt; y : LongInt) : LongInt; cdecl; external;

implementation

begin
end.
