/*!
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*/

/*!
** Renvoie le type de la case, VIDE, MAISON, ROUTE, MONUMENT ou RESERVATION.
*/
extern value type_case(value x, value y);

/*!
** Renvoie la valeur de la case, c'est--dire la somme des prestiges des monuments qui ont cette case dans leur porte. Cette valeur peut tre ngative.
*/
extern value valeur_case(value x, value y);

/*!
** Renvoie l'entit possdant la case, 0, 1 ou 2 si la case est une maison, et MAIRIE sinon.
*/
extern value appartenance(value x, value y);

/*!
** Renvoie le numro d'un monument sur une case donne, ou PAS_DE_MONUMENT.
*/
extern value type_monument(value x, value y);

/*!
** Renvoie la porte d'un monument.
*/
extern value portee_monument(value num_monument);

/*!
** Renvoie le prestige d'un monument
*/
extern value prestige_monument(value num_monument);

/*!
** Renvoie le numro du tour
*/
extern value numero_tour(void);

/*!
** Numro du joueur qui commence lors de la phase 1. Si cette fonction est appele pendant une phase 2 ou 3, renvoie le numro du joueur qui commencera lors de la phase 1 du tour suivant.
*/
extern value commence(void);

/*!
** Donne le montant de la dernire enchre effectue par un joueur. Renvoie 0 au premier tour.
*/
extern value montant_encheres(value num_joueur);

/*!
** Donne le numro du joueur ayant gagn la dernire enchre. Renvoie 0 au premier tour.
*/
extern value vainqueur_encheres(void);

/*!
** Donne le score d'un joueur.
*/
extern value score(value num_joueur);

/*!
** Donne l'argent possd par un joueur
*/
extern value finances(value num_joueur);

/*!
** Donne le numro du monument le plus rcemment mis aux enchres. Renvoie PAS_DE_MONUMENT lors de la phase 1 du premier tour.
*/
extern value monument_en_cours(void);

/*!
** Renvoie la distance minimale pour aller de (x1,y1)  (x2,y2) (sachant qu'un dplacement en bas,  gauche, en haut ou  droite cote pour 1, et que les dplacements en diagonal ne sont pas autoriss). Lors du calcul de cette distance, seules les cases vides, les cases contenant une route, et les cases tant rserve par votre champion sont considres comme franchissables. Si le rsultat est suprieur strictement  MAX_DISTANCE, la fonction renvoie TROP_LOIN. Cette fonction ne fait aucun calcul, elle renvoie immdiatement.
*/
extern value distance(value x1, value y1, value x2, value y2);

/*!
** Indique si vous pouvez construire une route en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE ou NON_CONNEXE.
*/
extern value route_possible(value x, value y);

/*!
** Indique si vous pouvez construire une maison ou un monument en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE, BLOCAGE ou NON_CONNEXE.
*/
extern value construction_possible(value x, value y);

/*!
** Renvoie le cot d'achat d'une maison (ou INFINI si vous ne pouvez plus en construire pour ce tour), en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
*/
extern value cout_achat_maison(void);

/*!
** Renvoie le cot d'achat d'une route, en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
*/
extern value cout_achat_route(void);

/*!
** Indique si votre champion doit jouer ou non. Si cette fonction renvoie false, votre champion ne pourra effectuer aucune action. Vous devriez toujours commencer vos fonctions jouer, enchere et placement par \texttt{if (mon_tour() == false) return;}.
*/
extern value mon_tour(void);

/*!
** Construit si possible une route en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE ou CASE_OCCUPEE.
*/
extern value construire_route(value x, value y);

/*!
** Construit si possible une maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
*/
extern value construire_maison(value x, value y);

/*!
** Rserve la case (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
*/
extern value reserver_case(value x, value y);

/*!
** Dtruit la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES ou PAS_DE_MAISON.
*/
extern value detruire_maison(value x, value y);

/*!
** Vend la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE ou PAS_DE_MAISON.
*/
extern value vendre_maison(value x, value y);

/*!
** Place une enchre. Renvoie ACTION_INTERDITE ou FINANCES_DEPASSEES si impossible.
*/
extern value encherir(value montant);

/*!
** Construit un monument en (x,y). Si impossible, renvoie ACTION_INTERDITE, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
*/
extern value construire_monument(value x, value y);

/*!
** Fonction appelee au debut de la partie
*/
void init_game(void);

/*!
** Fonction appelee a la fin de la partie
*/
void end_game(void);

/*!
** Fonction appelee a chaque phase de jeu
*/
void jouer(void);

/*!
** Fonction appelee a chaque phase d'enchere
*/
void enchere(void);

/*!
** Fonction appelee a chaque phase de placement de monument
*/
void placement(void);

