// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class Prologin extends Interface {

    private static final int NB_DEP = 8;
    private static final int[][] DEP = {{1, 0}, {0, 1}, {-1, 0}, {0, -1}, {1, 1}, {-1, -1}, {1, -1}, {-1, 1}};

    // Infos carte
    private static Case[] lib, adv, all;
    private static ArrayList<Case> tmpLib, tmpAdv, tmpAll;

    // Compteur de tours pour les maisons
    private static ArrayList<Case> toursAll;

    private static boolean firstHouse;

    // Ou placer le monument achete
    private static Case mon;


    // Fonction appelee au debut de la partie
    public void init_game() {
        firstHouse = true;
        toursAll = new ArrayList<Case>();
    }


    // Fonction appelee a la fin de la partie
    public void end_game() {
    }


    // Fonction appelee a chaque phase de jeu
    public void jouer() {
        checkMap();

        ArrayList<Case> meilR = new ArrayList<Case>();
        ArrayList<Case> meilM = new ArrayList<Case>();
        boolean prems = true;

        if(lib[0].val >= 2) {
            meilM.add(new Case(lib[0].x, lib[0].y, lib[0].val));
            prems = false;
        }

        for(int a=0 ; a<lib.length ; a++) {
            if(route_possible(lib[a].x, lib[a].y) != SUCCES)
                continue;
            for(int b=0 ; b<NB_DEP ; b++) {
                int x = lib[a].x+DEP[b][0];
                int y = lib[a].y+DEP[b][1];
                int val;
                if(type_case(x, y) == VIDE && (val=valeur_case(x, y)) >= 2) {
                    if(prems) {
                        meilR.add(new Case(lib[a].x, lib[a].y, lib[a].val));
                        meilM.add(new Case(x, y, val));
                        prems = false;
                    }
                    else if(val > meilM.get(0).val) {
                        meilR.clear();
                        meilM.clear();
                        meilR.add(new Case(lib[a].x, lib[a].y, lib[a].val));
                        meilM.add(new Case(x, y, val));
                    }
                    else if(val == meilM.get(0).val) {
                        meilR.add(new Case(lib[a].x, lib[a].y, lib[a].val));
                        meilM.add(new Case(x, y, val));
                    }
                }
            }
        }

        int mSize = meilM.size();
        if(mSize > 0)
            if(meilM.get(0).val >= 2) {
                if(meilR.size() > 0)
                    if(meilR.get(0).x != -1)
                        construire_route(meilR.get(0).x, meilR.get(0).y);
                int a=0;
                for(a=0 ; a<mSize ; a++)
                    if(construire_maison(meilM.get(a).x, meilM.get(a).y) == SUCCES)
                        break;
                System.out.println("x : "+meilM.get(a).x+" | y : "+meilM.get(a).y+" | val : "+meilM.get(a).val+" ");
                if(meilM.get(a).val >= 5) {
                    System.out.println("Maison vendue pour sa valeur : ("+meilM.get(a).x+", "+meilM.get(a).y+")");
                    vendre_maison(meilM.get(a).x, meilM.get(a).y);
                }
                else
                    toursAll.add(new Case(meilM.get(a).x, meilM.get(a).y, 0));
            }

        //Achat de la 2nde maison
        int cout = cout_achat_maison();
        if(cout == 0) {
            for(int a=0 ; a<lib.length ; a++)
                if(construire_maison(lib[a].x, lib[a].y) == SUCCES) {
                    toursAll.add(new Case(lib[a].x, lib[a].y, 0));
                    break;
                }
        }
        if(cout == 1 && finances(0) > ARGENT_INITIAL && firstHouse) {
            firstHouse = false;
            jouer();
        }
    }


    // Fonction appelee a chaque phase d'enchere
    public void enchere() { 
        firstHouse = true;
        
        majToursAll();
        checkMap();
        int monum = monument_en_cours();
        int val = prestige_monument(monum);
        int portee = portee_monument(monum);

        Case meil = new Case(0, 0, -1);

        for(int a=0 ; a<lib.length ; a++) {
            int temp = calcGain(lib[a].x, lib[a].y, val, portee);
            if(temp > meil.val)
                meil = new Case(lib[a].x, lib[a].y, temp);
        }
        mon = meil;

        if(mon.val < 1)
            return;
        if(finances(0) > mon.val-2)
            encherir(mon.val-2);
    }


    // Fonction appelee a chaque phase de placesment de monument
    public void placement() {
        construire_monument(mon.x, mon.y);
    }


    // Fais l'inventaire des cases du plateau
    public void checkMap() {
        boolean[][] visit = new boolean[TAILLE_CARTE][TAILLE_CARTE];
        for(int a=0 ; a<TAILLE_CARTE ; a++)
            for(int b=0 ; b<TAILLE_CARTE ; b++)
                visit[a][b] = false;

        tmpLib = new ArrayList<Case>();
        tmpAll = new ArrayList<Case>();
        tmpAdv = new ArrayList<Case>();

        checkMap(TAILLE_CARTE / 2, TAILLE_CARTE / 2, visit);

        lib = new Case[tmpLib.size()];
        all = new Case[tmpAll.size()];
        adv = new Case[tmpAdv.size()];

        for(int a=0 ; a<lib.length ; a++)
            lib[a] = tmpLib.get(a);
        for(int a=0 ; a<all.length ; a++)
            all[a] = tmpAll.get(a);
        for(int a=0 ; a<adv.length ; a++)
            adv[a] = tmpAdv.get(a);

        Arrays.sort(lib);
        Arrays.sort(all);
        Arrays.sort(adv);
    }
    public void checkMap(int x, int y, boolean[][] visit) {
        if(x < 0 || x > TAILLE_CARTE-1 || y < 0 || y > TAILLE_CARTE-1)
            return;

        if(visit[x][y])
            return;
        visit[x][y] = true;

        int type = type_case(x, y);
        if(type == VIDE) {
            tmpLib.add(new Case(x, y, valeur_case(x, y)));
            return;
        }
        else if(type == MAISON)
            if(appartenance(x, y) == 0) {
                tmpAll.add(new Case(x, y, valeur_case(x, y)));
                return;
            }
            else {
                tmpAdv.add(new Case(x, y, valeur_case(x, y)));
                return;
            }

        if(type != ROUTE)
            return;

        int newX, newY;
        for(int a=0 ; a<NB_DEP ; a++) {
            newX = x+DEP[a][0];
            newY = y+DEP[a][1];
            checkMap(newX, newY, visit);
        }
    }


    // Calcule les gains obtenus par un ;onu;ent a une position
    // Cette valeur est celle gagnee par les maisons alliees moins celle gagnee par les maisons adverses
    private int calcGain(int x, int y, int val, int portee) {
        int gauche = x-portee, haut = y-portee;
        int ret = 0;
        for(int a=gauche ; a<gauche+1+portee*2 ; a++)
            for(int b=haut ; b<haut+1+portee*2 ; b++)
                if(type_case(a, b) == MAISON) {
                    if(appartenance(a, b) == 0)
                        ret += val;
                    else
                        ret -= val;
                }
        return ret;
    }


    private void majToursAll() {
        int size = toursAll.size();
        for(int a=0 ; a<size ; a++) {
            toursAll.get(a).val++;
            if(toursAll.get(a).val >= 4) {
                System.out.println("Maison vendue apres 4 tours : ("+toursAll.get(a).x+", "+toursAll.get(a).y+")");
                vendre_maison(toursAll.get(a).x, toursAll.get(a).y);
                toursAll.remove(a--);
                size--;
            }
            else if(valeur_case(toursAll.get(a).x, toursAll.get(a).y) >= 5) {
                System.out.println("Maison vendue pour sa valeur : ("+toursAll.get(a).x+", "+toursAll.get(a).y+")");
                vendre_maison(toursAll.get(a).x, toursAll.get(a).y);
                toursAll.remove(a--);
                size--;
            }
        }
    }


    /*private void destroy() {
        if(adv[0].val >= 4) {
            if(finances(0) > adv[0].val+2) {
                System.out.println("Destruction de ("+adv[0].x+", "+adv[0].y+") valeur "+adv[0].val);
                detruire_maison(adv[0].x, adv[0].y);
                construire_maison(adv[0].x, adv[0].y);
                firstHouse = false;
            }
        }
    }*/


}
