(*
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*)

(*
** Renvoy par cout_achat_maison lorsque vous ne pouvez plus construire de maison pour le tour en cours.
*)
let _INFINI = 30000;;

(*
** Les coordonnes (x,y) avec lesquelles vous avez appel une fonction sont hors des bornes du terrain.
*)
let _HORS_TERRAIN = -12;;

(*
** Il n'y a pas de maison  la case indique.
*)
let _PAS_DE_MAISON = -2;;

(*
** Il n'y a pas de monument  la case indique.
*)
let _PAS_DE_MONUMENT = -3;;

(*
** Vous voulez dpenser plus d'argent que vous n'en n'avez.
*)
let _FINANCES_DEPASSEES = -4;;

(*
** Un blocage intervient lorsqu'aucune route n'est accessible depuis l'extrieur du jeu. Ce code d'erreur indique que le jeu serait bloqu si vous construisiez une maison ou un monument en (x,y) (ou si vous faisiez une rservation).
*)
let _BLOCAGE = -5;;

(*
** Le numro de joueur donn est incorrect.
*)
let _JOUEUR_INCORRECT = -7;;

(*
** La case indique n'est pas adjacente  une route (pour la 4-connexit si vous voulez construire une route, et pour la 8-connexit si vous voulez construire un btiment).
*)
let _NON_CONNEXE = -8;;

(*
** La case indique est dj occupe.
*)
let _CASE_OCCUPEE = -9;;

(*
** Ce n'est pas votre tour, ou l'action demande est interdite.
*)
let _ACTION_INTERDITE = -10;;

(*
** La distance demande est strictement suprieure  MAX_DISTANCE.
*)
let _TROP_LOIN = 50;;

(*
** L'action s'est droule avec succs.
*)
let _SUCCES = 0;;

(*
** La case (ou le btiment) est possde par la mairie.
*)
let _MAIRIE = 3;;

(*
** Case de terrain vide.
*)
let _VIDE = 0;;

(*
** Case de terrain qui contient une maison.
*)
let _MAISON = 1;;

(*
** Case de terrain rserve.
*)
let _RESERVATION = 2;;

(*
** Case de terrain qui contient un monument.
*)
let _MONUMENT = 3;;

(*
** Case de terrain qui contient une route.
*)
let _ROUTE = 4;;

(*
** Nombre de monuments qui seront mis aux enchres au cours de la partie.
*)
let _MAX_MONUMENTS = 14;;

(*
** La taille de la carte, en hauteur et en largeur.
*)
let _TAILLE_CARTE = 100;;

(*
** Distance maximale qui peut tre calcule.
*)
let _MAX_DISTANCE = 12;;

(*
** La somme d'argent possde par les champions au dbut du jeu.
*)
let _ARGENT_INITIAL = 10;;

(*
** Renvoie le type de la case, VIDE, MAISON, ROUTE, MONUMENT ou RESERVATION.
*)
external type_case : int -> int -> int = "ml_type_case";;

(*
** Renvoie la valeur de la case, c'est--dire la somme des prestiges des monuments qui ont cette case dans leur porte. Cette valeur peut tre ngative.
*)
external valeur_case : int -> int -> int = "ml_valeur_case";;

(*
** Renvoie l'entit possdant la case, 0, 1 ou 2 si la case est une maison, et MAIRIE sinon.
*)
external appartenance : int -> int -> int = "ml_appartenance";;

(*
** Renvoie le numro d'un monument sur une case donne, ou PAS_DE_MONUMENT.
*)
external type_monument : int -> int -> int = "ml_type_monument";;

(*
** Renvoie la porte d'un monument.
*)
external portee_monument : int -> int = "ml_portee_monument";;

(*
** Renvoie le prestige d'un monument
*)
external prestige_monument : int -> int = "ml_prestige_monument";;

(*
** Renvoie le numro du tour
*)
external numero_tour : unit -> int = "ml_numero_tour";;

(*
** Numro du joueur qui commence lors de la phase 1. Si cette fonction est appele pendant une phase 2 ou 3, renvoie le numro du joueur qui commencera lors de la phase 1 du tour suivant.
*)
external commence : unit -> int = "ml_commence";;

(*
** Donne le montant de la dernire enchre effectue par un joueur. Renvoie 0 au premier tour.
*)
external montant_encheres : int -> int = "ml_montant_encheres";;

(*
** Donne le numro du joueur ayant gagn la dernire enchre. Renvoie 0 au premier tour.
*)
external vainqueur_encheres : unit -> int = "ml_vainqueur_encheres";;

(*
** Donne le score d'un joueur.
*)
external score : int -> int = "ml_score";;

(*
** Donne l'argent possd par un joueur
*)
external finances : int -> int = "ml_finances";;

(*
** Donne le numro du monument le plus rcemment mis aux enchres. Renvoie PAS_DE_MONUMENT lors de la phase 1 du premier tour.
*)
external monument_en_cours : unit -> int = "ml_monument_en_cours";;

(*
** Renvoie la distance minimale pour aller de (x1,y1)  (x2,y2) (sachant qu'un dplacement en bas,  gauche, en haut ou  droite cote pour 1, et que les dplacements en diagonal ne sont pas autoriss). Lors du calcul de cette distance, seules les cases vides, les cases contenant une route, et les cases tant rserve par votre champion sont considres comme franchissables. Si le rsultat est suprieur strictement  MAX_DISTANCE, la fonction renvoie TROP_LOIN. Cette fonction ne fait aucun calcul, elle renvoie immdiatement.
*)
external distance : int -> int -> int -> int -> int = "ml_distance";;

(*
** Indique si vous pouvez construire une route en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE ou NON_CONNEXE.
*)
external route_possible : int -> int -> int = "ml_route_possible";;

(*
** Indique si vous pouvez construire une maison ou un monument en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE, BLOCAGE ou NON_CONNEXE.
*)
external construction_possible : int -> int -> int = "ml_construction_possible";;

(*
** Renvoie le cot d'achat d'une maison (ou INFINI si vous ne pouvez plus en construire pour ce tour), en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
*)
external cout_achat_maison : unit -> int = "ml_cout_achat_maison";;

(*
** Renvoie le cot d'achat d'une route, en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
*)
external cout_achat_route : unit -> int = "ml_cout_achat_route";;

(*
** Indique si votre champion doit jouer ou non. Si cette fonction renvoie false, votre champion ne pourra effectuer aucune action. Vous devriez toujours commencer vos fonctions jouer, enchere et placement par \texttt{if (mon_tour() == false) return;}.
*)
external mon_tour : unit -> bool = "ml_mon_tour";;

(*
** Construit si possible une route en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE ou CASE_OCCUPEE.
*)
external construire_route : int -> int -> int = "ml_construire_route";;

(*
** Construit si possible une maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
*)
external construire_maison : int -> int -> int = "ml_construire_maison";;

(*
** Rserve la case (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
*)
external reserver_case : int -> int -> int = "ml_reserver_case";;

(*
** Dtruit la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES ou PAS_DE_MAISON.
*)
external detruire_maison : int -> int -> int = "ml_detruire_maison";;

(*
** Vend la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE ou PAS_DE_MAISON.
*)
external vendre_maison : int -> int -> int = "ml_vendre_maison";;

(*
** Place une enchre. Renvoie ACTION_INTERDITE ou FINANCES_DEPASSEES si impossible.
*)
external encherir : int -> int = "ml_encherir";;

(*
** Construit un monument en (x,y). Si impossible, renvoie ACTION_INTERDITE, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
*)
external construire_monument : int -> int -> int = "ml_construire_monument";;

