///
// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb
//


// we want to use the CNI
#include <gcj/cni.h>
#include <java/lang/Throwable.h>
#include <java/lang/System.h>
#include <java/io/PrintStream.h>
#include <stdio.h>

#include "Prologin.h"
#include "Interface.h"

#include "interface.hh"

///
// Renvoie le type de la case, VIDE, MAISON, ROUTE, MONUMENT ou RESERVATION.
//
jint  Interface::type_case(jint x, jint y)
{
  return::type_case(x, y);
}


///
// Renvoie la valeur de la case, c'est--dire la somme des prestiges des monuments qui ont cette case dans leur porte. Cette valeur peut tre ngative.
//
jint  Interface::valeur_case(jint x, jint y)
{
  return::valeur_case(x, y);
}


///
// Renvoie l'entit possdant la case, 0, 1 ou 2 si la case est une maison, et MAIRIE sinon.
//
jint  Interface::appartenance(jint x, jint y)
{
  return::appartenance(x, y);
}


///
// Renvoie le numro d'un monument sur une case donne, ou PAS_DE_MONUMENT.
//
jint  Interface::type_monument(jint x, jint y)
{
  return::type_monument(x, y);
}


///
// Renvoie la porte d'un monument.
//
jint  Interface::portee_monument(jint num_monument)
{
  return::portee_monument(num_monument);
}


///
// Renvoie le prestige d'un monument
//
jint  Interface::prestige_monument(jint num_monument)
{
  return::prestige_monument(num_monument);
}


///
// Renvoie le numro du tour
//
jint  Interface::numero_tour()
{
  return::numero_tour();
}


///
// Numro du joueur qui commence lors de la phase 1. Si cette fonction est appele pendant une phase 2 ou 3, renvoie le numro du joueur qui commencera lors de la phase 1 du tour suivant.
//
jint  Interface::commence()
{
  return::commence();
}


///
// Donne le montant de la dernire enchre effectue par un joueur. Renvoie 0 au premier tour.
//
jint  Interface::montant_encheres(jint num_joueur)
{
  return::montant_encheres(num_joueur);
}


///
// Donne le numro du joueur ayant gagn la dernire enchre. Renvoie 0 au premier tour.
//
jint  Interface::vainqueur_encheres()
{
  return::vainqueur_encheres();
}


///
// Donne le score d'un joueur.
//
jint  Interface::score(jint num_joueur)
{
  return::score(num_joueur);
}


///
// Donne l'argent possd par un joueur
//
jint  Interface::finances(jint num_joueur)
{
  return::finances(num_joueur);
}


///
// Donne le numro du monument le plus rcemment mis aux enchres. Renvoie PAS_DE_MONUMENT lors de la phase 1 du premier tour.
//
jint  Interface::monument_en_cours()
{
  return::monument_en_cours();
}


///
// Renvoie la distance minimale pour aller de (x1,y1)  (x2,y2) (sachant qu'un dplacement en bas,  gauche, en haut ou  droite cote pour 1, et que les dplacements en diagonal ne sont pas autoriss). Lors du calcul de cette distance, seules les cases vides, les cases contenant une route, et les cases tant rserve par votre champion sont considres comme franchissables. Si le rsultat est suprieur strictement  MAX_DISTANCE, la fonction renvoie TROP_LOIN. Cette fonction ne fait aucun calcul, elle renvoie immdiatement.
//
jint  Interface::distance(jint x1, jint y1, jint x2, jint y2)
{
  return::distance(x1, y1, x2, y2);
}


///
// Indique si vous pouvez construire une route en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE ou NON_CONNEXE.
//
jint  Interface::route_possible(jint x, jint y)
{
  return::route_possible(x, y);
}


///
// Indique si vous pouvez construire une maison ou un monument en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE, BLOCAGE ou NON_CONNEXE.
//
jint  Interface::construction_possible(jint x, jint y)
{
  return::construction_possible(x, y);
}


///
// Renvoie le cot d'achat d'une maison (ou INFINI si vous ne pouvez plus en construire pour ce tour), en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
//
jint  Interface::cout_achat_maison()
{
  return::cout_achat_maison();
}


///
// Renvoie le cot d'achat d'une route, en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
//
jint  Interface::cout_achat_route()
{
  return::cout_achat_route();
}


///
// Indique si votre champion doit jouer ou non. Si cette fonction renvoie false, votre champion ne pourra effectuer aucune action. Vous devriez toujours commencer vos fonctions jouer, enchere et placement par \texttt{if (mon_tour() == false) return;}.
//
jboolean  Interface::mon_tour()
{
  return::mon_tour();
}


///
// Construit si possible une route en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE ou CASE_OCCUPEE.
//
jint  Interface::construire_route(jint x, jint y)
{
  return::construire_route(x, y);
}


///
// Construit si possible une maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
//
jint  Interface::construire_maison(jint x, jint y)
{
  return::construire_maison(x, y);
}


///
// Rserve la case (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
//
jint  Interface::reserver_case(jint x, jint y)
{
  return::reserver_case(x, y);
}


///
// Dtruit la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES ou PAS_DE_MAISON.
//
jint  Interface::detruire_maison(jint x, jint y)
{
  return::detruire_maison(x, y);
}


///
// Vend la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE ou PAS_DE_MAISON.
//
jint  Interface::vendre_maison(jint x, jint y)
{
  return::vendre_maison(x, y);
}


///
// Place une enchre. Renvoie ACTION_INTERDITE ou FINANCES_DEPASSEES si impossible.
//
jint  Interface::encherir(jint montant)
{
  return::encherir(montant);
}


///
// Construit un monument en (x,y). Si impossible, renvoie ACTION_INTERDITE, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
//
jint  Interface::construire_monument(jint x, jint y)
{
  return::construire_monument(x, y);
}


extern void GC_disable();

struct JavaVm
{
  JavaVm() : c(0)
  {
    using namespace java::lang;
    try
      {
	// create the virtual machine
	JvCreateJavaVM(NULL);
        // FIXME: grrrr
	// GC_disable();
	JvAttachCurrentThread(NULL, NULL);
	c = new Prologin();
      }
    catch (Throwable *t)
      {
	System::err->println(JvNewStringLatin1("Unhandled Java exception:"));
	t->printStackTrace();
      }
  }
  
  ~JavaVm()
  {
    // destroy the virual machine
    JvDetachCurrentThread();
  }

  Prologin* c;

} javaVm;


///
// Fonction appelee au debut de la partie
//
extern "C" void init_game()
{
  try {
    javaVm.c->init_game();
  } catch (java::lang::Throwable *t) {
    fprintf(stderr, "Unhandled Java exception:\n");
    t->printStackTrace();
  }
}

///
// Fonction appelee a la fin de la partie
//
extern "C" void end_game()
{
  try {
    javaVm.c->end_game();
  } catch (java::lang::Throwable *t) {
    fprintf(stderr, "Unhandled Java exception:\n");
    t->printStackTrace();
  }
}

///
// Fonction appelee a chaque phase de jeu
//
extern "C" void jouer()
{
  try {
    javaVm.c->jouer();
  } catch (java::lang::Throwable *t) {
    fprintf(stderr, "Unhandled Java exception:\n");
    t->printStackTrace();
  }
}

///
// Fonction appelee a chaque phase d'enchere
//
extern "C" void enchere()
{
  try {
    javaVm.c->enchere();
  } catch (java::lang::Throwable *t) {
    fprintf(stderr, "Unhandled Java exception:\n");
    t->printStackTrace();
  }
}

///
// Fonction appelee a chaque phase de placement de monument
//
extern "C" void placement()
{
  try {
    javaVm.c->placement();
  } catch (java::lang::Throwable *t) {
    fprintf(stderr, "Unhandled Java exception:\n");
    t->printStackTrace();
  }
}

