// This file has been generated, if you wish to
// modify it in a permanent way, please refer
// to the script file : gen/generator_java.rb

public class Interface
{
// Renvoy par cout_achat_maison lorsque vous ne pouvez plus construire de maison pour le tour en cours.
  public static final int INFINI = 30000;

// Les coordonnes (x,y) avec lesquelles vous avez appel une fonction sont hors des bornes du terrain.
  public static final int HORS_TERRAIN = -12;

// Il n'y a pas de maison  la case indique.
  public static final int PAS_DE_MAISON = -2;

// Il n'y a pas de monument  la case indique.
  public static final int PAS_DE_MONUMENT = -3;

// Vous voulez dpenser plus d'argent que vous n'en n'avez.
  public static final int FINANCES_DEPASSEES = -4;

// Un blocage intervient lorsqu'aucune route n'est accessible depuis l'extrieur du jeu. Ce code d'erreur indique que le jeu serait bloqu si vous construisiez une maison ou un monument en (x,y) (ou si vous faisiez une rservation).
  public static final int BLOCAGE = -5;

// Le numro de joueur donn est incorrect.
  public static final int JOUEUR_INCORRECT = -7;

// La case indique n'est pas adjacente  une route (pour la 4-connexit si vous voulez construire une route, et pour la 8-connexit si vous voulez construire un btiment).
  public static final int NON_CONNEXE = -8;

// La case indique est dj occupe.
  public static final int CASE_OCCUPEE = -9;

// Ce n'est pas votre tour, ou l'action demande est interdite.
  public static final int ACTION_INTERDITE = -10;

// La distance demande est strictement suprieure  MAX_DISTANCE.
  public static final int TROP_LOIN = 50;

// L'action s'est droule avec succs.
  public static final int SUCCES = 0;

// La case (ou le btiment) est possde par la mairie.
  public static final int MAIRIE = 3;

// Case de terrain vide.
  public static final int VIDE = 0;

// Case de terrain qui contient une maison.
  public static final int MAISON = 1;

// Case de terrain rserve.
  public static final int RESERVATION = 2;

// Case de terrain qui contient un monument.
  public static final int MONUMENT = 3;

// Case de terrain qui contient une route.
  public static final int ROUTE = 4;

// Nombre de monuments qui seront mis aux enchres au cours de la partie.
  public static final int MAX_MONUMENTS = 14;

// La taille de la carte, en hauteur et en largeur.
  public static final int TAILLE_CARTE = 100;

// Distance maximale qui peut tre calcule.
  public static final int MAX_DISTANCE = 12;

// La somme d'argent possde par les champions au dbut du jeu.
  public static final int ARGENT_INITIAL = 10;

// Renvoie le type de la case, VIDE, MAISON, ROUTE, MONUMENT ou RESERVATION.
  public static native int type_case(int x, int y);

// Renvoie la valeur de la case, c'est--dire la somme des prestiges des monuments qui ont cette case dans leur porte. Cette valeur peut tre ngative.
  public static native int valeur_case(int x, int y);

// Renvoie l'entit possdant la case, 0, 1 ou 2 si la case est une maison, et MAIRIE sinon.
  public static native int appartenance(int x, int y);

// Renvoie le numro d'un monument sur une case donne, ou PAS_DE_MONUMENT.
  public static native int type_monument(int x, int y);

// Renvoie la porte d'un monument.
  public static native int portee_monument(int num_monument);

// Renvoie le prestige d'un monument
  public static native int prestige_monument(int num_monument);

// Renvoie le numro du tour
  public static native int numero_tour();

// Numro du joueur qui commence lors de la phase 1. Si cette fonction est appele pendant une phase 2 ou 3, renvoie le numro du joueur qui commencera lors de la phase 1 du tour suivant.
  public static native int commence();

// Donne le montant de la dernire enchre effectue par un joueur. Renvoie 0 au premier tour.
  public static native int montant_encheres(int num_joueur);

// Donne le numro du joueur ayant gagn la dernire enchre. Renvoie 0 au premier tour.
  public static native int vainqueur_encheres();

// Donne le score d'un joueur.
  public static native int score(int num_joueur);

// Donne l'argent possd par un joueur
  public static native int finances(int num_joueur);

// Donne le numro du monument le plus rcemment mis aux enchres. Renvoie PAS_DE_MONUMENT lors de la phase 1 du premier tour.
  public static native int monument_en_cours();

// Renvoie la distance minimale pour aller de (x1,y1)  (x2,y2) (sachant qu'un dplacement en bas,  gauche, en haut ou  droite cote pour 1, et que les dplacements en diagonal ne sont pas autoriss). Lors du calcul de cette distance, seules les cases vides, les cases contenant une route, et les cases tant rserve par votre champion sont considres comme franchissables. Si le rsultat est suprieur strictement  MAX_DISTANCE, la fonction renvoie TROP_LOIN. Cette fonction ne fait aucun calcul, elle renvoie immdiatement.
  public static native int distance(int x1, int y1, int x2, int y2);

// Indique si vous pouvez construire une route en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE ou NON_CONNEXE.
  public static native int route_possible(int x, int y);

// Indique si vous pouvez construire une maison ou un monument en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE, BLOCAGE ou NON_CONNEXE.
  public static native int construction_possible(int x, int y);

// Renvoie le cot d'achat d'une maison (ou INFINI si vous ne pouvez plus en construire pour ce tour), en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
  public static native int cout_achat_maison();

// Renvoie le cot d'achat d'une route, en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
  public static native int cout_achat_route();

// Indique si votre champion doit jouer ou non. Si cette fonction renvoie false, votre champion ne pourra effectuer aucune action. Vous devriez toujours commencer vos fonctions jouer, enchere et placement par \texttt{if (mon_tour() == false) return;}.
  public static native boolean mon_tour();

// Construit si possible une route en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE ou CASE_OCCUPEE.
  public static native int construire_route(int x, int y);

// Construit si possible une maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
  public static native int construire_maison(int x, int y);

// Rserve la case (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
  public static native int reserver_case(int x, int y);

// Dtruit la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES ou PAS_DE_MAISON.
  public static native int detruire_maison(int x, int y);

// Vend la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE ou PAS_DE_MAISON.
  public static native int vendre_maison(int x, int y);

// Place une enchre. Renvoie ACTION_INTERDITE ou FINANCES_DEPASSEES si impossible.
  public static native int encherir(int montant);

// Construit un monument en (x,y). Si impossible, renvoie ACTION_INTERDITE, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
  public static native int construire_monument(int x, int y);

}
