class Liste<A> implements Cloneable {
    public A obj;
    private Liste<A> next, prev;
    private boolean hasNext, hasPrev;

    public Liste(A a) {
        this.obj = a;
        this.hasNext = false;
        this.hasPrev = false;
    }

    public Liste<A> next() {
        return this.next;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public void add(A a) {
        Liste<A> li = new Liste<A>(a);
        this.add(li);
    }
    public void add(Liste<A> li) {
        if(this.hasNext)
            this.next.add(li);
        else {
            this.next = li;
            li.prev = this;
            li.hasPrev = true;
            this.hasNext = true;
        }
    }

    public void remove() {
        if(this.hasPrev) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
        }
    }

    public Liste<A> first() {
        if(this.hasPrev)
            return this.prev.first();
        else return this;
    }

    public Liste<A> clone() {
        try {
            return (Liste<A>)(super.clone());
        }
        catch(CloneNotSupportedException e) {
            System.err.println("GNEEEEEEE ?");
            System.exit(42);
        }
        return this;
    }
}
