/*!
** This file has been generated, if you wish to
** modify it in a permanent way, please refer
** to the script file : gen/generator_caml.rb
*/

#include <caml/mlvalues.h>
#include <caml/callback.h>
#include <caml/alloc.h>
#include "interface.h"

/*!
** Renvoie le type de la case, VIDE, MAISON, ROUTE, MONUMENT ou RESERVATION.
*/
value ml_type_case(value x, value y)
{
return Val_int(type_case(Int_val(x), Int_val(y)));
}

/*!
** Renvoie la valeur de la case, c'est--dire la somme des prestiges des monuments qui ont cette case dans leur porte. Cette valeur peut tre ngative.
*/
value ml_valeur_case(value x, value y)
{
return Val_int(valeur_case(Int_val(x), Int_val(y)));
}

/*!
** Renvoie l'entit possdant la case, 0, 1 ou 2 si la case est une maison, et MAIRIE sinon.
*/
value ml_appartenance(value x, value y)
{
return Val_int(appartenance(Int_val(x), Int_val(y)));
}

/*!
** Renvoie le numro d'un monument sur une case donne, ou PAS_DE_MONUMENT.
*/
value ml_type_monument(value x, value y)
{
return Val_int(type_monument(Int_val(x), Int_val(y)));
}

/*!
** Renvoie la porte d'un monument.
*/
value ml_portee_monument(value num_monument)
{
return Val_int(portee_monument(Int_val(num_monument)));
}

/*!
** Renvoie le prestige d'un monument
*/
value ml_prestige_monument(value num_monument)
{
return Val_int(prestige_monument(Int_val(num_monument)));
}

/*!
** Renvoie le numro du tour
*/
value ml_numero_tour(void)
{
return Val_int(numero_tour());
}

/*!
** Numro du joueur qui commence lors de la phase 1. Si cette fonction est appele pendant une phase 2 ou 3, renvoie le numro du joueur qui commencera lors de la phase 1 du tour suivant.
*/
value ml_commence(void)
{
return Val_int(commence());
}

/*!
** Donne le montant de la dernire enchre effectue par un joueur. Renvoie 0 au premier tour.
*/
value ml_montant_encheres(value num_joueur)
{
return Val_int(montant_encheres(Int_val(num_joueur)));
}

/*!
** Donne le numro du joueur ayant gagn la dernire enchre. Renvoie 0 au premier tour.
*/
value ml_vainqueur_encheres(void)
{
return Val_int(vainqueur_encheres());
}

/*!
** Donne le score d'un joueur.
*/
value ml_score(value num_joueur)
{
return Val_int(score(Int_val(num_joueur)));
}

/*!
** Donne l'argent possd par un joueur
*/
value ml_finances(value num_joueur)
{
return Val_int(finances(Int_val(num_joueur)));
}

/*!
** Donne le numro du monument le plus rcemment mis aux enchres. Renvoie PAS_DE_MONUMENT lors de la phase 1 du premier tour.
*/
value ml_monument_en_cours(void)
{
return Val_int(monument_en_cours());
}

/*!
** Renvoie la distance minimale pour aller de (x1,y1)  (x2,y2) (sachant qu'un dplacement en bas,  gauche, en haut ou  droite cote pour 1, et que les dplacements en diagonal ne sont pas autoriss). Lors du calcul de cette distance, seules les cases vides, les cases contenant une route, et les cases tant rserve par votre champion sont considres comme franchissables. Si le rsultat est suprieur strictement  MAX_DISTANCE, la fonction renvoie TROP_LOIN. Cette fonction ne fait aucun calcul, elle renvoie immdiatement.
*/
value ml_distance(value x1, value y1, value x2, value y2)
{
return Val_int(distance(Int_val(x1), Int_val(y1), Int_val(x2), Int_val(y2)));
}

/*!
** Indique si vous pouvez construire une route en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE ou NON_CONNEXE.
*/
value ml_route_possible(value x, value y)
{
return Val_int(route_possible(Int_val(x), Int_val(y)));
}

/*!
** Indique si vous pouvez construire une maison ou un monument en (x,y). Si non, renvoie HORS_TERRAIN, CASE_OCCUPEE, BLOCAGE ou NON_CONNEXE.
*/
value ml_construction_possible(value x, value y)
{
return Val_int(construction_possible(Int_val(x), Int_val(y)));
}

/*!
** Renvoie le cot d'achat d'une maison (ou INFINI si vous ne pouvez plus en construire pour ce tour), en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
*/
value ml_cout_achat_maison(void)
{
return Val_int(cout_achat_maison());
}

/*!
** Renvoie le cot d'achat d'une route, en fonction de ce que vous avez dj construit (et dpens) lors de votre phase de jeu.
*/
value ml_cout_achat_route(void)
{
return Val_int(cout_achat_route());
}

/*!
** Indique si votre champion doit jouer ou non. Si cette fonction renvoie false, votre champion ne pourra effectuer aucune action. Vous devriez toujours commencer vos fonctions jouer, enchere et placement par \texttt{if (mon_tour() == false) return;}.
*/
value ml_mon_tour(void)
{
return Val_int(mon_tour());
}

/*!
** Construit si possible une route en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE ou CASE_OCCUPEE.
*/
value ml_construire_route(value x, value y)
{
return Val_int(construire_route(Int_val(x), Int_val(y)));
}

/*!
** Construit si possible une maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
*/
value ml_construire_maison(value x, value y)
{
return Val_int(construire_maison(Int_val(x), Int_val(y)));
}

/*!
** Rserve la case (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
*/
value ml_reserver_case(value x, value y)
{
return Val_int(reserver_case(Int_val(x), Int_val(y)));
}

/*!
** Dtruit la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE, FINANCES_DEPASSEES ou PAS_DE_MAISON.
*/
value ml_detruire_maison(value x, value y)
{
return Val_int(detruire_maison(Int_val(x), Int_val(y)));
}

/*!
** Vend la maison en (x,y). Si impossible, renvoie ACTION_INTERDITE ou PAS_DE_MAISON.
*/
value ml_vendre_maison(value x, value y)
{
return Val_int(vendre_maison(Int_val(x), Int_val(y)));
}

/*!
** Place une enchre. Renvoie ACTION_INTERDITE ou FINANCES_DEPASSEES si impossible.
*/
value ml_encherir(value montant)
{
return Val_int(encherir(Int_val(montant)));
}

/*!
** Construit un monument en (x,y). Si impossible, renvoie ACTION_INTERDITE, NON_CONNEXE, BLOCAGE ou CASE_OCCUPEE.
*/
value ml_construire_monument(value x, value y)
{
return Val_int(construire_monument(Int_val(x), Int_val(y)));
}

/*!
** Fonction appelee au debut de la partie
*/
void init_game(void)
{

  static value *fib_closure = NULL;

  if (fib_closure == NULL)
    fib_closure = caml_named_value("ml_init_game");
   callback(*fib_closure, Val_int(0));
}

/*!
** Fonction appelee a la fin de la partie
*/
void end_game(void)
{

  static value *fib_closure = NULL;

  if (fib_closure == NULL)
    fib_closure = caml_named_value("ml_end_game");
   callback(*fib_closure, Val_int(0));
}

/*!
** Fonction appelee a chaque phase de jeu
*/
void jouer(void)
{

  static value *fib_closure = NULL;

  if (fib_closure == NULL)
    fib_closure = caml_named_value("ml_jouer");
   callback(*fib_closure, Val_int(0));
}

/*!
** Fonction appelee a chaque phase d'enchere
*/
void enchere(void)
{

  static value *fib_closure = NULL;

  if (fib_closure == NULL)
    fib_closure = caml_named_value("ml_enchere");
   callback(*fib_closure, Val_int(0));
}

/*!
** Fonction appelee a chaque phase de placement de monument
*/
void placement(void)
{

  static value *fib_closure = NULL;

  if (fib_closure == NULL)
    fib_closure = caml_named_value("ml_placement");
   callback(*fib_closure, Val_int(0));
}

