#include "api.hh"
#include <iostream>
#include <stdio.h>
#include <vector>
#include <algorithm>
#include <map>
using namespace std;

#define Map vector<vector<etat_case>> 


struct EPosition{  // Utilise pour sort
    int colonne;
    int ligne;
    int niveau;
    position mama_pos;

    bool operator<(const EPosition& other){
        int diffx = (colonne - mama_pos.colonne), diffy = (ligne - mama_pos.ligne);
        int dist_sq = diffx * diffx + diffy * diffy;

        int other_diffx = (other.colonne - other.mama_pos.colonne), other_diffy = (other.ligne - other.mama_pos.ligne);
        int other_dist_sq = other_diffx * other_diffx + other_diffy * other_diffy;
        return dist_sq < other_dist_sq;
    }
};


#pragma region Constantes
const int CONQUETE_NIDS = 0;
const int RECHERCHE_PAIN = 1;
const int NEST_SEARCH_TURN_LIMIT = 16;
const int OPTIMAL_LENGTH = 16;
const int TUNNEL_MODE = 2;
const vector<pair<int, int>> DIR = {{1, 0}, {0, 1}, {-1, 0}, {0, -1}};
const vector<direction> DDIR = {EST, NORD, OUEST, SUD};
const int ITER_LIM = 3;
#pragma endregion

#pragma region Variables
int player_id, opponent_id;
vector<position> nids(0);
vector<position> nids_obtenus(0);
vector<position> trous(0);
int current_phase;
map<int, vector<direction>> paths;
map<int, position> aim2;
map<direction, pair<int, int>> MDIR;
vector<position> blacklist_cases(0); 
bool in_tunnel;
bool bread_next;
int anti_stuck = 0;
#pragma endregion


vector<position> sort_by_distance(vector<position>& pos, position& mama_pos){
    
    vector<EPosition> ep(pos.size());
    for(int i = 0; i < pos.size(); i++){
        ep.at(i) = {pos.at(i).colonne, pos.at(i).ligne, pos.at(i).niveau, mama_pos};
    }

    sort(ep.begin(), ep.end());

    vector<position> ret(pos.size());
    for(int i = 0; i < pos.size(); i++){
        ret.at(i) = {ep.at(i).colonne, ep.at(i).ligne, ep.at(i).niveau};
    }
    return ret;
}

// Fonction appelée au début de la partie.
void partie_init(void)
{
    player_id = moi();
    opponent_id = adversaire();
    current_phase = CONQUETE_NIDS;
    MDIR[NORD] = make_pair(0, 1);
    MDIR[SUD] = make_pair(0, -1);
    MDIR[EST] = make_pair(1, 0);
    MDIR[OUEST] = make_pair(-1, 0);
    bread_next = true;


    for(troupe tr : troupes_joueur(player_id)){
        paths[tr.id] = vector<direction>(0);
    }

    #pragma region Charge la carte
    for(int y = 0; y < HAUTEUR; y++){
        for(int x = 0; x < LARGEUR; x++){
            position pos = {y, x, 0};
            // ajoute au tableau si c'est un nid/trou
            if(info_case(pos).contenu == NID){
                nids.push_back(pos);
            }else if(info_case(pos).contenu == TROU){
                trous.push_back(pos);
            }
        }
    }
    #pragma endregion
}


// permet d'obtenir les directions orthogonaux a la direction actuelle
vector<pair<int, int>> cote(const direction& cur_dir){  
    vector<pair<int, int>> ret(0);
    for(pair<int, int> p : DIR){
        if(p.first * MDIR[cur_dir].first + p.second * MDIR[cur_dir].second == 0){  // Produit scalaire
            ret.push_back(p);
        }
    }
    return ret;
}


// juste pour afficher les pigeons
void debug_path(const troupe& tr, const vector<direction>& path){
    pair<int, int> pos = make_pair(tr.maman.colonne, tr.maman.ligne);
    for(direction dir : path){
        pos.first += MDIR[dir].first;
        pos.second += MDIR[dir].second;
        position tmp = {pos.first, pos.second, tr.maman.niveau};
        debug_poser_pigeon(tmp, PIGEON_ROUGE);
    }
}


// permet de mettre a jour les informations sur un/des troupes
troupe get_troupe_by_id(int id){
    for(troupe trp_ : troupes_joueur(player_id)){
        if(trp_.id == id) return trp_;
    }
}


// si un canard d'un troupe occupe une case donnee
bool is_in_troop(const position& target){
    vector<troupe> troupes = troupes_joueur(opponent_id);
    for(troupe t : troupes_joueur(player_id)){
        troupes.push_back(t);
    }
    
    for(troupe tr : troupes){
        for(position pos : tr.canards){
            if(pos == target) return true;
        }
    }

    return false;
}


// mets a jour les nids obtenus
void update_nests(){
    nids_obtenus.clear();
    for(position nest_pos : nids){
        etat_nid etat = info_nid(nest_pos);
        if(etat == player_id + 1){
            nids_obtenus.push_back(nest_pos);
        }
    }
}


// si l'ennemi donne en parametre satisfait les conditions pour etre tue
bool is_the_ennemy_killable(const troupe& adv_troupe){  // si les 2 cotes de l'adversaire sont non traversables
    vector<pair<int, int>> cotes_adv = cote(adv_troupe.dir);
    for(pair<int, int> p : cotes_adv){
        position tmp_pos = {adv_troupe.maman.colonne + p.first, adv_troupe.maman.ligne + p.second, adv_troupe.maman.niveau};
        debug_poser_pigeon(tmp_pos, PIGEON_ROUGE);
        etat_case etat = info_case(tmp_pos);
        type_case stat_tmp = etat.contenu;
        if(!(stat_tmp == BUISSON || (stat_tmp == BARRIERE && info_barriere(tmp_pos) == FERMEE))){
            return false;
        }
    }
    return true;
}


// si au moins 3 cotes d'un block sont des blocks non traversables
bool is_blocked(position pos){
    int counter = 0;
    for(pair<int, int> p : DIR){
        position ch = {pos.colonne + p.first, pos.ligne + p.second, 0};
        type_case ty = info_case(ch).contenu;
        if(ty == BUISSON || (ty == BARRIERE && info_barriere(ch) == FERMEE)){
            counter++;
        }
    }
    return counter > 2;
}


// retourne la distance au carre de l'ennemi le plus proche
int dist_sq_min(troupe tr){
    int mini = 999999;
    for(troupe enem : troupes_joueur(opponent_id)){
        int diffx = enem.maman.colonne - tr.maman.colonne, diffy = enem.maman.ligne - tr.maman.ligne;
        if(mini > diffx * diffx + diffy * diffy){
            mini = diffx * diffx + diffy * diffy;
        }
    }
    return mini;
}


// permet de deplacer a la case la plus proche parmi les cases donnees en parametre
int go2target(const troupe& tr, const vector<position>& target_list, int pts=PTS_ACTION, bool nid=false){  // Renvoie les pts restants
    debug_poser_pigeon(tr.maman, PIGEON_JAUNE);
    troupe cur_tr = get_troupe_by_id(tr.id);
    int action_pt = pts;
    
    for(position target_pos : target_list){
        int used = 0;

        if(is_in_troop(target_pos)){
            continue;
        }
        if(is_blocked(target_pos) && !nid){
            continue;
        }
        
        // Verifie si la case est deja visee par un autre troupe de ce joueur.
        if(!nid){
            bool nxt = false;
            for (auto it = aim2.begin(); it != aim2.end(); ++it) {
                if(it -> first != tr.id && it -> second == target_pos){
                    nxt = true;
                    break;
                }
            } 
            if(nxt) continue;
        }


        vector<direction> path = trouver_chemin(cur_tr.maman, target_pos);
        debug_path(cur_tr, path);

        position prev_mama_pos = cur_tr.maman;
        erreur can_continue = OK;
        
        if(path.size() > 0){ 
            aim2[tr.id] = target_pos;  // pour que 2 troupes differents ne visent pas la meme case
        }
        while(can_continue == OK && path.size() > 0){  // avance
            can_continue = avancer(cur_tr.id, path.at(0));
            path.erase(path.begin());
            action_pt--;
            used++;
        }
        cur_tr = get_troupe_by_id(cur_tr.id);

        if(action_pt < 1) break;  // s'il ne peut plus deplacer
    }
    return action_pt;
}


void jouer_tour(void)
{
    
    aim2.clear();
    // essaye de tuer les advesaires
    int score_rest = score(player_id);
    for(troupe adv_tr : troupes_joueur(opponent_id)){
        if(score_rest < COUT_BUISSON){
            bool killable = is_the_ennemy_killable(adv_tr);
  
            if(killable && adv_tr.taille > 11 && adv_tr.inventaire > 2){  // Place un buisson juste devant l'ennemi
                position buisson_pos = {adv_tr.maman.colonne + MDIR[adv_tr.dir].first,
                                        adv_tr.maman.ligne + MDIR[adv_tr.dir].second,
                                        0};
                debug_poser_pigeon(buisson_pos, PIGEON_BLEU);
                erreur err = construire_buisson(buisson_pos);
                if(err == OK) score_rest -= COUT_BUISSON;

            }   
        }
        else{
            break;
        }
    }


    for(troupe tr : troupes_joueur(player_id)){

        for(int i = 0; i < tr.inventaire; i++){
            position dbg = {i, tr.id, 0};
            debug_poser_pigeon(dbg, tr.id == 1 ? PIGEON_ROUGE : PIGEON_BLEU);
        }

        int action_pts = PTS_ACTION;
        for(int i = 0; i < ITER_LIM; i++){  // Pour epuiser tous les points d'action
            if(action_pts < 1) break;

            if(current_phase == CONQUETE_NIDS){  // Phase 1: conquete des nids
                vector<position> available_nest(0);
                // mise a jour des nids libres
                for(position nest_pos : nids){
                    etat_nid etat = info_nid(nest_pos);
                    if(etat == LIBRE){
                        available_nest.push_back(nest_pos);
                    }
                } 

                update_nests();
                if((available_nest.size() > 0 && tour_actuel() < NEST_SEARCH_TURN_LIMIT) || nids_obtenus.size() < 1){
                    action_pts = go2target(tr, sort_by_distance(available_nest, tr.maman), action_pts, i < ITER_LIM - 1);
                }else{  // si il n'y a plus de nids a explorer ou trop de temps passe dessus
                    current_phase = RECHERCHE_PAIN;
                }

            }
            if(current_phase == RECHERCHE_PAIN){  // Phase 2: collecte les pains

                if(tr.inventaire == inventaire(tr.taille)){  // si y a plus d'espace, rentre au nid le plus proche
                    update_nests();
                    action_pts = go2target(tr, sort_by_distance(nids_obtenus, tr.maman), action_pts);
                }

                if(dist_sq_min(tr) > 15){  // grandit si la distance entre l'ennemi est suffisament importante
                    if(action_pts > COUT_CROISSANCE - 1){
                        grandir(tr.id);
                        action_pts -= COUT_CROISSANCE;
                    }
                }
                
                vector<position> br = pains();  // aller chercher du pain
                action_pts = go2target(tr, sort_by_distance(br, tr.maman), action_pts, !(i < ITER_LIM - 1));
            }

            if(action_pts > COUT_CROISSANCE - 1){  // grandit s'il y a assez de points
                action_pts -= COUT_CROISSANCE;
                grandir(tr.id);
            }
            tr = get_troupe_by_id(tr.id);  // mise a jour
        }

        // s'il n'arrive pas a epuiser les points, avance n'importe comment
        if(action_pts > 0){
            for(int i = 0; i < action_pts; i++){
                avancer(tr.id, DDIR.at(anti_stuck % 4));
            }
            anti_stuck++;
        }
    }
}

// Fonction appelée à la fin de la partie.
void partie_fin(void)
{
    // TODO
    //
    
}