#include "api.hh"
#include <iostream>
#include <stdio.h>
#include <vector>
#include <algorithm>
#include <map>
#include <queue>
using namespace std;

#define Map vector<vector<etat_case>> 


struct EPosition{  // Enhanced position
    int colonne;
    int ligne;
    int niveau;
    position mama_pos;

    bool operator<(const EPosition& other){
        int diffx = (colonne - mama_pos.colonne), diffy = (ligne - mama_pos.ligne);
        int dist_sq = diffx * diffx + diffy * diffy;

        int other_diffx = (other.colonne - other.mama_pos.colonne), other_diffy = (other.ligne - other.mama_pos.ligne);
        int other_dist_sq = other_diffx * other_diffx + other_diffy * other_diffy;
        return dist_sq < other_dist_sq;
    }
};

struct as_path{
    vector<position> cur;
    int cost;

    bool operator<(as_path& other){
        return cost < other.cost;
    }
};






#pragma region Constantes
const int CONQUETE_NIDS = 0;
const int RECHERCHE_PAIN = 1;
const vector<pair<int, int>> DIR = {{1, 0}, {0, 1}, {-1, 0}, {0, -1}};
#pragma endregion

#pragma region Variables
int player_id;
// Map map(HAUTEUR, vector<etat_case>(LARGEUR));  // do we really need this?
vector<position> nids(0);
vector<position> nids_obtenus(0);
int current_phase;
map<int, vector<direction>> paths;
#pragma endregion



int calc_cost(position target, vector<position>& path){
    int diffx = path.at(path.size() - 1).colonne - target.colonne;
    int diffy = path.at(path.size() - 1).ligne - target.ligne;
    int distance_cost = diffx * diffx + diffy * diffy;
    return distance_cost + target.size();
}



vector<position> find_path2(position cur, position target, int iter_lim=20){
    auto stat = info_case(target);
    if(stat == BUISSON || (stat == BARRIERE && info_barriere(target) == FERMEE)){
        return {};
    }

    int count_it = 0;
    bool found = false;
    auto cmp = [](as_path left, as_path right) { return (left.cost) < (right.cost);};
    priority_queue<as_path, std::vector<as_path>, decltype(cmp)> block_path(cmp);
    vector<position> init(1, cur);
    block_path.push({init, calc_cost(target, init)});
    while (count_it < iter_lim && !found){
        as_path best = block_path.top();
        block_path.pop();

        for(pair<int, int> p : DIR){
            position tmp_pos = best.cur.at(best.cur.size() - 1);
            tmp_pos = {tmp_pos.colonne + p.first, tmp_pos.ligne + p.second, tmp_pos.niveau};
            type_case stat = info_case(tmp_pos).contenu;
            if(stat == BUISSON || (stat == BARRIERE && info_barriere(target) == FERMEE)){
                continue;
            }

            vector<position> new_path = best.cur;
            new_path.push_back(tmp_pos);
            if(tmp_pos.colonne == target.colonne && tmp_pos.ligne == target.ligne){
                return new_path;
            }
            block_path.push({new_path, calc_cost(target, new_path)});
        }
        count_it++;
    }

    return block_path.top().cur;

}



vector<position> sort_by_distance(vector<position>& pos, position& mama_pos){
    
    vector<EPosition> ep(pos.size());
    for(int i = 0; i < pos.size(); i++){
        ep.at(i) = {pos.at(i).colonne, pos.at(i).ligne, pos.at(i).niveau, mama_pos};
    }

    sort(ep.begin(), ep.end());

    vector<position> ret(pos.size());
    for(int i = 0; i < pos.size(); i++){
        ret.at(i) = {ep.at(i).colonne, ep.at(i).ligne, ep.at(i).niveau};
    }
    return ret;
}


bool can_exit_1st_phase(){
    // 1. Tous les nids sont occupes
    bool occupied = true;
    for(position nid_p : nids){
        etat_nid etat = info_nid(nid_p);
        occupied = occupied & !(etat == JOUEUR_0 || etat == JOUEUR_1);
    }
    if(occupied){
        return true;
    }

    
    // 2. Atteint la 20eme tour
    if(tour_actuel() > 20){
        return true;
    }


    return false;
}



// Fonction appelée au début de la partie.
void partie_init(void)
{
    player_id = moi();
    current_phase = CONQUETE_NIDS;

    for(troupe tr : troupes_joueur(player_id)){
        paths[tr.id] = vector<direction>(0);
    }

    #pragma region Charge la carte
    for(int y = 0; y < HAUTEUR; y++){
        for(int x = 0; x < LARGEUR; x++){
            position pos = {y, x, 0};
            // map.at(y).at(x) = info_case(pos);
            // ajoute au tableau si c'est un nid
            if(info_case(pos).contenu == NID){
                nids.push_back(pos);
            }
        }
    }
    #pragma endregion
}


// Fonction appelée à chaque tour.
void jouer_tour(void)
{
  debug_poser_pigeon({0, 0, 0}, PIGEON_ROUGE);
  debug_poser_pigeon({39, 39, 0}, PIGEON_BLEU);
  debug_poser_pigeon({0, 39, 0}, PIGEON_JAUNE);
}

// Fonction appelée à la fin de la partie.
void partie_fin(void)
{
    // TODO
    
    
}


