from outils import duree
from api import *
from parc import NiveauPrincipal
from troupes import Troupe
from outils import duree

# NOTE: troupes_joueur renvoie une copie (et non une vue) vers les troupes

def partie_init():
    """ Fonction appelée au début de la partie. """
    global niveau_principal
    niveau_principal = NiveauPrincipal()

# @duree
def jouer_tour():
    """ Fonction appelée à chaque tour. """
    for troupe in niveau_principal.mes_troupes:
        niveau_principal.nids_innaccessibles.clear()

        while troupe.pts_action > 0:
            nids = niveau_principal.nids_accessibles(troupe)
            if len(nids) > 0:
                troupe.avancer_nids(niveau_principal, nids)

            while (troupe.pts_action >= COUT_CROISSANCE) and \
                (troupe.taille >= TAILLE_MIN and troupe.taille != niveau_principal.taille_ideale):
                grandir(troupe.id)

            pains_ = niveau_principal.pains_accessibles(troupe)
            if len(pains_) > 0 and troupe.pts_action > 0 and \
                troupe.inventaire < troupe.taille // 3:
                troupe.avancer_pains(niveau_principal, pains_)
        
            nids = niveau_principal.mes_nids - niveau_principal.nids_innaccessibles
            if len(nids) > 0 and troupe.pts_action > 0:
                troupe.avancer_nids(niveau_principal, nids)
            else:
                avancer(troupe.id, troupe.dir)

            

def partie_fin():
    """ Fonction appelée à la fin de la partie. """
    pass
