from api import *
from math import inf
from outils import troupe_avec_id, distance, duree, prochaine_case
from functools import partial 


class Innaccessible(Exception):
    pass

class PointsActionsInsuffisants(Exception):
    pass


class Troupe:

    def __init__(self, id_troupe: int):
        self.id = id_troupe
        self.prochain_nid = None
        self.prochain_pain = None

    def avancer_max(self, pos: tuple[int, int, int]):
        """ On avance vers pos tant qu'il nous reste des points d'actions """
        chemin = trouver_chemin(self.troupe.maman, pos)
        if len(chemin) == 0:
            raise Innaccessible # Il n'y a pas de chemin de la maman vers pos
        
        # Affiche les pigeons debug sur le trajet
        # x, y, _ = self.troupe.maman
        # for dir in chemin[::2]:
        #     debug_poser_pigeon((x, y, 0), pigeon_debug.PIGEON_BLEU)
        #     x, y = prochaine_case(x, y, dir)

        for direction in chemin:
            if self.pts_action <= 0:
                # Il n'y a pas assez de points d'action pour aller vers pos
                raise PointsActionsInsuffisants
            avancer(self.id, direction)

    # @duree
    def avancer_nids(self, niveau_principal, nids):
        """ Avance autant que possible vers le nid le plus proche"""
        plus_proche_nid = min(nids, key=partial(distance, (self.x, self.y)))
        self.prochain_nid = None
        try: 
            self.avancer_max((*plus_proche_nid, 0))
            # A ce stade il n'y a pas d'exception levée donc on a atteint le nid
            niveau_principal.mes_nids.add(plus_proche_nid)
        except Innaccessible:
            niveau_principal.nids_innaccessibles.add(plus_proche_nid)
        except PointsActionsInsuffisants:
            self.prochain_nid = plus_proche_nid

    # @duree
    def avancer_pains(self, niveau_principal, pains):
        """ Avance auatant que possible vers le pain le plus proche """
        plus_proche_pain = min(pains, key=partial(distance, (self.x, self.y)))
        self.prochain_pain = None
        try:
            self.avancer_max((*plus_proche_pain, 0))
        except Innaccessible:
            niveau_principal.pains_innaccessibles.add(plus_proche_pain)
        except PointsActionsInsuffisants:
            self.prochain_pain = plus_proche_pain

    def trou_accessible(self):
        """ Renvoie la position d'un trou accessible depuis la maman """
        for x in range(LARGEUR):
            for y in range(HAUTEUR):
                if info_case((x, y, -1)).contenu == type_case.TROU and \
                    len(trouver_chemin((self.x, self.y, 0), (x, y, 0))) > 0:
                    return x, y
    
    def trou_innaccessible(self):
        """ Renvoie la position d'un trou innaccessible depuis la maman """
        for x in range(LARGEUR):
            for y in range(HAUTEUR):
                if info_case((x, y, -1)).contenu == type_case.TROU and \
                    len(trouver_chemin((self.x, self.y, 0), (x, y, 0))) == 0:
                    return x, y

    def prendre_trou(self, trou):
        try:
            self.avancer_max((*trou, 0))
        except PointsActionsInsuffisants:
            pass
    
    def papy_le_plus_proche(self):
        """ Renvoie la position du papy le plus proche depuis la maman """
        min_dist = inf
        min_papy = None
        for x in range(LARGEUR):
            for y in range(HAUTEUR):
                d = distance((self.x, self.y), (x,y))
                if info_case((x, y, 0)).contenu == type_case.PAPY and d <= min_dist:
                    min_dist = d
                    min_papy = (x, y)
        return min_papy

    @property
    def troupe(self):
        """ Descripteur permettant de récupérer le namedtuple de la 
        troupe id du champion depuis l'api, cela assure d'avoir de récupérer 
        des attributs actualisés à chaque tour """
        return troupe_avec_id(moi(), self.id)

    def __getattr__(self, name):
        return getattr(self.troupe, name)

    @property
    def x(self):
        """ Colonne de la maman """
        return self.troupe.maman[0]

    @property
    def y(self):
        """ Ligne de la maman """
        return self.troupe.maman[1]

    def __repr__(self):
        return repr(self.troupe)
