# Ensemble de fonctions utilitaires susceptibles d'etre utilisées 
# par plusieurs modules

from api import *
import time
from functools import wraps
from math import sqrt, inf


def duree(f):
    """ Décorateur pour afficher le temps d'execution d'une fonction """
    @wraps(f)
    def inner(*args, **kwargs):
        debut = time.time()
        f(*args, **kwargs)
        fin = time.time()
        print(f"La fonction {f.__name__} a mis {fin-debut:.3f} s")
    return inner


def distance(pos1, pos2):
    """ Renvoie la longueur d'un chemin ou +inf sinon """
    chemin = trouver_chemin((*pos1, 0), (*pos2, 0))
    if len(chemin) == 0:
        return inf
    return len(chemin)


def troupe_avec_id(joueur_id: int, id: int):
    """ Renvoie la troupe de l'api à partir de son id """
    for troupe in troupes_joueur(joueur_id):
        if troupe.id == id:
            return troupe


def prochaine_case(x, y, dir):
    """ Renvoie la case adjacente à (x,y) selon une direction dir """
    if dir == direction.NORD:
        return x, y+1
    if dir == direction.SUD:
        return x, y-1
    if dir == direction.EST:
        return x+1, y
    if dir == direction.OUEST:
        return x-1, y