# Stratégie globale: 
#  - Récupérer un maximum de nids libres (un par troupe)
#  - Grossis jusqu'a une taille idéale dépendante de la densité
#  - Récupérer les pains jusqu'au tier de la taille
#  - Deposer les pains sur les nids

from outils import duree
from api import *
from parc import NiveauPrincipal, NiveauSouterrain
from troupes import Troupe, Innaccessible, PointsActionsInsuffisants
from outils import duree

# NOTE: troupes_joueur renvoie une copie (et non une vue) vers les troupes

def partie_init():
    """ Fonction appelée au début de la partie. """
    global niveau_principal, niveau_souterrain
    niveau_principal = NiveauPrincipal()
    niveau_souterrain = NiveauSouterrain()

# @duree
def jouer_tour():
    """ Fonction appelée à chaque tour. """
    for troupe in niveau_principal.mes_troupes:
        # trou_acc = troupe.trou_accessible()
        # trou_innacc = troupe.trou_innaccessible()
        # if trou_acc and trou_innacc:
        #     niveau_souterrain.creuser_relier(trou_acc, trou_innacc)
        niveau_principal.nids_innaccessibles.clear()
        # Enesemble des nids accessibles depuis l'emplacemetn de la maman
        nids_accessibles = niveau_principal.nids_accessibles(troupe)
        # if len(nids_accessibles) == 0 and trou_acc:
        #     troupe.prendre_trou(trou_acc)

        nids_libres = nids_accessibles - niveau_principal.mes_nids
        if len(nids_libres) > 0:
            # On avance vers le nid le plus proche dans nids_libres
            troupe.avancer_nids(niveau_principal, nids_libres)

        while troupe.pts_action >= COUT_CROISSANCE and \
            (troupe.taille >= TAILLE_MIN and troupe.taille != niveau_principal.taille_ideale):
            # On augmente la troupe si le nombre de pts d'action et suffisant et que sa taille 
            # ne dépasse pas la taille idéale calculée en focntion de la densité de la map
            grandir(troupe.id)

        pains_ = niveau_principal.pains_accessibles(troupe)
        if len(pains_) > 0 and troupe.pts_action > 0 and \
            troupe.inventaire < troupe.taille // 3:
            # On avance vers le pain le plus proche dans pains_
            troupe.avancer_pains(niveau_principal, pains_)
    
        nids = niveau_principal.mes_nids - niveau_principal.nids_innaccessibles
        if len(nids) > 0 and troupe.pts_action > 0:
            # On ramène les pains vers les nids possédés et accessibles
            troupe.avancer_nids(niveau_principal, nids)

        # on dépense les points d'action restants utilement
        try:
            if troupe.pts_action > 0 and troupe.prochain_pain:
                troupe.avancer_max((*troupe.prochain_pain, 0))
                troupe.prochain_pain = None
            if troupe.pts_action > 0 and len(nids) > 0:
                troupe.avancer_nids(niveau_principal, nids)
            if troupe.pts_action > 0:
                troupe.avancer_max((*troupe.papy_le_plus_proche(), 0))
        except (PointsActionsInsuffisants, Innaccessible):
            pass


def partie_fin():
    """ Fonction appelée à la fin de la partie. """
    pass
