from api import *
from troupes import Troupe


class Parc:
    def __init__(self, niveau) -> None:
        self.niveau = niveau
        self.mes_troupes = {Troupe(t.id) for t in troupes_joueur(moi())}
        self.mes_nids = set()

    def est_libre(self, x, y):
        case = self.info_case(x, y, self.niveau)
        if case.contenu in (type_case.GAZON, type_case.NID, type_case.PAPY, 
                                      type_case.TUNNEL, type_case.TROU):
            return True
        if case.contenu == type_case.BARRIERE:
            return info_barriere((x, y, self.niveau)) == etat_barriere.OUVERTE
        return False


class NiveauPrincipal(Parc):
    def __init__(self):
        super().__init__(niveau=0)
        self.nids_innaccessibles = set()
        self.pains_innaccessibles = set()
        self.taille_ideale = max(min(15, (1-self.densite()) * min(HAUTEUR, LARGEUR)), 
                                 TAILLE_MIN) // 3 * 3

    @staticmethod
    def densite() -> float:
        obstacles = 0
        for x in range(LARGEUR):
            for y in range(HAUTEUR):
                if info_case((x, y, 0)).contenu == type_case.BUISSON:
                    obstacles += 1
        return obstacles / (LARGEUR * HAUTEUR)

    def pains_accessibles(self, troupe) :
        pains_acc = set((x,y) for (x,y,z) in pains()) - self.pains_innaccessibles
        for autre_troupe in self.mes_troupes:
            if autre_troupe.id != troupe.id: 
                pains_acc -= {autre_troupe.prochain_pain}
        return pains_acc

    def nids_accessibles(self, troupe) -> set[tuple[int, int]]:
        nids = set()
        for x in range(LARGEUR):
            for y in range(HAUTEUR):
                if info_nid((x, y, 0)) == etat_nid.LIBRE:
                    nids.add((x, y))
        nids -= self.nids_innaccessibles
        for autre_troupe in self.mes_troupes:
            if autre_troupe.id != troupe.id: 
                nids -= {autre_troupe.prochain_nid}
        return nids
