from api import *
from troupes import Troupe


class Parc:
    def __init__(self, niveau) -> None:
        self.niveau = niveau
        self.mes_troupes = {Troupe(t.id) for t in troupes_joueur(moi())}
        self.mes_nids = set()

    def est_libre(self, x, y):
        case = self.info_case(x, y, self.niveau)
        if case.contenu in (type_case.GAZON, type_case.NID, type_case.PAPY, 
                                      type_case.TUNNEL, type_case.TROU):
            return True
        if case.contenu == type_case.BARRIERE:
            return info_barriere((x, y, self.niveau)) == etat_barriere.OUVERTE
        return False

    def cul_de_sac(self, chemin) -> bool:
        # parcours en largeur depuis la dernière position
        pass


class NiveauPrincipal(Parc):
    def __init__(self):
        super().__init__(niveau=0)
        self.nids_innaccessibles = set()
        self.pains_innaccessibles = set()
        # plus la densite est grande plus la taille idéale est petite
        self.taille_ideale = max((1-self.densite()) * min(HAUTEUR, LARGEUR), 
                                 TAILLE_MIN) // 3 * 3

    @staticmethod
    def densite() -> float:
        """ Calcul la densité d'une carte comme le rapport 
        obstacles / nombre de cases 
        """
        obstacles = 0
        for x in range(LARGEUR):
            for y in range(HAUTEUR):
                if info_case((x, y, 0)).contenu == type_case.BUISSON:
                    obstacles += 1
        return obstacles / (LARGEUR * HAUTEUR)

    def pains_accessibles(self, troupe):
        pains_acc = set((x,y) for (x,y,z) in pains()) - self.pains_innaccessibles
        for autre_troupe in self.mes_troupes:
            if autre_troupe.id != troupe.id: 
                pains_acc -= {autre_troupe.prochain_pain}
        return pains_acc

    def nids_accessibles(self, troupe) -> set[tuple[int, int]]:
        """ Les nids accessibles par une troupe sont les nids libres ou possédés par le champion, 
        accessibles et qui ne sont pas déja visés par une autre troupe
        """
        nids = set()
        for x in range(LARGEUR):
            for y in range(HAUTEUR):
                if info_nid((x, y, 0)) in (etat_nid.LIBRE, moi()):
                    nids.add((x, y))
        nids -= self.nids_innaccessibles
        for autre_troupe in self.mes_troupes:
            if autre_troupe.id != troupe.id: 
                nids -= {autre_troupe.prochain_nid}
        return nids 


class NiveauSouterrain(Parc):

    def __init__(self):
        super().__init__(niveau=0)

    @staticmethod
    def creuser_relier(pos1, pos2):
        """ On creuse une case de terre entre pos1 et pos2 """
        x1, y1 = pos1
        x2, y2 = pos2
        for i in range(x1, x2, abs(x2-x1)/(x2-x1)):
            if info_case((i, y1, -1)).contenu == type_case.TERRE:
                return creuser_tunnel((i, y1, -1))
        for i in range(y1, y2, abs(y2-y1)/(y2-y1)):
            if info_case((x1, i, -1)).contenu == type_case.TERRE:
                return creuser_tunnel((x1, i, -1))