// SPDX-License-Identifier: GPL-2.0-or-later
// Copyright (c) 2020 Association Prologin <association@prologin.org>

// This file contains the code to call the API functions from the Python
// language.
// This file was generated by stechec2-generator. DO NOT EDIT.

#include <Python.h>
#include <vector>
#include <string>

static PyObject* py_module;
static PyObject* champ_module;


/// Erreurs possibles après avoir effectué une action
typedef enum erreur
{
    OK, ///< L'action a été effectuée avec succès
    TROUPE_INVALIDE, ///< Mauvais identifiant de troupe
    HORS_TOUR, ///< Aucune action n'est possible hors de joueur_tour
    MOUVEMENTS_INSUFFISANTS, ///< Il ne reste plus assez de points de mouvements pour effectuer l'action demandée
    TROP_GRANDI, ///< La troupe a déjà trop grandi pendant le tour
    TROP_CREUSE, ///< Trop de trous ont déjà été creusés pendant le tour
    NON_CREUSABLE, ///< Il n'est pas possible de creuser à la position demandée
    NON_CONSTRUCTIBLE, ///< La zone demandée n'est pas constructible
    SCORE_INSUFFISANT, ///< Le joueur n'a pas assez de points pour construire un buisson
    POSITION_INVALIDE, ///< La position demandée est hors du parc
    DIRECTION_INVALIDE, ///< La direction spécifiée n'existe pas.
    PIGEON_INVALIDE, ///< Le pigeon spécifié n'existe pas.
} erreur;

/// Directions possibles
typedef enum direction
{
    NORD, ///< Sens positif pour les lignes
    SUD, ///< Sens négatif pour les lignes
    EST, ///< Sens positif pour les colonnes
    OUEST, ///< Sens négatif pour les colonnes
    HAUT, ///< Sens positif pour le niveau
    BAS, ///< Sens négatif pour le niveau
} direction;

/// Type de l'élément présent sur une case
typedef enum type_case
{
    GAZON, ///< Absence d'élément
    BUISSON, ///< Obstacle impossible à traverser
    BARRIERE, ///< Élément pouvant être ouvert ou fermé. Une barrière fermée est infranchissable alors qu'une barrière ouverte est analogue à une case vide
    NID, ///< Élément traversable permettant à la troupe de déposer son inventaire en échange de points
    PAPY, ///< Élément traversable générant de manière périodique des miches de pain
    TROU, ///< Interface entre le niveau principal est le niveau souterrain
    TUNNEL, ///< Bloc du souterrain ayant été creusé
    TERRE, ///< Bloc du souterrain n'ayant pas encore été creusé
} type_case;

/// État d'une barrière, soit ouvert, soit fermé, soit non-applicable
typedef enum etat_barriere
{
    OUVERTE, ///< La barrière est ouverte
    FERMEE, ///< La barrière est fermée
    PAS_DE_BARRIERE, ///< L'élément dont on requiert l'état n'est pas une barrière
} etat_barriere;

/// Joueur auquel appartient un nid
typedef enum etat_nid
{
    LIBRE, ///< Le nid n'a pas été attribué
    JOUEUR_0, ///< Joueur 0
    JOUEUR_1, ///< Joueur 1
    PAS_DE_NID, ///< L'élément dont on requiert l'état n'est pas un nid
} etat_nid;

/// Type de pigeon de debug
typedef enum pigeon_debug
{
    PAS_DE_PIGEON, ///< Aucun pigeon, enlève le pigeon présent
    PIGEON_BLEU, ///< Pigeon bleu
    PIGEON_JAUNE, ///< Pigeon jaune
    PIGEON_ROUGE, ///< Pigeon rouge
} pigeon_debug;

/// Types d'actions
typedef enum type_action
{
    ACTION_AVANCER, ///< Action ``avancer``
    ACTION_GRANDIR, ///< Action ``grandir``
    ACTION_CONSTRUIRE, ///< Action ``construire buisson``
    ACTION_CREUSER, ///< Action ``creuser tunnel``
} type_action;

/// Position dans la carte, donnée par trois coordonnées
typedef struct position
{
    int colonne; ///< Abscisse
    int ligne; ///< Ordonnée
    int niveau; ///< Niveau
} position;

/// Une troupe, composée de la maman canard et de ses canetons
typedef struct troupe
{
    position maman; ///< Position de la maman canard
    std::vector<position> canards; ///< Position des différents canards de la troupe, incluant la maman en première position
    int taille; ///< Taille de la troupe
    direction dir; ///< Direction de la troupe
    int inventaire; ///< Nombre de pains de la troupe
    int pts_action; ///< Nombre de points d'action de la troupe
    int id; ///< Identifiant de la troupe
} troupe;

/// Élément constituant le parc
typedef struct etat_case
{
    position pos; ///< Position de la case. Le niveau vaut nécessairement 0
    type_case contenu; ///< Type de la case
    bool est_constructible; ///< La case est constructible
    int nb_pains; ///< Nombre de pains contenus sur la case
} etat_case;

/// Action représentée dans l'historique
typedef struct action_hist
{
    type_action action_type; ///< Type de l'action
    int troupe_id; ///< Identifiant de la troupe
    direction action_dir; ///< Direction de l'action
    position action_pos; ///< Position de l'action
} action_hist;

extern "C" {

/// La troupe avance d'une case vers une direction donnée
erreur api_avancer(int id, direction dir);

/// La troupe grandit
erreur api_grandir(int id);

/// Construit un buisson à la position donnée
erreur api_construire_buisson(position pos);

/// Creuse un tunnel à la position donnée
erreur api_creuser_tunnel(position pos);

/// Renvoie les informations concernant une case
etat_case api_info_case(position pos);

/// Renvoie les informations d'état d'une barrière
etat_barriere api_info_barriere(position pos);

/// Renvoie les informations d'état d'un nid
etat_nid api_info_nid(position pos);

/// Renvoie le nombre de tours restants avant qu'un papy dépose une miche de
/// pain. Retourne -1 si aucun papy ne se trouve à la position demandée
int api_papy_tours_restants(position pos);

/// Renvoie les troupes d'un joueur. Si le joueur est invalide, tous les champs
/// valent -1.
std::vector<troupe> api_troupes_joueur(int id_joueur);

/// Renvoie la position des pains récupérables
std::vector<position> api_pains();

/// Pose un pigeon de debug sur la case indiquée
erreur api_debug_poser_pigeon(position pos, pigeon_debug pigeon);

/// Renvoie la liste des actions effectuées par l'adversaire durant son tour,
/// dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans
/// cette liste.
std::vector<action_hist> api_historique();

/// Renvoie le gain en score que le nombre de pains passé en entrée
/// rapporterait s'ils étaient tous déposés d'un coup dans un nid
int api_gain(int nb_pains);

/// Renvoie la taille de l'inventaire d'une troupe de taille donnée
int api_inventaire(int taille);

/// Trouve un plus court chemin ouvert entre deux positions. Renvoie une liste
/// vide si les deux positions sont égales ou si aucun chemin n'existe.
std::vector<direction> api_trouver_chemin(position depart, position arrivee);

/// Renvoie votre numéro de joueur.
int api_moi();

/// Renvoie le numéro du joueur adverse.
int api_adversaire();

/// Renvoie le score du joueur `id_joueur`. Renvoie -1 si le joueur est
/// invalide.
int api_score(int id_joueur);

/// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à
/// annuler ce tour-ci
bool api_annuler();

/// Retourne le numéro du tour actuel.
int api_tour_actuel();

/// Affiche le contenu d'une valeur de type erreur
void api_afficher_erreur(erreur v);

/// Affiche le contenu d'une valeur de type direction
void api_afficher_direction(direction v);

/// Affiche le contenu d'une valeur de type type_case
void api_afficher_type_case(type_case v);

/// Affiche le contenu d'une valeur de type etat_barriere
void api_afficher_etat_barriere(etat_barriere v);

/// Affiche le contenu d'une valeur de type etat_nid
void api_afficher_etat_nid(etat_nid v);

/// Affiche le contenu d'une valeur de type pigeon_debug
void api_afficher_pigeon_debug(pigeon_debug v);

/// Affiche le contenu d'une valeur de type type_action
void api_afficher_type_action(type_action v);

/// Affiche le contenu d'une valeur de type position
void api_afficher_position(position v);

/// Affiche le contenu d'une valeur de type troupe
void api_afficher_troupe(troupe v);

/// Affiche le contenu d'une valeur de type etat_case
void api_afficher_etat_case(etat_case v);

/// Affiche le contenu d'une valeur de type action_hist
void api_afficher_action_hist(action_hist v);
}

template <typename PythonType, typename CxxType>
PythonType cxx_to_python(CxxType in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
PyObject* cxx_to_python<PyObject*, int>(int in)
{
    return PyLong_FromLong(in);
}


template <>
PyObject* cxx_to_python<PyObject*, double>(double in)
{
    return PyFloat_FromDouble(in);
}


template <>
PyObject* cxx_to_python<PyObject*, std::string>(std::string in)
{
    return PyUnicode_FromString(in.c_str());
}


template <>
PyObject* cxx_to_python<PyObject*, bool>(bool in)
{
    return PyBool_FromLong(in);
}

template <typename CxxType>
PyObject* cxx_to_python_array(const std::vector<CxxType>& in)
{
    size_t size = in.size();
    PyObject* out = PyList_New(size);

    for (unsigned int i = 0; i < size; ++i)
        PyList_SET_ITEM(out, i, (cxx_to_python<PyObject*, CxxType>(in[i])));

    return out;
}

template <typename PythonType, typename CxxType>
CxxType python_to_cxx(PythonType in)
{
    return in.__if_that_triggers_an_error_there_is_a_problem;
}

template <>
int python_to_cxx<PyObject*, int>(PyObject* in)
{
    long out = PyLong_AsLong(in);
    if (PyErr_Occurred())
        throw 42;
    return out;
}

template <>
double python_to_cxx<PyObject*, double>(PyObject* in)
{
    double out = PyFloat_AsDouble(in);
    if (PyErr_Occurred())
        throw 42;
    return out;
}

template <>
bool python_to_cxx<PyObject*, bool>(PyObject* in)
{
    return static_cast<bool>(python_to_cxx<PyObject*, int>(in));
}

template <>
std::string python_to_cxx<PyObject*, std::string>(PyObject* in)
{
    const char* out = PyUnicode_AsUTF8(in);
    if (PyErr_Occurred())
        throw 42;
    return out;
}

template <typename CxxType>
std::vector<CxxType> python_to_cxx_array(PyObject* in)
{
    if (!PyList_Check(in))
    {
        PyErr_SetString(PyExc_TypeError, "a list is required");
        throw 42;
    }

    std::vector<CxxType> out;
    unsigned int size = PyList_Size(in);
    out.reserve(size);

    for (unsigned int i = 0; i < size; ++i)
        out.push_back(python_to_cxx<PyObject*, CxxType>(PyList_GET_ITEM(in, i)));

    return out;
}

// Erreurs possibles après avoir effectué une action

template<>
PyObject* cxx_to_python<PyObject*, erreur>(erreur in)
{
    PyObject* name = PyUnicode_FromString("erreur");
    PyObject* enm = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (enm == nullptr)
        throw 42;
    PyObject* arglist = Py_BuildValue("(i)", static_cast<int>(in));
    PyObject* ret = PyObject_CallObject(enm, arglist);
    Py_DECREF(enm);
    Py_DECREF(arglist);
    return ret;
}

template <>
erreur python_to_cxx<PyObject*, erreur>(PyObject* in)
{
    return static_cast<erreur>(python_to_cxx<PyObject*, int>(in));
}

// Directions possibles

template<>
PyObject* cxx_to_python<PyObject*, direction>(direction in)
{
    PyObject* name = PyUnicode_FromString("direction");
    PyObject* enm = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (enm == nullptr)
        throw 42;
    PyObject* arglist = Py_BuildValue("(i)", static_cast<int>(in));
    PyObject* ret = PyObject_CallObject(enm, arglist);
    Py_DECREF(enm);
    Py_DECREF(arglist);
    return ret;
}

template <>
direction python_to_cxx<PyObject*, direction>(PyObject* in)
{
    return static_cast<direction>(python_to_cxx<PyObject*, int>(in));
}

// Type de l'élément présent sur une case

template<>
PyObject* cxx_to_python<PyObject*, type_case>(type_case in)
{
    PyObject* name = PyUnicode_FromString("type_case");
    PyObject* enm = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (enm == nullptr)
        throw 42;
    PyObject* arglist = Py_BuildValue("(i)", static_cast<int>(in));
    PyObject* ret = PyObject_CallObject(enm, arglist);
    Py_DECREF(enm);
    Py_DECREF(arglist);
    return ret;
}

template <>
type_case python_to_cxx<PyObject*, type_case>(PyObject* in)
{
    return static_cast<type_case>(python_to_cxx<PyObject*, int>(in));
}

// État d'une barrière, soit ouvert, soit fermé, soit non-applicable

template<>
PyObject* cxx_to_python<PyObject*, etat_barriere>(etat_barriere in)
{
    PyObject* name = PyUnicode_FromString("etat_barriere");
    PyObject* enm = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (enm == nullptr)
        throw 42;
    PyObject* arglist = Py_BuildValue("(i)", static_cast<int>(in));
    PyObject* ret = PyObject_CallObject(enm, arglist);
    Py_DECREF(enm);
    Py_DECREF(arglist);
    return ret;
}

template <>
etat_barriere python_to_cxx<PyObject*, etat_barriere>(PyObject* in)
{
    return static_cast<etat_barriere>(python_to_cxx<PyObject*, int>(in));
}

// Joueur auquel appartient un nid

template<>
PyObject* cxx_to_python<PyObject*, etat_nid>(etat_nid in)
{
    PyObject* name = PyUnicode_FromString("etat_nid");
    PyObject* enm = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (enm == nullptr)
        throw 42;
    PyObject* arglist = Py_BuildValue("(i)", static_cast<int>(in));
    PyObject* ret = PyObject_CallObject(enm, arglist);
    Py_DECREF(enm);
    Py_DECREF(arglist);
    return ret;
}

template <>
etat_nid python_to_cxx<PyObject*, etat_nid>(PyObject* in)
{
    return static_cast<etat_nid>(python_to_cxx<PyObject*, int>(in));
}

// Type de pigeon de debug

template<>
PyObject* cxx_to_python<PyObject*, pigeon_debug>(pigeon_debug in)
{
    PyObject* name = PyUnicode_FromString("pigeon_debug");
    PyObject* enm = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (enm == nullptr)
        throw 42;
    PyObject* arglist = Py_BuildValue("(i)", static_cast<int>(in));
    PyObject* ret = PyObject_CallObject(enm, arglist);
    Py_DECREF(enm);
    Py_DECREF(arglist);
    return ret;
}

template <>
pigeon_debug python_to_cxx<PyObject*, pigeon_debug>(PyObject* in)
{
    return static_cast<pigeon_debug>(python_to_cxx<PyObject*, int>(in));
}

// Types d'actions

template<>
PyObject* cxx_to_python<PyObject*, type_action>(type_action in)
{
    PyObject* name = PyUnicode_FromString("type_action");
    PyObject* enm = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (enm == nullptr)
        throw 42;
    PyObject* arglist = Py_BuildValue("(i)", static_cast<int>(in));
    PyObject* ret = PyObject_CallObject(enm, arglist);
    Py_DECREF(enm);
    Py_DECREF(arglist);
    return ret;
}

template <>
type_action python_to_cxx<PyObject*, type_action>(PyObject* in)
{
    return static_cast<type_action>(python_to_cxx<PyObject*, int>(in));
}

// Position dans la carte, donnée par trois coordonnées

template <>
PyObject* cxx_to_python<PyObject*, position>(position in)
{
    PyObject* tuple = PyTuple_New(3);
    PyTuple_SET_ITEM(tuple, 0, (cxx_to_python<PyObject*, int>(in.colonne)));
    PyTuple_SET_ITEM(tuple, 1, (cxx_to_python<PyObject*, int>(in.ligne)));
    PyTuple_SET_ITEM(tuple, 2, (cxx_to_python<PyObject*, int>(in.niveau)));
    return tuple;
}

template <>
position python_to_cxx<PyObject*, position>(PyObject* in)
{
    position out;
    PyObject* i;

    // Abscisse
    i = PyTuple_GetItem(in, 0);
    if (i == nullptr)
        throw 42;
    out.colonne = python_to_cxx<PyObject*, int>(i);

    // Ordonnée
    i = PyTuple_GetItem(in, 1);
    if (i == nullptr)
        throw 42;
    out.ligne = python_to_cxx<PyObject*, int>(i);

    // Niveau
    i = PyTuple_GetItem(in, 2);
    if (i == nullptr)
        throw 42;
    out.niveau = python_to_cxx<PyObject*, int>(i);

    return out;
}

// Une troupe, composée de la maman canard et de ses canetons

template <>
PyObject* cxx_to_python<PyObject*, troupe>(troupe in)
{
    PyObject* tuple = PyTuple_New(7);
    PyTuple_SET_ITEM(tuple, 0, (cxx_to_python<PyObject*, position>(in.maman)));
    PyTuple_SET_ITEM(tuple, 1, (cxx_to_python_array(in.canards)));
    PyTuple_SET_ITEM(tuple, 2, (cxx_to_python<PyObject*, int>(in.taille)));
    PyTuple_SET_ITEM(tuple, 3, (cxx_to_python<PyObject*, direction>(in.dir)));
    PyTuple_SET_ITEM(tuple, 4, (cxx_to_python<PyObject*, int>(in.inventaire)));
    PyTuple_SET_ITEM(tuple, 5, (cxx_to_python<PyObject*, int>(in.pts_action)));
    PyTuple_SET_ITEM(tuple, 6, (cxx_to_python<PyObject*, int>(in.id)));
    PyObject* name = PyUnicode_FromString("troupe");
    PyObject* cstr = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (cstr == nullptr)
        throw 42;
    PyObject* ret = PyObject_CallObject(cstr, tuple);
    Py_DECREF(cstr);
    Py_DECREF(tuple);
    if (ret == nullptr)
        throw 42;
    return ret;
}

template <>
troupe python_to_cxx<PyObject*, troupe>(PyObject* in)
{
    troupe out;
    PyObject* i;

    // Position de la maman canard
    i = cxx_to_python<PyObject*, int>(0);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.maman = python_to_cxx<PyObject*, position>(i);
    Py_DECREF(i);

    // Position des différents canards de la troupe, incluant la maman en première
// position
    i = cxx_to_python<PyObject*, int>(1);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.canards = python_to_cxx_array<position>(i);
    Py_DECREF(i);

    // Taille de la troupe
    i = cxx_to_python<PyObject*, int>(2);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.taille = python_to_cxx<PyObject*, int>(i);
    Py_DECREF(i);

    // Direction de la troupe
    i = cxx_to_python<PyObject*, int>(3);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.dir = python_to_cxx<PyObject*, direction>(i);
    Py_DECREF(i);

    // Nombre de pains de la troupe
    i = cxx_to_python<PyObject*, int>(4);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.inventaire = python_to_cxx<PyObject*, int>(i);
    Py_DECREF(i);

    // Nombre de points d'action de la troupe
    i = cxx_to_python<PyObject*, int>(5);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.pts_action = python_to_cxx<PyObject*, int>(i);
    Py_DECREF(i);

    // Identifiant de la troupe
    i = cxx_to_python<PyObject*, int>(6);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.id = python_to_cxx<PyObject*, int>(i);
    Py_DECREF(i);

    return out;
}

// Élément constituant le parc

template <>
PyObject* cxx_to_python<PyObject*, etat_case>(etat_case in)
{
    PyObject* tuple = PyTuple_New(4);
    PyTuple_SET_ITEM(tuple, 0, (cxx_to_python<PyObject*, position>(in.pos)));
    PyTuple_SET_ITEM(tuple, 1, (cxx_to_python<PyObject*, type_case>(in.contenu)));
    PyTuple_SET_ITEM(tuple, 2, (cxx_to_python<PyObject*, bool>(in.est_constructible)));
    PyTuple_SET_ITEM(tuple, 3, (cxx_to_python<PyObject*, int>(in.nb_pains)));
    PyObject* name = PyUnicode_FromString("etat_case");
    PyObject* cstr = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (cstr == nullptr)
        throw 42;
    PyObject* ret = PyObject_CallObject(cstr, tuple);
    Py_DECREF(cstr);
    Py_DECREF(tuple);
    if (ret == nullptr)
        throw 42;
    return ret;
}

template <>
etat_case python_to_cxx<PyObject*, etat_case>(PyObject* in)
{
    etat_case out;
    PyObject* i;

    // Position de la case. Le niveau vaut nécessairement 0
    i = cxx_to_python<PyObject*, int>(0);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.pos = python_to_cxx<PyObject*, position>(i);
    Py_DECREF(i);

    // Type de la case
    i = cxx_to_python<PyObject*, int>(1);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.contenu = python_to_cxx<PyObject*, type_case>(i);
    Py_DECREF(i);

    // La case est constructible
    i = cxx_to_python<PyObject*, int>(2);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.est_constructible = python_to_cxx<PyObject*, bool>(i);
    Py_DECREF(i);

    // Nombre de pains contenus sur la case
    i = cxx_to_python<PyObject*, int>(3);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.nb_pains = python_to_cxx<PyObject*, int>(i);
    Py_DECREF(i);

    return out;
}

// Action représentée dans l'historique

template <>
PyObject* cxx_to_python<PyObject*, action_hist>(action_hist in)
{
    PyObject* tuple = PyTuple_New(4);
    PyTuple_SET_ITEM(tuple, 0, (cxx_to_python<PyObject*, type_action>(in.action_type)));
    PyTuple_SET_ITEM(tuple, 1, (cxx_to_python<PyObject*, int>(in.troupe_id)));
    PyTuple_SET_ITEM(tuple, 2, (cxx_to_python<PyObject*, direction>(in.action_dir)));
    PyTuple_SET_ITEM(tuple, 3, (cxx_to_python<PyObject*, position>(in.action_pos)));
    PyObject* name = PyUnicode_FromString("action_hist");
    PyObject* cstr = PyObject_GetAttr(py_module, name);
    Py_DECREF(name);
    if (cstr == nullptr)
        throw 42;
    PyObject* ret = PyObject_CallObject(cstr, tuple);
    Py_DECREF(cstr);
    Py_DECREF(tuple);
    if (ret == nullptr)
        throw 42;
    return ret;
}

template <>
action_hist python_to_cxx<PyObject*, action_hist>(PyObject* in)
{
    action_hist out;
    PyObject* i;

    // Type de l'action
    i = cxx_to_python<PyObject*, int>(0);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.action_type = python_to_cxx<PyObject*, type_action>(i);
    Py_DECREF(i);

    // Identifiant de la troupe
    i = cxx_to_python<PyObject*, int>(1);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.troupe_id = python_to_cxx<PyObject*, int>(i);
    Py_DECREF(i);

    // Direction de l'action
    i = cxx_to_python<PyObject*, int>(2);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.action_dir = python_to_cxx<PyObject*, direction>(i);
    Py_DECREF(i);

    // Position de l'action
    i = cxx_to_python<PyObject*, int>(3);
    i = PyObject_GetItem(in, i);
    if (i == nullptr)
        throw 42;
    out.action_pos = python_to_cxx<PyObject*, position>(i);
    Py_DECREF(i);

    return out;
}


// Python native wrapper for function avancer.
// La troupe avance d'une case vers une direction donnée
static PyObject* p_avancer(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_id;
    PyObject* arg_dir;
    if (!PyArg_ParseTuple(args, "OO", &arg_id, &arg_dir))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, erreur>(api_avancer(python_to_cxx<PyObject*, int>(arg_id), python_to_cxx<PyObject*, direction>(arg_dir)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function grandir.
// La troupe grandit
static PyObject* p_grandir(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_id;
    if (!PyArg_ParseTuple(args, "O", &arg_id))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, erreur>(api_grandir(python_to_cxx<PyObject*, int>(arg_id)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function construire_buisson.
// Construit un buisson à la position donnée
static PyObject* p_construire_buisson(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_pos;
    if (!PyArg_ParseTuple(args, "O", &arg_pos))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, erreur>(api_construire_buisson(python_to_cxx<PyObject*, position>(arg_pos)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function creuser_tunnel.
// Creuse un tunnel à la position donnée
static PyObject* p_creuser_tunnel(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_pos;
    if (!PyArg_ParseTuple(args, "O", &arg_pos))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, erreur>(api_creuser_tunnel(python_to_cxx<PyObject*, position>(arg_pos)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function info_case.
// Renvoie les informations concernant une case
static PyObject* p_info_case(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_pos;
    if (!PyArg_ParseTuple(args, "O", &arg_pos))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, etat_case>(api_info_case(python_to_cxx<PyObject*, position>(arg_pos)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function info_barriere.
// Renvoie les informations d'état d'une barrière
static PyObject* p_info_barriere(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_pos;
    if (!PyArg_ParseTuple(args, "O", &arg_pos))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, etat_barriere>(api_info_barriere(python_to_cxx<PyObject*, position>(arg_pos)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function info_nid.
// Renvoie les informations d'état d'un nid
static PyObject* p_info_nid(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_pos;
    if (!PyArg_ParseTuple(args, "O", &arg_pos))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, etat_nid>(api_info_nid(python_to_cxx<PyObject*, position>(arg_pos)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function papy_tours_restants.
// Renvoie le nombre de tours restants avant qu'un papy dépose une miche de
// pain. Retourne -1 si aucun papy ne se trouve à la position demandée
static PyObject* p_papy_tours_restants(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_pos;
    if (!PyArg_ParseTuple(args, "O", &arg_pos))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, int>(api_papy_tours_restants(python_to_cxx<PyObject*, position>(arg_pos)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function troupes_joueur.
// Renvoie les troupes d'un joueur. Si le joueur est invalide, tous les champs
// valent -1.
static PyObject* p_troupes_joueur(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_id_joueur;
    if (!PyArg_ParseTuple(args, "O", &arg_id_joueur))
    {
        return nullptr;
    }

    try {
        return cxx_to_python_array(api_troupes_joueur(python_to_cxx<PyObject*, int>(arg_id_joueur)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function pains.
// Renvoie la position des pains récupérables
static PyObject* p_pains(PyObject* /* self */, PyObject* args)
{
    if (!PyArg_ParseTuple(args, ""))
    {
        return nullptr;
    }

    try {
        return cxx_to_python_array(api_pains());
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function debug_poser_pigeon.
// Pose un pigeon de debug sur la case indiquée
static PyObject* p_debug_poser_pigeon(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_pos;
    PyObject* arg_pigeon;
    if (!PyArg_ParseTuple(args, "OO", &arg_pos, &arg_pigeon))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, erreur>(api_debug_poser_pigeon(python_to_cxx<PyObject*, position>(arg_pos), python_to_cxx<PyObject*, pigeon_debug>(arg_pigeon)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function historique.
// Renvoie la liste des actions effectuées par l'adversaire durant son tour,
// dans l'ordre chronologique. Les actions de débug n'apparaissent pas dans
// cette liste.
static PyObject* p_historique(PyObject* /* self */, PyObject* args)
{
    if (!PyArg_ParseTuple(args, ""))
    {
        return nullptr;
    }

    try {
        return cxx_to_python_array(api_historique());
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function gain.
// Renvoie le gain en score que le nombre de pains passé en entrée rapporterait
// s'ils étaient tous déposés d'un coup dans un nid
static PyObject* p_gain(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_nb_pains;
    if (!PyArg_ParseTuple(args, "O", &arg_nb_pains))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, int>(api_gain(python_to_cxx<PyObject*, int>(arg_nb_pains)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function inventaire.
// Renvoie la taille de l'inventaire d'une troupe de taille donnée
static PyObject* p_inventaire(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_taille;
    if (!PyArg_ParseTuple(args, "O", &arg_taille))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, int>(api_inventaire(python_to_cxx<PyObject*, int>(arg_taille)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function trouver_chemin.
// Trouve un plus court chemin ouvert entre deux positions. Renvoie une liste
// vide si les deux positions sont égales ou si aucun chemin n'existe.
static PyObject* p_trouver_chemin(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_depart;
    PyObject* arg_arrivee;
    if (!PyArg_ParseTuple(args, "OO", &arg_depart, &arg_arrivee))
    {
        return nullptr;
    }

    try {
        return cxx_to_python_array(api_trouver_chemin(python_to_cxx<PyObject*, position>(arg_depart), python_to_cxx<PyObject*, position>(arg_arrivee)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function moi.
// Renvoie votre numéro de joueur.
static PyObject* p_moi(PyObject* /* self */, PyObject* args)
{
    if (!PyArg_ParseTuple(args, ""))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, int>(api_moi());
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function adversaire.
// Renvoie le numéro du joueur adverse.
static PyObject* p_adversaire(PyObject* /* self */, PyObject* args)
{
    if (!PyArg_ParseTuple(args, ""))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, int>(api_adversaire());
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function score.
// Renvoie le score du joueur `id_joueur`. Renvoie -1 si le joueur est
// invalide.
static PyObject* p_score(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_id_joueur;
    if (!PyArg_ParseTuple(args, "O", &arg_id_joueur))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, int>(api_score(python_to_cxx<PyObject*, int>(arg_id_joueur)));
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function annuler.
// Annule la dernière action. Renvoie faux quand il n'y a pas d'action à
// annuler ce tour-ci
static PyObject* p_annuler(PyObject* /* self */, PyObject* args)
{
    if (!PyArg_ParseTuple(args, ""))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, bool>(api_annuler());
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function tour_actuel.
// Retourne le numéro du tour actuel.
static PyObject* p_tour_actuel(PyObject* /* self */, PyObject* args)
{
    if (!PyArg_ParseTuple(args, ""))
    {
        return nullptr;
    }

    try {
        return cxx_to_python<PyObject*, int>(api_tour_actuel());
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_erreur.
// Affiche le contenu d'une valeur de type erreur
static PyObject* p_afficher_erreur(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_erreur(python_to_cxx<PyObject*, erreur>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_direction.
// Affiche le contenu d'une valeur de type direction
static PyObject* p_afficher_direction(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_direction(python_to_cxx<PyObject*, direction>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_type_case.
// Affiche le contenu d'une valeur de type type_case
static PyObject* p_afficher_type_case(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_type_case(python_to_cxx<PyObject*, type_case>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_etat_barriere.
// Affiche le contenu d'une valeur de type etat_barriere
static PyObject* p_afficher_etat_barriere(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_etat_barriere(python_to_cxx<PyObject*, etat_barriere>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_etat_nid.
// Affiche le contenu d'une valeur de type etat_nid
static PyObject* p_afficher_etat_nid(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_etat_nid(python_to_cxx<PyObject*, etat_nid>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_pigeon_debug.
// Affiche le contenu d'une valeur de type pigeon_debug
static PyObject* p_afficher_pigeon_debug(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_pigeon_debug(python_to_cxx<PyObject*, pigeon_debug>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_type_action.
// Affiche le contenu d'une valeur de type type_action
static PyObject* p_afficher_type_action(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_type_action(python_to_cxx<PyObject*, type_action>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_position.
// Affiche le contenu d'une valeur de type position
static PyObject* p_afficher_position(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_position(python_to_cxx<PyObject*, position>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_troupe.
// Affiche le contenu d'une valeur de type troupe
static PyObject* p_afficher_troupe(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_troupe(python_to_cxx<PyObject*, troupe>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_etat_case.
// Affiche le contenu d'une valeur de type etat_case
static PyObject* p_afficher_etat_case(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_etat_case(python_to_cxx<PyObject*, etat_case>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// Python native wrapper for function afficher_action_hist.
// Affiche le contenu d'une valeur de type action_hist
static PyObject* p_afficher_action_hist(PyObject* /* self */, PyObject* args)
{
    PyObject* arg_v;
    if (!PyArg_ParseTuple(args, "O", &arg_v))
    {
        return nullptr;
    }

    try {
        (api_afficher_action_hist(python_to_cxx<PyObject*, action_hist>(arg_v)));
        Py_RETURN_NONE;
    } catch (...) {
        return nullptr;
    }
}

// API function to register.
static PyMethodDef api_callback[] = {
    {"avancer", p_avancer, METH_VARARGS, "avancer"},
    {"grandir", p_grandir, METH_VARARGS, "grandir"},
    {"construire_buisson", p_construire_buisson, METH_VARARGS, "construire_buisson"},
    {"creuser_tunnel", p_creuser_tunnel, METH_VARARGS, "creuser_tunnel"},
    {"info_case", p_info_case, METH_VARARGS, "info_case"},
    {"info_barriere", p_info_barriere, METH_VARARGS, "info_barriere"},
    {"info_nid", p_info_nid, METH_VARARGS, "info_nid"},
    {"papy_tours_restants", p_papy_tours_restants, METH_VARARGS, "papy_tours_restants"},
    {"troupes_joueur", p_troupes_joueur, METH_VARARGS, "troupes_joueur"},
    {"pains", p_pains, METH_VARARGS, "pains"},
    {"debug_poser_pigeon", p_debug_poser_pigeon, METH_VARARGS, "debug_poser_pigeon"},
    {"historique", p_historique, METH_VARARGS, "historique"},
    {"gain", p_gain, METH_VARARGS, "gain"},
    {"inventaire", p_inventaire, METH_VARARGS, "inventaire"},
    {"trouver_chemin", p_trouver_chemin, METH_VARARGS, "trouver_chemin"},
    {"moi", p_moi, METH_VARARGS, "moi"},
    {"adversaire", p_adversaire, METH_VARARGS, "adversaire"},
    {"score", p_score, METH_VARARGS, "score"},
    {"annuler", p_annuler, METH_VARARGS, "annuler"},
    {"tour_actuel", p_tour_actuel, METH_VARARGS, "tour_actuel"},
    {"afficher_erreur", p_afficher_erreur, METH_VARARGS, "afficher_erreur"},
    {"afficher_direction", p_afficher_direction, METH_VARARGS, "afficher_direction"},
    {"afficher_type_case", p_afficher_type_case, METH_VARARGS, "afficher_type_case"},
    {"afficher_etat_barriere", p_afficher_etat_barriere, METH_VARARGS, "afficher_etat_barriere"},
    {"afficher_etat_nid", p_afficher_etat_nid, METH_VARARGS, "afficher_etat_nid"},
    {"afficher_pigeon_debug", p_afficher_pigeon_debug, METH_VARARGS, "afficher_pigeon_debug"},
    {"afficher_type_action", p_afficher_type_action, METH_VARARGS, "afficher_type_action"},
    {"afficher_position", p_afficher_position, METH_VARARGS, "afficher_position"},
    {"afficher_troupe", p_afficher_troupe, METH_VARARGS, "afficher_troupe"},
    {"afficher_etat_case", p_afficher_etat_case, METH_VARARGS, "afficher_etat_case"},
    {"afficher_action_hist", p_afficher_action_hist, METH_VARARGS, "afficher_action_hist"},
    {nullptr, nullptr, 0, nullptr}
};

// Initialize C module.
PyMODINIT_FUNC PyInit__api()
{
    static struct PyModuleDef apimoduledef = {
        PyModuleDef_HEAD_INIT,
        "_api",
        "API module",
        -1,
        api_callback,
        nullptr,
        nullptr,
        nullptr,
        nullptr,
    };
    return PyModule_Create(&apimoduledef);
}

// Load a Python module.
static PyObject* _import_module(const char* m)
{
    PyObject* name = PyUnicode_FromString(m);
    PyObject* mod = PyImport_Import(name);
    Py_DECREF(name);
    if (mod == nullptr)
        if (PyErr_Occurred())
        {
            PyErr_Print();
            abort();
        }
    return mod;
}

// Initialize Python VM, register API functions, and load .py file.
static void _init_python()
{
    static wchar_t empty_string[] = L"";
    static wchar_t *argv[] = { (wchar_t *) &empty_string, nullptr };

    const char* champion_path;

    champion_path = getenv("CHAMPION_PATH");
    if (champion_path == nullptr)
        champion_path = ".";

    setenv("PYTHONPATH", champion_path, 1);

    static wchar_t program_name[] = L"stechec";
    Py_SetProgramName(program_name);

    PyImport_AppendInittab("_api", PyInit__api);
    Py_Initialize();
    PySys_SetArgvEx(1, argv, 0);

    // Import a Champion module with an uppercase letter to avoid conflict with
    // champion.so
    champ_module = _import_module("Champion");
    py_module = _import_module("api");
}

// Flush stdout and stderr
static void flush_std_files()
{
    PyObject *fout = PySys_GetObject("stdout");
    PyObject *ferr = PySys_GetObject("stderr");
    PyObject *tmp;

    if (fout != nullptr && fout != Py_None) {
        tmp = PyObject_CallMethod(fout, "flush", "");
        if (tmp == nullptr)
            PyErr_WriteUnraisable(fout);
        else
            Py_DECREF(tmp);
    }

    if (ferr != nullptr && ferr != Py_None) {
        tmp = PyObject_CallMethod(ferr, "flush", "");
        if (tmp == nullptr)
            PyErr_Clear();
        else
            Py_DECREF(tmp);
    }
}

// Run a Python function.
static PyObject* _call_python_function(const char* name)
{
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;
        _init_python();
    }

    PyObject *arglist, *func;
    PyObject *result = nullptr;

    func = PyObject_GetAttrString(champ_module, name);
    if (func && PyCallable_Check(func))
    {
        arglist = Py_BuildValue("()");
        result = PyEval_CallObject(func, arglist);
        Py_XDECREF(arglist);
        Py_DECREF(func);
    }
    if (result == nullptr && PyErr_Occurred())
    {
        PyErr_Print();
        abort();
    }

    flush_std_files();
    return result;
}


// Functions called from Stechec to Python.

extern "C" void partie_init()
{
    PyObject* _retval = _call_python_function("partie_init");
    try {
        Py_XDECREF(_retval);
    } catch (...) {
        PyErr_Print();
        abort();
    }
}

extern "C" void jouer_tour()
{
    PyObject* _retval = _call_python_function("jouer_tour");
    try {
        Py_XDECREF(_retval);
    } catch (...) {
        PyErr_Print();
        abort();
    }
}

extern "C" void partie_fin()
{
    PyObject* _retval = _call_python_function("partie_fin");
    try {
        Py_XDECREF(_retval);
    } catch (...) {
        PyErr_Print();
        abort();
    }
}
