from api import *
import time
from functools import wraps
from math import sqrt


def duree(f):
    @wraps(f)
    def inner(*args, **kwargs):
        debut = time.time()
        f(*args, **kwargs)
        fin = time.time()
        print(f"La fonction {f.__name__} a mis {fin-debut:.3f} s")
    return inner


def distance(pos1, pos2):
    return sqrt((pos2[0]-pos1[0])**2 + (pos2[1]-pos1[0])**2)


def troupe_avec_id(joueur_id: int, id: int):
    for troupe in troupes_joueur(joueur_id):
        if troupe.id == id:
            return troupe
