from api import *
from outils import troupe_avec_id, distance, duree
from functools import partial 


class Innaccessible(Exception):
    pass

class PointsActionsInsuffisants(Exception):
    pass


class Troupe:

    def __init__(self, id_troupe: int):
        self.id = id_troupe
        self.prochain_nid = None
        self.prochain_pain = None

    def avancer_max(self, pos: tuple[int, int, int]):
        chemin = trouver_chemin(self.troupe.maman, pos)
        if len(chemin) == 0:
            raise Innaccessible

        for direction in chemin:
            if avancer(self.id, direction) != erreur.OK:
                raise PointsActionsInsuffisants

    # @duree
    def avancer_nids(self, niveau_principal, nids):
        """
        for nid in nids:
            debug_poser_pigeon((*nid, 0), pigeon_debug.PAS_DE_PIGEON)
            debug_poser_pigeon((*nid, 0), pigeon_debug.PIGEON_ROUGE)
        """
        plus_proche_nid = min(nids, key=partial(distance, (self.x, self.y)))
        self.prochain_nid = None
        try: 
            self.avancer_max((*plus_proche_nid, 0))
            niveau_principal.mes_nids.add(plus_proche_nid)
        except Innaccessible:
            niveau_principal.nids_innaccessibles.add(plus_proche_nid)
        except PointsActionsInsuffisants:
            self.prochain_nid = plus_proche_nid
        else:
            return True

    # @duree
    def avancer_pains(self, niveau_principal, pains):
        plus_proche_pain = min(pains, key=partial(distance, (self.x, self.y)))
        self.prochain_pain = None
        try: 
            self.avancer_max((*plus_proche_pain, 0))
        except Innaccessible:
            niveau_principal.pains_innaccessibles.add(plus_proche_pain)
        except PointsActionsInsuffisants:
            self.prochain_pain = plus_proche_pain

    @property
    def troupe(self):
        return troupe_avec_id(moi(), self.id)

    def __getattr__(self, name):
        return getattr(self.troupe, name)

    @property
    def x(self):
        return self.troupe.maman[0]

    @property
    def y(self):
        return self.troupe.maman[1]

    def __repr__(self):
        return repr(self.troupe)
