from api import *
from random import choice

debug  = False

def getGraph():
    graph = []
    for i in range(HAUTEUR):
        row = []
        for j in range(LARGEUR):
            row.append(str(j+i*HAUTEUR))
        graph.append(row)
    return graph


def getPts(ind):
    return troupes_joueur(moi())[ind].pts_action

def getInd(ind):
    me = moi()
    ind = troupes_joueur(me)[ind].id
    return ind

def getPos(ind):
    me = moi()
    maman = troupes_joueur(me)[ind].maman
    return maman

def getSize(ind):
    me = moi()
    return troupes_joueur(me)[ind].taille

def getInv(ind):
    return troupes_joueur(moi())[ind].inventaire

def getNearest(tab, from_):
    allDir = []
    allRoad = []
    for el in tab:
        path = trouver_chemin(from_, el)
        if len(path) != 0:
            allDir.append(len(path))
            allRoad.append(path)
    if allDir:
        return allRoad[allDir.index(min(allDir))]
    return None

def getEL(for_, graph):
    tab = []
    for y, row in enumerate(graph):
        for x, el in enumerate(row):
            case = (x, y, 0)
            if info_case(case).contenu == for_:
                case = (x, HAUTEUR-y-1, 0)
                case = (x, y, 0)
                tab.append(case)
    return tab

def notDangerous(case):
    if info_case(case).contenu != type_case.BUISSON:
        canards = []
        for personne in [moi(), adversaire()]:
            for i in range(2):
                canards.extend(troupes_joueur(personne)[i].canards)
        if case not in canards:
            return True
        return False

def newCase(pos, direc):
    x, y, z = pos
    if direc == direction.NORD:
        if y+1 < HAUTEUR:
            return (x, y+1, z)
    elif direc == direction.SUD:
        if y-1 >= 0:
            return (x, y-1, z)
    elif direc == direction.EST:
        if x+1 < LARGEUR:
            return (x+1, y, z)
    if x-1 > 0:
        return (x-1, y, z)

def partie_init():
    if debug:
        print("INIT")

def jouer_tour():
    if debug:
        print("------------------")
        print("PLAYER: {}".format(moi()))
        print("tour {}".format(tour_actuel()))
        print("------------------")
    maman = 0
    graph = getGraph()
    for maman in range(NB_TROUPES):
        if debug:
            print(" => MAMAN NUMERO {}\n".format(maman))
        pain = pains()
        while getPts(maman) > 0:
            if debug:
                print("\n-TOUR BOUCLE WHILE-\n")
            pts = getPts(maman)
            from_ = getPos(maman)
            if getSize(maman) < 14:
                if getPts(maman) >= 3:
                    if debug:
                        print("GRANDIR")
                    grandir(getInd(maman))

            if getSize(maman)//3 == getInv(maman):
                obj = getEL(type_case.NID, graph)
                obj = getNearest(obj, from_)
                if obj:
                    for road in obj:
                        if getPts(maman) >= 1:
                            if debug:
                                print("RETOUR BASE")
                            avancer(getInd(maman), road)
                        else:
                            break
            if pain:
                if debug:
                    print("CHERCHE DU PAIN")
                obj = getNearest(pain, from_)
                if obj:
                    for road in obj:
                        if getPts(maman) >= 1:
                            avancer(getInd(maman), road)
                            if debug:
                                print("AVANCER VERS PAIN")
                        else:
                            break
                else:
                    if debug:
                        print("PAS DE PAIN")
            indDir = 0
            if getPts(maman) == pts:
                if debug:
                    print("TECHNIQUE DE SCHLAG")
                for indDir, direc in enumerate([direction.NORD, direction.SUD, direction.EST, direction.OUEST]):
                    from_ = getPos(maman)
                    new_case = newCase(from_, direc)
                    if new_case:
                        if notDangerous(new_case):
                            if getPts(maman) > 0:
                                if debug:
                                    print("AVANCER DANGEREUX")
                                avancer(getInd(maman), direc)
                                break
            if indDir == 3:
                if debug:
                    print("SUICCIDE")
                break
        



def partie_fin():
    pass