
from api import *

from random import randint



# TODO => ne pas retourner sur les mêmes cases

def getInd(ind):
    me = moi()
    ind = troupes_joueur(me)[ind].id
    return ind


def getDir(pos1, pos2):
    x1, x2 = pos1[1], pos2[1]
    y1, y2 = pos1[0], pos2[0]
    if x1 > x2:
        print(f"{pos1} => {pos2}, OUEST")
        return direction.OUEST
    if x1 < x2:
        print(f"{pos1} => {pos2}, EST")
        return direction.EST
    if y1 > y2:
        print(f"{pos1} => {pos2}, SUD")
        return direction.SUD
    if y1 < y2:
        print(f"{pos1} => {pos2}, NORD")
        return direction.NORD
    print("ERREUR")
    return None

def getPos(ind):
    me = moi()
    maman = troupes_joueur(me)[ind].maman
    return maman

def convertNum(x, y):
    return str(x + y*HAUTEUR)

def convertCoord(i):
    return i%LARGEUR, i//LARGEUR

def getGraph(interdictions=[]):
    graph = []
    for i in range(HAUTEUR):
        row = []
        for j in range(LARGEUR):
            row.append(str(j+i*HAUTEUR))
        graph.append(row)
    dGraph = {}
    for i, row in enumerate(graph):
        for j , el in enumerate(row):
            case = (j, i, 0)
            if info_case(case).contenu != type_case.BUISSON and case not in interdictions:
                dGraph[el] = []
                x, y, z = case
                if x == 0:
                    new_case = (x+1, y, z)
                    if info_case(new_case).contenu != type_case.BUISSON and new_case not in interdictions:
                        dGraph[el].append(convertNum(x+1, y))
                elif x == LARGEUR-1:
                    new_case = (x-1, y, z)
                    if info_case(new_case).contenu != type_case.BUISSON and new_case not in interdictions:
                        dGraph[el].append(convertNum(x-1, y))
                else:
                    new_case = (x+1, y, z)
                    if info_case(new_case).contenu != type_case.BUISSON and new_case not in interdictions:
                        dGraph[el].append(convertNum(x+1, y))
                    new_case = (x-1, y, z)
                    if info_case(new_case).contenu != type_case.BUISSON and new_case not in interdictions:
                        dGraph[el].append(convertNum(x-1, y))
                if y == 0:
                    new_case = (x, y+1, z)
                    if info_case(new_case).contenu != type_case.BUISSON and new_case not in interdictions:
                        dGraph[el].append(convertNum(x, y+1))
                elif y == HAUTEUR-1:
                    new_case = (x, y-1, z)
                    if info_case(new_case).contenu != type_case.BUISSON and new_case not in interdictions:
                        dGraph[el].append(convertNum(x, y-1))
                else:
                    new_case = (x, y-1, z)
                    if info_case(new_case).contenu != type_case.BUISSON and new_case not in interdictions:
                        dGraph[el].append(convertNum(x, y-1))
                    new_case = (x, y+1, z)
                    if info_case(new_case).contenu != type_case.BUISSON and new_case not in interdictions:
                        dGraph[el].append(convertNum(x, y+1))
    return graph, dGraph

def djikstra(from_, to_, graph):
    dgraph = {}
    for node in graph:
        dgraph[node] = [0, float("inf"), "FROM"]
    x, y = from_
    from_ = convertNum(x, y)
    dgraph[from_] = [1, 0, "INIT"] 
    case = from_
    x, y = to_
    caseFinale = convertNum(x, y)
    dist = 0
    prev = []
    while case != caseFinale:
        poss = graph[case]
        allPoss = []
        allDist = []
        for p in poss:
            if dgraph[p][0] == 0:
                allPoss.append(p)
                distance = min(dist+1, dgraph[p][1])
                if distance == dist+1:
                    dgraph[p][1] = distance
                    dgraph[p][2] = case
                allDist.append(distance)
        prev.append(case)
        try:
            newCase = allPoss[allDist.index(min(allDist))]
            dgraph[newCase][0] = [1]
            case = newCase
        except:
            case = prev[-2]
            del prev[-1]
            del prev[-1]
    path = [case]
    distance = dgraph[case][1]
    while case != from_:
        path.append(dgraph[case][2])
        case = dgraph[case][2]
    path = path[::-1]
    return path, distance

def getEL(for_, graph):
    tab = []
    for y, row in enumerate(graph):
        for x, el in enumerate(row): 
            case = (x, y, 0)
            if info_case(case).contenu == for_:
                #case = (x, HAUTEUR-y-1, 0)
                case = (x, y, 0)
                tab.append(case)
    return tab

def getObj(graph, i):
    objectifs = [pains(), getEL(type_case.PAPY, graph), getEL(type_case.NID, graph)]
    mines = 0
    for nid in objectifs[2]:
        if info_nid(nid) == moi():
            mines += 1
    if mines == 0:
        return objectifs[2], "NON"
    if troupes_joueur(moi())[i].inventaire >= 2:
        return objectifs[2], "NON"
    if objectifs[0]:
        return objectifs[0], "OUI"
    
    return objectifs[randint(1, 2)], "OUI"

def newCase(pos, direc):
    x, y, z = pos
    if direc == direction.NORD:
        return (x, y+1, z)
    elif direc == direction.SUD:
        return (x, y-1, z)
    elif direc == direction.EST:
        return (x+1, y, z)
    else:
        return (x-1, y, z)

def notDangerous(case):
    if info_case(case).contenu != type_case.BUISSON:
        canards = []
        for personne in [moi(), adversaire()]:
            for i in range(2):
                canards.extend(troupes_joueur(personne)[i].canards)
        if case not in canards:
            return True
        return False

def partie_init():
    print("Partie INIT")

def jouer_tour():
    graph, dgraph = getGraph()
    for i in range(2):
        debug_poser_pigeon(getPos(i), 1)
        if i == 0:
            obj, g = getObj(graph, i)
            if g == "OUI":
                grandir(getInd(i))
            allDist = []
            allPath = []
            for o in obj:
                road = trouver_chemin(getPos(i), o)
                if len(road) != 0:
                    allDist.append(len(road))
                    allPath.append(road)
            if allDist:
                path = allPath[allDist.index(min(allDist))]
                for direc in path:
                    if notDangerous(newCase(getPos(i), direc)):
                        avancer(getInd(i), direc)
                    
            else:
                pass
            if troupes_joueur(moi())[i].pts_action > 0:
                for o in obj:
                    road = trouver_chemin(getPos(i), o)
                    if len(road) != 0:
                        allDist.append(len(road))
                        allPath.append(road)
                if allDist:
                    path = allPath[allDist.index(min(allDist))]
                    for direc in path:
                        if notDangerous(newCase(getPos(i), direc)):
                            avancer(getInd(i), direc)
                        else:
                            break
        else:
            if randint(0, 3) == 2 and troupes_joueur(moi())[i].pts_action>=3:
                grandir(getInd(i))
            if randint(0, 3) == 0:
                path = trouver_chemin(getPos(i), troupes_joueur(adversaire())[0].maman)
                for el in path:
                    avancer(getInd(i), el)
            else:
                obj, g = getObj(graph, i)
                allDist = []
                allPath = []
                for o in obj:
                    road = trouver_chemin(getPos(i), o)
                    if len(road) != 0:
                        allDist.append(len(road))
                        allPath.append(road)
                if allDist:
                    path = allPath[allDist.index(min(allDist))]
                    for direc in path:
                        if notDangerous(newCase(getPos(i), direc)):
                            avancer(getInd(i), direc)
        

def partie_fin():
    pass
