
from api import *
from random import randint



###########################################################################
#                    Cases pour les Pixel Art en piegons
###########################################################################

coincoin = [
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N B B N B B B N B B B N B N N B N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N B N N B N B N N B N N B B N B N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N B N N B N B N N B N N B N B B N N N"],
    ["N N N N N N N N N N N N N N N N N R R R R R R R R R R R R N N N B B N B B B N B B B N B N N B N N N"],
    ["N N N N N N N N N N N N N N N N R R R R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N R R R R R R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N R R R R R R R R R R R R N N N R R N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N R R R R R R R R R R R R R N B N R R N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N R R R R R R R R R R R R R N N N R V V V V N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N R R R R R R R R R R R R R R R R R R V V V V N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N R R R R R R R R R R R R R R R R R V V V V V N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N R R R R R R R R R R R R R R R R R V V V N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N R R R R R R R R R R R R R R R V V V N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N R R R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N R R R R R R R R N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N R R R R R R R R R N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N R R N N N N N N N R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N R R R R R R R R R R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N R R R R R R R R R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N R R R R R R R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N R R R R R R R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N R R R R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N R R R R R R R R R R R R N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"]
]

pere_hocket = [
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N V N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N V N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N V V V B B B B N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N V B B B B V B B N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N B B B B B B B B N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N B B N N N N B B B B B B B R R N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N B B B B N N N B B B B B B B R R R N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N B B B B B B N N N B B B B B B N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N B B B B B B B N N B B B B B N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N B B B B B N B B B B B B N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N B B B B B B B B B B N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N B B B B B B B V N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N B B B B B B V V N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N B B B B B B V N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N B B B B B B V V N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N B B B B B B V N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N B B B B B B B V N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N B B B B B B N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N B B B B N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N B B B N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N B B B N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"],
    ["N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N N"]
]

debug = False # Activer le debug, soit ebaucoup de textes

def taunt(): # Fonction qui permet de convertir les grilles ci-dessus en pigeons affichés (cf les tours 40/41 des maths)
    tab = (lambda x: coincoin if x==0 else pere_hocket)(randint(0, 1)) # On choisir aléatoirement le pattern utilisé
    for y, ligne in enumerate(tab): 
        y = HAUTEUR - y
        ligne = ligne[0].split(" ")
        for x, lettre in enumerate(ligne):
            coord = (x, y, 0)
            if lettre != "N":
                if lettre == "V":
                    couleur = pigeon_debug.PIGEON_ROUGE
                if lettre == "B":
                    couleur = pigeon_debug.PIGEON_BLEU
                if lettre == "R":
                    couleur = pigeon_debug.PIGEON_JAUNE
                debug_poser_pigeon(coord, couleur)  # On pose les piegons des couleurs choisies

def getGraph(): # Fonction qui retourne un graphe où chaque case a un numéro
    graph = []
    for i in range(HAUTEUR):
        row = []
        for j in range(LARGEUR):
            row.append(str(j+i*HAUTEUR))
        graph.append(row)
    return graph


def getPts(ind): # Avoir les points d'action restants d'une maman
    return troupes_joueur(moi())[ind].pts_action

def getInd(ind): # Avoir l'indexe d'une maman
    me = moi()
    ind = troupes_joueur(me)[ind].id
    return ind

def getPos(ind): # Avoir la position d'une maman
    me = moi()
    maman = troupes_joueur(me)[ind].maman
    return maman

def getSize(ind): # Avoir la taille d'une troupe d'une maman donnée
    me = moi()
    return troupes_joueur(me)[ind].taille

def getInv(ind): # Avoir l'inventaire utilisé par une troupe d'une maman donnée
    return troupes_joueur(moi())[ind].inventaire

def getNearest(tab, from_, sans=None): # Renvoyer la case et le chemin vers celle-ci le plus court avec un tableau de cases cibles et une case de départ
    minDist = float("inf") # Toutes les distances des cases du tableau vers le from_
    allRoad = [] # Toutes les routes sauvegardées
    indexe = 0
    for i, el in enumerate(tab):
        if notDangerous(el) and el != sans:
            path = trouver_chemin(from_, el)
            if len(path) != 0:
                if minDist > len(path):
                    minDist = len(path)
                    allRoad = path
                    indexe = i
    if minDist != float("inf"):
        return tab[indexe], allRoad # On retourne la route la plus petite
    return None, None

def getEL(for_, graph): # Renvoyer toutes les cases d'un type cible
    tab = []
    for y in range(HAUTEUR):
        for x in range(LARGEUR):
            case = (x, y, 0)
            if info_case(case).contenu == for_:
                case = (x, HAUTEUR-y-1, 0)
                case = (x, y, 0)
                tab.append(case)
    return tab

def notCulDeSac(case, prevCases = [], nb=0): # Verifier qu'une case à plus de deux sorties => elle n'est alor spas un cul de sac
    if nb > 4:
        return True
    issues = 0
    x, y, z = case
    okCase = []
    if x+1 < LARGEUR:
        if info_case((x+1, y, z)).contenu != type_case.BUISSON:
            okCase.append((x+1, y, z))
            issues += 1
    if y+1 < HAUTEUR:
        if info_case((x, y+1, z)).contenu != type_case.BUISSON:
            okCase.append((x, y+1, z))
            issues += 1
    if x-1 >= 0:
        if info_case((x-1, y, z)).contenu != type_case.BUISSON:
            okCase.append((x-1, y, z))
            issues += 1
    if y-1 >= 0:
        if info_case((x, y-1, z)).contenu != type_case.BUISSON:
            okCase.append((x, y-1, z))
            issues += 1
    if issues >= 2: # On pourrait faire une fonction récursive et éviter les culs de sacs séparés de plusieurs cases
        return True
    return False

def notDangerous(case): # Vérifier qu'une case n'est pas dangereuse: soit sans canards ni buissons
    if info_case(case).contenu != type_case.BUISSON and notCulDeSac(case):
        canards = []
        for personne in [moi(), adversaire()]:
            for i in range(2):
                canards.extend(troupes_joueur(personne)[i].canards)
        if case not in canards:
            return True
        return False

def newCase(pos, direc): #Renvoyer une nouvelle case en partant d'une case et en allant dans une direction donnée
    x, y, z = pos
    if direc == direction.NORD:
        if y+1 < HAUTEUR:
            return (x, y+1, z)
    elif direc == direction.SUD:
        if y-1 >= 0:
            return (x, y-1, z)
    elif direc == direction.EST:
        if x+1 < LARGEUR:
            return (x+1, y, z)
    if x-1 >= 0:
        return (x-1, y, z)

def getEmptyNids(graph): # Retourner tous les nids encore vides
    global allNids
    emptyNids = []
    for ness in allNids:
        if info_nid(ness) == etat_nid.LIBRE:
            emptyNids.append(ness)
    return emptyNids

def getNidsBase(graph): # Retourner tous les nids d'un joueur
    global allNids
    nids = []
    for ness in allNids:
        if info_nid(ness) == moi()+1:
            nids.append(ness)
    return nids

def grow(maman): # fonction qui permet de grandir si les conditions de tailles max et de points d'actions disponibles sont respectées
    if getPts(maman) >= 3:
        if debug:
            print("GRANDIR")
        grandir(getInd(maman))

def getSpwawPoint(): # avoir les points de spawn
    coord = []
    for canard in troupes_joueur(moi()):
        coord.append(canard.maman)
    for canard in troupes_joueur(adversaire()):
        coord.append(canard.maman)

def partie_init():
    graph = getGraph()
    if debug:
        print("INIT")
    global allNids
    allNids = getEL(type_case.NID, graph)
    global dense
    dense = getDense()
    global spawnCoord
    spawnCoord = getSpwawPoint()
    global allPapis
    allPapis = getEL(type_case.PAPY, graph)

def getDense():
    nb = 0
    for y in range(HAUTEUR):
        for x in range(LARGEUR):
            if info_case((x, y, 0)).contenu == type_case.GAZON:
                nb += 1
    return nb


def jouer_tour():
    global allPapis
    global dense
    if tour_actuel() % 21 == 0: # Faire les PixlArt si on est à un tour multiple de 42
        taunt()
    if debug:
        print("------------------")
        print("PLAYER: {}".format(moi()+1))
        print("tour {}".format(tour_actuel()))
        print("------------------")
    graph = getGraph()
    size0 = min(24, int(dense/42))
    while size0 %3 != 0:
        size0 += 1
    size1 = min((len(allPapis)-3) * 3, 24)
    maman = 0
    debug_poser_pigeon(getPos(0), pigeon_debug.PIGEON_BLEU)
    tourWhile = 0
    while getPts(0) > 0 and getPts(1) > 0:
        tourWhile += 1
        if debug: # Texte pour débogger 
                print("POULE 0: ")
                print("Points de tour: {}".format(getPts(0)))
                print("Taille : {}".format(getSize(0)))
                print("Inventaire: {}\n".format(getInv(0)))
                print("POULE 1")
                print("Points de tour: {}".format(getPts(1)))
                print("Taille : {}".format(getSize(1)))
                print("Inventaire: {}\n".format(getInv(1)))
                print("Nids vides: {}\n".format(len(getEmptyNids(graph))))

        pts0 = getPts(0)
        pts1 = getPts(1)
        empty_nids = getEmptyNids(graph) # Dans un premier temps on récupère tous les nids disponibles
        if empty_nids != []:
            nearest1, path1 = getNearest(empty_nids, getPos(0))
            nearest2, path2 = getNearest(empty_nids, getPos(1))

            if nearest1 == nearest2 and nearest1 != None:
                if len(path1) < len(path2):
                    nearest2, path2 = getNearest(empty_nids, getPos(1), sans=nearest1)
                else:
                    nearest1, path1 = getNearest(empty_nids, getPos(0), sans=nearest2)

            if path1:
                for direct in path1:
                    if getPts(0) > 0:
                        avancer(getInd(0), direct)
                    else:
                        break
            if path2:
                for direct in path2:
                    if getPts(1) > 0:
                        avancer(getInd(1), direct)
                    else:
                        break
        else: # Sinon on va récupérer les autres éléments de la carte
            if getSize(0) < size0:
                grow(0)
            if getSize(1) < size1:
                grow(1)
            pain = pains()
            if pain:
                nearest1, path1 = getNearest(pain, getPos(0))
                nearest2, path2 = getNearest(pain, getPos(1))
                if nearest1 == nearest2 and nearest1 != None:
                    if len(path1) < len(path2):
                        nearest2, path2 = getNearest(pain, getPos(1), sans=nearest1)
                    else:
                        nearest1, path1 = getNearest(pain, getPos(0), sans=nearest2)
                if path1:
                    for direct in path1:
                        if getPts(0) > 0:
                            avancer(getInd(0), direct)
                        else:
                            break
                if path2:
                    for direct in path2:
                        if getPts(1) > 0:
                            avancer(getInd(1), direct)
                        else:
                            break
            myNess = getNidsBase(graph)
            if getInv(0)+1 >= inventaire(getSize(0)): # Si notre inventaire est plein, on se dirige vers le nid le plus proche
                target, path = getNearest(myNess, getPos(0))
                if path:
                    for direct in path:
                        if getPts(0) > 0:
                            avancer(getInd(0), direct)
                        else:
                            break
            if getInv(1)+1 >= inventaire(getSize(1)):
                target, path = getNearest(myNess, getPos(1))
                if path:
                    for direct in path:
                        if getPts(1) > 0:
                            avancer(getInd(1), direct)
                        else:
                            break
            if getPts(0) > 0: # Si il nous reste des points, on se dirige vers les papys
                objectif = allPapis
                target, path = getNearest(objectif, getPos(0))
                if path:
                    for direct in path:
                        if getPts(0) > 0:
                            avancer(getInd(0), direct)
                else:
                    break
                        
            if getPts(1) > 0:
                objectif = allPapis
                target, path = getNearest(objectif, getPos(1))
                if path:
                    for direct in path:
                        if getPts(0) > 0:
                            avancer(getInd(1), direct)
                else:
                    break
              
        if tourWhile > 2:
            break
        
def partie_fin():
    pass